/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BlockItem
extends Block {
    private byte[] mBytes;

    public BlockItem(int bytesLength) {
        this.mBytes = new byte[bytesLength];
    }

    protected void onBytesChanged() {
    }

    protected byte[] getBytesInternal() {
        return this.mBytes;
    }

    void setBytesInternal(byte[] bts) {
        if (bts == null) {
            bts = new byte[]{};
        }
        if (bts == this.mBytes) {
            return;
        }
        this.mBytes = bts;
        this.onBytesChanged();
    }

    final void setBytesLength(int length) {
        this.setBytesLength(length, true);
    }

    protected final void setBytesLength(int length, boolean notify) {
        int old;
        if (length < 0) {
            length = 0;
        }
        if (length == (old = this.mBytes.length)) {
            return;
        }
        byte[] bts = new byte[length];
        if (length < old) {
            old = length;
        }
        System.arraycopy(this.mBytes, 0, bts, 0, old);
        this.mBytes = bts;
        if (notify) {
            this.onBytesChanged();
        }
    }

    int getBytesLength() {
        return this.mBytes.length;
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        return this.getBytesInternal().length;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        return this.getBytesInternal();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        counter.addCount(this.countBytes());
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        reader.readFully(this.getBytesInternal());
        this.onBytesChanged();
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        stream.write(this.getBytesInternal());
        return this.getBytesLength();
    }

    public int readBytes(InputStream inputStream) throws IOException {
        byte[] bts = this.getBytesInternal();
        if (bts == null || bts.length == 0) {
            return 0;
        }
        int length = bts.length;
        int offset = 0;
        int read = length;
        while (length > 0 && read > 0) {
            read = inputStream.read(bts, offset, length);
            length -= read;
            offset += read;
        }
        this.onBytesChanged();
        super.notifyBlockLoad();
        return bts.length;
    }

    protected static int getInteger(byte[] bts, int offset) {
        if (offset + 4 > bts.length) {
            return 0;
        }
        return bts[offset] & 0xFF | (bts[offset + 1] & 0xFF) << 8 | (bts[offset + 2] & 0xFF) << 16 | (bts[offset + 3] & 0xFF) << 24;
    }

    protected static short getShort(byte[] bts, int offset) {
        return (short)(bts[offset] & 0xFF | (bts[offset + 1] & 0xFF) << 8);
    }

    protected static void putInteger(byte[] bts, int offset, int val) {
        if (offset + 4 > bts.length) {
            return;
        }
        bts[offset + 3] = (byte)(val >>> 24 & 0xFF);
        bts[offset + 2] = (byte)(val >>> 16 & 0xFF);
        bts[offset + 1] = (byte)(val >>> 8 & 0xFF);
        bts[offset] = (byte)(val & 0xFF);
    }

    protected static void putShort(byte[] bts, int offset, short val) {
        bts[offset + 1] = (byte)(val >>> 8 & 0xFF);
        bts[offset] = (byte)(val & 0xFF);
    }

    protected static boolean getBit(byte[] bts, int byteOffset, int bitIndex) {
        return ((bts[byteOffset] & 0xFF) >> bitIndex & 1) == 1;
    }

    protected static void putBit(byte[] bytes, int byteOffset, int bitIndex, boolean bit) {
        int mask = 1 << bitIndex;
        int add = bit ? mask : 0;
        mask = ~mask & 0xFF;
        int value = bytes[byteOffset] & mask | add;
        bytes[byteOffset] = (byte)value;
    }

    protected static long getLong(byte[] bytes, int offset) {
        if (offset + 8 > bytes.length) {
            return 0L;
        }
        long result = 0L;
        for (int index = offset + 7; index >= offset; --index) {
            result <<= 8;
            result |= (long)(bytes[index] & 0xFF);
        }
        return result;
    }

    protected static void putLong(byte[] bytes, int offset, long value) {
        if (offset + 8 > bytes.length) {
            return;
        }
        int index = offset;
        offset = index + 8;
        while (index < offset) {
            bytes[index] = (byte)(value & 0xFFL);
            value >>>= 8;
            ++index;
        }
    }
}

