/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.arsc.value.ResConfig;

public class TypeHeader
extends HeaderBlock {
    private final ByteItem id = new ByteItem();
    private final ByteItem flags = new ByteItem();
    private final IntegerItem count;
    private final IntegerItem entriesStart;
    private final ResConfig config;
    private static final byte FLAG_SPARSE = 1;
    private static final int TYPE_MIN_SIZE = 36;

    public TypeHeader(boolean sparse) {
        super(ChunkType.TYPE.ID);
        ShortItem reserved = new ShortItem();
        this.count = new IntegerItem();
        this.entriesStart = new IntegerItem();
        this.config = new ResConfig();
        this.addChild(this.id);
        this.addChild(this.flags);
        this.addChild(reserved);
        this.addChild(this.count);
        this.addChild(this.entriesStart);
        this.addChild(this.config);
        this.setSparse(sparse);
    }

    public boolean isSparse() {
        return (this.getFlags().get() & 1) == 1;
    }

    public void setSparse(boolean sparse) {
        byte flag = this.getFlags().get();
        flag = sparse ? (byte)(flag | 1) : (byte)(flag & 0xFE);
        this.getFlags().set(flag);
    }

    @Override
    public int getMinimumSize() {
        return 36;
    }

    public ByteItem getId() {
        return this.id;
    }

    public ByteItem getFlags() {
        return this.flags;
    }

    public IntegerItem getCount() {
        return this.count;
    }

    public IntegerItem getEntriesStart() {
        return this.entriesStart;
    }

    public ResConfig getConfig() {
        return this.config;
    }

    @Override
    public String toString() {
        if (this.getChunkType() != ChunkType.TYPE) {
            return super.toString();
        }
        return this.getClass().getSimpleName() + " {id=" + this.getId().toHex() + ", flags=" + this.getFlags().toHex() + ", count=" + this.getCount() + ", entriesStart=" + this.getEntriesStart() + ", config=" + this.getConfig() + '}';
    }
}

