/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.group;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArrayCreator;
import com.reandroid.arsc.group.StringGroup;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class ItemGroup<T extends Block> {
    private final BlockArrayCreator<T> mBlockArrayCreator;
    private final String name;
    private T[] items;

    public ItemGroup(BlockArrayCreator<T> blockArrayCreator, String name) {
        this.mBlockArrayCreator = blockArrayCreator;
        this.name = name;
        this.items = blockArrayCreator.newInstance(0);
    }

    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    public Iterator<T> iterator(boolean skipNullBlock) {
        return new GroupIterator(skipNullBlock);
    }

    public List<T> listItems() {
        return new AbstractList<T>(){
            private final int mSize;
            {
                this.mSize = ItemGroup.this.size();
            }

            @Override
            public T get(int i) {
                return ItemGroup.this.get(i);
            }

            @Override
            public int size() {
                return this.mSize;
            }
        };
    }

    public T get(int i) {
        if (i < 0 || i >= this.size()) {
            return null;
        }
        return this.items[i];
    }

    public int size() {
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public boolean contains(T block) {
        if (block == null) {
            return false;
        }
        int len = this.items.length;
        for (int i = 0; i < len; ++i) {
            if (block != this.items[i]) continue;
            return true;
        }
        return false;
    }

    public void remove(T block) {
        if (block == null) {
            return;
        }
        boolean found = false;
        int len = this.items.length;
        for (int i = 0; i < len; ++i) {
            if (block != this.items[i]) continue;
            this.items[i] = null;
            found = true;
        }
        if (found) {
            this.trimToSize();
        }
    }

    public void add(T block) {
        if (block == null) {
            return;
        }
        int index = this.items.length;
        Block[] update = this.createNew(index + 1);
        System.arraycopy(this.items, 0, update, 0, index);
        update[index] = block;
        this.items = update;
    }

    public T[] getItems() {
        return this.items;
    }

    private void trimToSize() {
        int len;
        T[] items = this.items;
        int count = this.countNonNull();
        if (count == (len = items.length)) {
            return;
        }
        Block[] update = this.createNew(count);
        int index = 0;
        for (int i = 0; i < len; ++i) {
            T block = items[i];
            if (block == null) continue;
            update[index] = block;
            ++index;
        }
        this.items = update;
    }

    private int countNonNull() {
        int result = 0;
        for (T t : this.items) {
            if (t == null) continue;
            ++result;
        }
        return result;
    }

    private T[] createNew(int len) {
        return this.mBlockArrayCreator.newInstance(len);
    }

    public int hashCode() {
        return 31 * this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringGroup) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public String toString() {
        return this.items.length + "{" + this.name + "}";
    }

    private class GroupIterator
    implements Iterator<T> {
        private int mCursor;
        private final int mMaxSize;
        private final boolean mSkipNullBlock;

        GroupIterator(boolean skipNullBlock) {
            this.mSkipNullBlock = skipNullBlock;
            this.mCursor = 0;
            this.mMaxSize = ItemGroup.this.size();
        }

        @Override
        public boolean hasNext() {
            this.checkCursor();
            return !this.isFinished();
        }

        @Override
        public T next() {
            if (!this.isFinished()) {
                Object item = ItemGroup.this.get(this.mCursor);
                ++this.mCursor;
                this.checkCursor();
                return item;
            }
            return null;
        }

        private boolean isFinished() {
            return this.mCursor >= this.mMaxSize;
        }

        private void checkCursor() {
            if (!this.mSkipNullBlock || this.isFinished()) {
                return;
            }
            Object item = ItemGroup.this.get(this.mCursor);
            while (item == null || ((Block)item).isNull()) {
                ++this.mCursor;
                item = ItemGroup.this.get(this.mCursor);
                if (this.mCursor < this.mMaxSize) continue;
                break;
            }
        }
    }
}

