/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.group;

import com.reandroid.arsc.base.BlockArrayCreator;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.group.ItemGroup;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import java.util.Iterator;

public class EntryGroup
extends ItemGroup<Entry> {
    private final int resourceId;
    private static final BlockArrayCreator<Entry> ARRAY_CREATOR = new BlockArrayCreator<Entry>(){

        @Override
        public Entry newInstance() {
            return new Entry();
        }

        public Entry[] newInstance(int len) {
            return new Entry[len];
        }
    };

    public EntryGroup(int resId) {
        super(ARRAY_CREATOR, String.valueOf(resId));
        this.resourceId = resId;
    }

    public Entry getEntry(ResConfig resConfig) {
        Entry[] items = (Entry[])this.getItems();
        if (items == null || resConfig == null) {
            return null;
        }
        for (Entry entry : items) {
            if (entry == null || entry.isNull() || !resConfig.equals(entry.getResConfig())) continue;
            return entry;
        }
        return null;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public boolean renameSpec(String name) {
        String oldName;
        Entry[] items = (Entry[])this.getItems();
        if (items == null || name == null) {
            return false;
        }
        SpecStringPool specStringPool = this.getSpecStringPool();
        if (specStringPool == null) {
            return false;
        }
        if (this.isAllSameSpec() && name.equals(oldName = this.getSpecName())) {
            return false;
        }
        SpecString specString = (SpecString)specStringPool.getOrCreate(name);
        return this.renameSpec(specString.getIndex());
    }

    public short getEntryId() {
        return (short)(this.getResourceId() & 0xFFFF);
    }

    private boolean isAllSameSpec() {
        Entry first = null;
        for (Entry entry : this.listItems()) {
            if (first == null) {
                first = entry;
                continue;
            }
            if (first.getSpecReference() == entry.getSpecReference()) continue;
            return false;
        }
        return true;
    }

    public boolean renameSpec(int specReference) {
        Entry[] items = (Entry[])this.getItems();
        if (items == null) {
            return false;
        }
        boolean renameOk = false;
        for (Entry block : items) {
            if (block == null || block.getSpecReference() == specReference) continue;
            block.setSpecReference(specReference);
            renameOk = true;
        }
        return renameOk;
    }

    public Entry pickOne() {
        Entry[] items = (Entry[])this.getItems();
        if (items == null) {
            return null;
        }
        Entry result = null;
        for (Entry entry : items) {
            if (entry == null) continue;
            if (entry.isDefault() && !entry.isNull()) {
                return entry;
            }
            result = result == null || result.isNull() ? entry : this.choose(result, entry);
        }
        return result;
    }

    private Entry choose(Entry entry1, Entry entry2) {
        if (entry1 == null || entry1 == entry2) {
            return entry2;
        }
        if (entry2 == null) {
            return entry1;
        }
        if (entry1.isNull() && !entry2.isNull()) {
            return entry2;
        }
        if (!entry1.isNull() && entry2.isNull()) {
            return entry1;
        }
        if (entry1.isDefault()) {
            return entry1;
        }
        if (entry2.isDefault()) {
            return entry2;
        }
        ResConfig config1 = entry1.getResConfig();
        ResConfig config2 = entry2.getResConfig();
        if (config1 == null && config2 == null) {
            return entry1;
        }
        if (config1 == null) {
            return entry2;
        }
        if (config2 == null) {
            return entry1;
        }
        boolean lang1 = this.isDefaultLanguage(config1);
        boolean lang2 = this.isDefaultLanguage(config2);
        if (lang1 && !lang2 || !lang1 && !lang2) {
            return entry1;
        }
        if (!lang1) {
            return entry2;
        }
        String region1 = config1.getRegion();
        String region2 = config2.getRegion();
        if (region1 != null && region2 == null || region1 == null && region2 == null) {
            return entry1;
        }
        if (region1 == null) {
            return entry2;
        }
        return entry1;
    }

    private boolean isDefaultLanguage(ResConfig resConfig) {
        String lang = resConfig.getLanguage();
        if (lang == null) {
            return true;
        }
        return "en".equals(lang);
    }

    public Entry getDefault() {
        return this.getDefault(true);
    }

    public Entry getDefault(boolean skipNull) {
        Iterator itr = this.iterator(skipNull);
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            if (!entry.isDefault()) continue;
            return entry;
        }
        return null;
    }

    public TypeString getTypeString() {
        Entry entry = this.pickOne();
        if (entry != null) {
            return entry.getTypeString();
        }
        return null;
    }

    public SpecString getSpecString() {
        Entry entry = this.pickOne();
        if (entry != null) {
            return entry.getSpecString();
        }
        return null;
    }

    public String getTypeName() {
        TypeString typeString = this.getTypeString();
        if (typeString == null) {
            return null;
        }
        return typeString.get();
    }

    public String getSpecName() {
        SpecString specString = this.getSpecString();
        if (specString == null) {
            return null;
        }
        return specString.get();
    }

    private SpecStringPool getSpecStringPool() {
        Entry entry = (Entry)this.get(0);
        if (entry == null) {
            return null;
        }
        TypeBlock typeBlock = entry.getTypeBlock();
        if (typeBlock == null) {
            return null;
        }
        PackageBlock packageBlock = typeBlock.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        return packageBlock.getSpecStringPool();
    }

    @Override
    public int hashCode() {
        return this.resourceId;
    }

    @Override
    public String toString() {
        Entry entry = this.pickOne();
        if (entry == null) {
            return super.toString();
        }
        return super.toString() + "{" + entry.toString() + "}";
    }
}

