/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.array.EntryArray;
import com.reandroid.arsc.array.TypeBlockArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockContainer;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.SpecBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.group.ItemGroup;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.TypeHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SpecTypePair
extends BlockContainer<Block>
implements JSONConvert<JSONObject>,
Comparable<SpecTypePair> {
    private final Block[] mChildes;
    private final SpecBlock mSpecBlock;
    private final TypeBlockArray mTypeBlockArray;
    public static final String NAME_types = "types";
    public static final String NAME_sparse_types = "sparse_types";

    public SpecTypePair(SpecBlock specBlock, TypeBlockArray typeBlockArray) {
        this.mSpecBlock = specBlock;
        this.mTypeBlockArray = typeBlockArray;
        this.mChildes = new Block[]{specBlock, typeBlockArray};
        specBlock.setIndex(0);
        typeBlockArray.setIndex(1);
        specBlock.setParent(this);
        typeBlockArray.setParent(this);
    }

    public SpecTypePair() {
        this(new SpecBlock(), new TypeBlockArray());
    }

    public Boolean hasComplexEntry() {
        return this.getTypeBlockArray().hasComplexEntry();
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        for (TypeBlock typeBlock : this.listTypeBlocks()) {
            typeBlock.linkTableStringsInternal(tableStringPool);
        }
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        for (TypeBlock typeBlock : this.listTypeBlocks()) {
            typeBlock.linkSpecStringsInternal(specStringPool);
        }
    }

    public Map<Integer, EntryGroup> createEntryGroups() {
        return this.createEntryGroups(false);
    }

    public Map<Integer, EntryGroup> createEntryGroups(boolean skipNullEntries) {
        LinkedHashMap<Integer, EntryGroup> map = new LinkedHashMap<Integer, EntryGroup>();
        for (TypeBlock typeBlock : this.listTypeBlocks()) {
            EntryArray entryArray = typeBlock.getEntryArray();
            for (Entry entry : entryArray.listItems(skipNullEntries)) {
                if (entry == null) continue;
                int id = entry.getResourceId();
                EntryGroup entryGroup = (EntryGroup)map.get(id);
                if (entryGroup == null) {
                    entryGroup = new EntryGroup(id);
                    map.put(id, entryGroup);
                }
                entryGroup.add(entry);
            }
        }
        return map;
    }

    public EntryGroup createEntryGroup(int id) {
        id = 0xFFFF & id;
        ItemGroup entryGroup = null;
        for (TypeBlock typeBlock : this.listTypeBlocks()) {
            Entry entry = typeBlock.getEntry(id);
            if (entry == null) continue;
            if (entryGroup == null) {
                entryGroup = new EntryGroup(entry.getResourceId());
            }
            entryGroup.add(entry);
        }
        return entryGroup;
    }

    public EntryGroup getEntryGroup(String entryName) {
        ItemGroup entryGroup = null;
        for (TypeBlock typeBlock : this.listTypeBlocks()) {
            Entry entry = typeBlock.getEntry(entryName);
            if (entry == null) continue;
            if (entryGroup == null) {
                entryGroup = new EntryGroup(entry.getResourceId());
            }
            entryGroup.add(entry);
        }
        return entryGroup;
    }

    public void destroy() {
        this.getSpecBlock().destroy();
        this.getTypeBlockArray().destroy();
    }

    public Entry getAnyEntry(short entryId) {
        Entry result = null;
        TypeBlock[] types = (TypeBlock[])this.getTypeBlockArray().getChildes();
        for (int i = 0; i < types.length; ++i) {
            Entry entry;
            TypeBlock typeBlock = types[i];
            if (typeBlock == null || (entry = typeBlock.getEntry(entryId)) == null) continue;
            if (!entry.isNull()) {
                return entry;
            }
            if (result != null) continue;
            result = entry;
        }
        return result;
    }

    public Entry getAnyEntry(String name) {
        TypeBlock[] types = (TypeBlock[])this.getTypeBlockArray().getChildes();
        for (int i = 0; i < types.length; ++i) {
            Entry entry;
            TypeBlock typeBlock = types[i];
            if (typeBlock == null || (entry = typeBlock.getEntry(name)) == null) continue;
            return entry;
        }
        return null;
    }

    public Entry getEntry(ResConfig resConfig, String entryName) {
        return this.getTypeBlockArray().getEntry(resConfig, entryName);
    }

    public void sortTypes() {
        this.getTypeBlockArray().sort();
    }

    public boolean removeNullEntries(int startId) {
        startId = 0xFFFF & startId;
        boolean removed = this.getTypeBlockArray().removeNullEntries(startId);
        if (!removed) {
            return false;
        }
        this.getSpecBlock().setEntryCount(startId);
        return true;
    }

    public void removeEmptyTypeBlocks() {
        this.getTypeBlockArray().removeEmptyBlocks();
    }

    public boolean isEmpty() {
        return this.getTypeBlockArray().isEmpty();
    }

    public int countTypeBlocks() {
        return this.getTypeBlockArray().childesCount();
    }

    public Entry getOrCreateEntry(short entryId, String qualifiers) {
        return this.getTypeBlockArray().getOrCreateEntry(entryId, qualifiers);
    }

    public Entry getEntry(short entryId, String qualifiers) {
        return this.getTypeBlockArray().getEntry(entryId, qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(String qualifiers) {
        return this.getTypeBlockArray().getOrCreate(qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(ResConfig resConfig) {
        return this.getTypeBlockArray().getOrCreate(resConfig);
    }

    public TypeBlock getTypeBlock(String qualifiers) {
        return this.getTypeBlockArray().getTypeBlock(qualifiers);
    }

    public TypeBlock getTypeBlock(ResConfig resConfig) {
        return this.getTypeBlockArray().getTypeBlock(resConfig);
    }

    public List<ResConfig> listResConfig() {
        return this.mTypeBlockArray.listResConfig();
    }

    public Iterator<TypeBlock> iteratorNonEmpty() {
        return this.mTypeBlockArray.iteratorNonEmpty();
    }

    public boolean hasDuplicateResConfig(boolean ignoreEmpty) {
        return this.mTypeBlockArray.hasDuplicateResConfig(ignoreEmpty);
    }

    public byte getTypeId() {
        return this.mSpecBlock.getTypeId();
    }

    public int getId() {
        return this.mSpecBlock.getId();
    }

    public void setTypeId(byte id) {
        this.mSpecBlock.setTypeId(id);
        this.mTypeBlockArray.setTypeId(id);
    }

    public String getTypeName() {
        TypeString typeString = this.getTypeString();
        if (typeString != null) {
            return typeString.get();
        }
        return null;
    }

    public boolean isEqualTypeName(String typeName) {
        return TypeBlock.isEqualTypeName(this.getTypeName(), typeName);
    }

    @Deprecated
    public Entry searchByEntryName(String entryName) {
        return this.getTypeBlockArray().searchByEntryName(entryName);
    }

    public SpecBlock getSpecBlock() {
        return this.mSpecBlock;
    }

    public TypeBlockArray getTypeBlockArray() {
        return this.mTypeBlockArray;
    }

    public PackageBlock getPackageBlock() {
        return this.getParent(PackageBlock.class);
    }

    public List<Entry> listEntries(int entryId) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        Iterator itr = this.mTypeBlockArray.iterator(true);
        while (itr.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)itr.next();
            Entry entry = typeBlock.getEntry(entryId);
            if (entry == null || entry.isNull()) continue;
            results.add(entry);
        }
        return results;
    }

    public List<Entry> listEntries(String entryName) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        Iterator itr = this.mTypeBlockArray.iterator(true);
        while (itr.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)itr.next();
            Entry entry = typeBlock.getEntry(entryName);
            if (entry == null) continue;
            results.add(entry);
        }
        return results;
    }

    public Collection<TypeBlock> listTypeBlocks() {
        return this.getTypeBlockArray().listItems();
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    public int childesCount() {
        return this.mChildes.length;
    }

    public Block[] getChildes() {
        return this.mChildes;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.TYPE) {
            this.readTypeBlock(reader);
            return;
        }
        if (chunkType != ChunkType.SPEC) {
            this.readUnexpectedNonSpecBlock(reader, headerBlock);
        }
        this.mSpecBlock.readBytes(reader);
    }

    private void readTypeBlock(BlockReader reader) throws IOException {
        TypeHeader typeHeader = reader.readTypeHeader();
        TypeBlock typeBlock = this.mTypeBlockArray.createNext(typeHeader.isSparse());
        typeBlock.readBytes(reader);
    }

    private void readUnexpectedNonSpecBlock(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unexpected block: " + headerBlock.toString() + ", Should be: " + (Object)((Object)ChunkType.SPEC));
    }

    public int getHighestEntryCount() {
        return this.getTypeBlockArray().getHighestEntryCount();
    }

    public TypeString getTypeString() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getTypeStringPool().getById(this.getId());
        }
        return null;
    }

    @Override
    public JSONObject toJson() {
        return this.toJson(false);
    }

    @Override
    public void fromJson(JSONObject json) {
        this.getSpecBlock().fromJson(json.getJSONObject("spec"));
        this.getTypeBlockArray().fromJson(json.optJSONArray(NAME_types));
    }

    public JSONObject toJson(boolean specOnly) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("spec", this.getSpecBlock().toJson());
        if (!specOnly) {
            jsonObject.put(NAME_types, this.getTypeBlockArray().toJson());
        }
        return jsonObject;
    }

    public void merge(SpecTypePair typePair) {
        if (typePair == null || typePair == this) {
            return;
        }
        if (this.getTypeId() != typePair.getTypeId()) {
            throw new IllegalArgumentException("Can not merge different id types: " + this.getTypeId() + "!=" + typePair.getTypeId());
        }
        this.getSpecBlock().merge(typePair.getSpecBlock());
        this.getTypeBlockArray().merge(typePair.getTypeBlockArray());
    }

    @Override
    public int compareTo(SpecTypePair specTypePair) {
        return Integer.compare(this.getId(), specTypePair.getId());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(HexUtil.toHex2(this.getTypeId()));
        builder.append(" (");
        TypeString ts = this.getTypeString();
        if (ts != null) {
            builder.append(ts.get());
        } else {
            builder.append("null");
        }
        builder.append(") config count=");
        builder.append(this.getTypeBlockArray().childesCount());
        return builder.toString();
    }
}

