/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockContainer;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.OutputStream;

public class SingleBlockContainer<T extends Block>
extends BlockContainer<T> {
    private T mItem;

    @Override
    protected void refreshChildes() {
        if (this.mItem != null && this.mItem instanceof BlockContainer) {
            ((BlockContainer)this.mItem).refresh();
        }
    }

    @Override
    protected void onRefreshed() {
    }

    public T getItem() {
        return this.mItem;
    }

    public void setItem(T item) {
        if (item == null) {
            if (this.mItem != null) {
                ((Block)this.mItem).setIndex(-1);
                ((Block)this.mItem).setParent(null);
            }
            this.mItem = null;
            return;
        }
        this.mItem = item;
        ((Block)item).setIndex(this.getIndex());
        ((Block)item).setParent(this);
    }

    public boolean hasItem() {
        return this.mItem != null;
    }

    @Override
    public byte[] getBytes() {
        if (this.mItem != null) {
            return ((Block)this.mItem).getBytes();
        }
        return null;
    }

    @Override
    public int countBytes() {
        if (this.mItem != null) {
            return ((Block)this.mItem).countBytes();
        }
        return 0;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        if (this.mItem != null) {
            ((Block)this.mItem).onCountUpTo(counter);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (this.mItem != null) {
            ((Block)this.mItem).readBytes(reader);
        }
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        if (this.mItem != null) {
            return ((Block)this.mItem).writeBytes(stream);
        }
        return 0;
    }

    @Override
    public int childesCount() {
        return this.hasItem() ? 0 : 1;
    }

    @Override
    public T[] getChildes() {
        return null;
    }

    public String toString() {
        if (this.mItem != null) {
            return this.mItem.toString();
        }
        return this.getClass().getSimpleName() + ": EMPTY";
    }
}

