/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.CommonType;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.Value;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.common.EntryStore;
import java.util.Collection;
import java.util.Iterator;

public class ValueDecoder {
    public static String escapeSpecialCharacter(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        if (ValueDecoder.isSpecialCharacter(text.charAt(0))) {
            return '\\' + text;
        }
        return text;
    }

    public static String unEscapeUnQuote(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        char first = text.charAt(0);
        if (first == '\"') {
            return ValueDecoder.unQuoteWhitespace(text);
        }
        if (first != '\\' || !ValueDecoder.isSpecialCharacter(text.charAt(1))) {
            return text;
        }
        return text.substring(1);
    }

    public static String unEscapeSpecialCharacter(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        if (text.charAt(0) != '\\' || !ValueDecoder.isSpecialCharacter(text.charAt(1))) {
            return text;
        }
        return text.substring(1);
    }

    public static String quoteWhitespace(String text) {
        if (!ValueDecoder.isWhiteSpace(text)) {
            return text;
        }
        return "\"" + text + "\"";
    }

    public static String unQuoteWhitespace(String text) {
        if (text == null || text.length() < 3) {
            return text;
        }
        if (text.charAt(0) != '\"' || text.charAt(text.length() - 1) != '\"') {
            return text;
        }
        String unQuoted = text.substring(1, text.length() - 1);
        if (!ValueDecoder.isWhiteSpace(unQuoted)) {
            return text;
        }
        return unQuoted;
    }

    private static boolean isWhiteSpace(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ValueDecoder.isWhiteSpace(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static boolean isSpecialCharacter(char ch) {
        switch (ch) {
            case '#': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    public static EncodeResult encodeColor(String value) {
        return ValueCoder.encode(value, CommonType.COLOR.valueTypes());
    }

    public static EncodeResult encodeDimensionOrFraction(String value) {
        EncodeResult encodeResult = ValueCoder.encode(value, ValueType.DIMENSION);
        if (encodeResult == null) {
            encodeResult = ValueCoder.encode(value, ValueType.FRACTION);
        }
        return encodeResult;
    }

    public static String decodeAttributeName(EntryStore store, PackageBlock currentPackage, int resourceId) {
        String other;
        String name;
        EntryGroup entryGroup = ValueDecoder.searchEntryGroup(store, currentPackage, resourceId);
        if (entryGroup == null) {
            return ValueCoder.decodeUnknownResourceId(true, resourceId);
        }
        Entry entry = entryGroup.pickOne();
        if (entry == null) {
            return ValueCoder.decodeUnknownResourceId(true, resourceId);
        }
        String prefix = null;
        if (currentPackage != null && !(name = currentPackage.getName()).equals(other = entry.getPackageBlock().getName())) {
            prefix = other + ":";
        }
        name = entryGroup.getSpecName();
        if (prefix != null) {
            name = prefix + name;
        }
        return name;
    }

    public static String decodeAttribute(EntryStore store, int attrResId, int rawValue) {
        AttributeBag attributeBag = ValueDecoder.getAttributeBag(store, attrResId);
        if (attributeBag == null) {
            return null;
        }
        return attributeBag.decodeAttributeValue(store, rawValue);
    }

    public static String decodeEntryValue(EntryStore store, PackageBlock currentPackage, ValueType valueType, int data) {
        if (store == null || currentPackage == null) {
            return null;
        }
        if (valueType == ValueType.STRING) {
            return ValueDecoder.decodeIntEntryString(currentPackage, data);
        }
        boolean is_reference = false;
        boolean is_attribute = false;
        if (valueType == ValueType.REFERENCE) {
            if (data == 0) {
                return "@null";
            }
            is_reference = true;
        }
        if (valueType == ValueType.ATTRIBUTE) {
            if (data == 0) {
                return "?null";
            }
            is_attribute = true;
        }
        if (is_reference || is_attribute) {
            String ref = ValueDecoder.buildReferenceValue(store, valueType, currentPackage.getName(), data);
            if (ref != null) {
                return ref;
            }
            return ValueCoder.decodeUnknownResourceId(is_reference, data);
        }
        return ValueDecoder.decode(valueType, data);
    }

    public static String decode(EntryStore entryStore, int currentPackageId, Value value) {
        ValueType valueType = value.getValueType();
        if (valueType == ValueType.STRING) {
            return value.getValueAsString();
        }
        int data = value.getData();
        if (valueType == ValueType.REFERENCE || valueType == ValueType.ATTRIBUTE) {
            String currentPackageName = ValueDecoder.getPackageName(entryStore, currentPackageId);
            return ValueDecoder.buildReferenceValue(entryStore, valueType, currentPackageName, data);
        }
        return ValueDecoder.decode(valueType, data);
    }

    public static String decode(EntryStore entryStore, int currentPackageId, AttributeValue attributeValue) {
        String result;
        ValueType valueType = attributeValue.getValueType();
        if (valueType == ValueType.STRING) {
            return attributeValue.getValueAsString();
        }
        int data = attributeValue.getData();
        if (valueType == ValueType.REFERENCE || valueType == ValueType.ATTRIBUTE) {
            String currentPackageName = ValueDecoder.getPackageName(entryStore, currentPackageId);
            return ValueDecoder.buildReferenceValue(entryStore, valueType, currentPackageName, data);
        }
        if ((valueType == ValueType.DEC || valueType == ValueType.HEX) && (result = ValueDecoder.decodeAttribute(entryStore, attributeValue.getNameResourceID(), attributeValue.getData())) != null) {
            return result;
        }
        return ValueDecoder.decode(valueType, data);
    }

    public static String decode(ValueType valueType, int data) {
        return ValueCoder.decode(valueType, data);
    }

    public static String buildReference(String currentPackageName, String referredPackageName, char atOrQues, String typeName, String resourceName) {
        StringBuilder builder = new StringBuilder();
        if (atOrQues != '\u0000') {
            builder.append(atOrQues);
        }
        if (!(ValueDecoder.isEqualString(currentPackageName, referredPackageName) || ValueDecoder.isEmpty(currentPackageName) || ValueDecoder.isEmpty(referredPackageName))) {
            builder.append(referredPackageName);
            if (!referredPackageName.endsWith(":")) {
                builder.append(':');
            }
        }
        if (!ValueDecoder.isEmpty(typeName)) {
            builder.append(typeName);
            builder.append('/');
        }
        builder.append(resourceName);
        return builder.toString();
    }

    private static String buildReferenceValue(EntryStore entryStore, ValueType valueType, String currentPackageName, int resourceId) {
        char atOrQues;
        if (valueType == ValueType.REFERENCE) {
            if (resourceId == 0) {
                return "@null";
            }
            atOrQues = '@';
        } else if (valueType == ValueType.ATTRIBUTE) {
            if (resourceId == 0) {
                return "?null";
            }
            atOrQues = '?';
        } else {
            return null;
        }
        EntryGroup value = null;
        if (entryStore != null) {
            value = entryStore.getEntryGroup(resourceId);
        }
        if (value == null) {
            return ValueCoder.decodeUnknownResourceId(valueType != ValueType.ATTRIBUTE, resourceId);
        }
        String referredPackageName = ValueDecoder.getPackageName(value);
        String typeName = value.getTypeName();
        String name = value.getSpecName();
        return ValueDecoder.buildReference(currentPackageName, referredPackageName, atOrQues, typeName, name);
    }

    private static String getPackageName(EntryStore entryStore, int packageOrResourceId) {
        Collection<PackageBlock> allPkg;
        if (entryStore == null || packageOrResourceId == 0) {
            return null;
        }
        int pkgId = packageOrResourceId >> 24 & 0xFF;
        if (pkgId == 0) {
            pkgId = packageOrResourceId;
        }
        if ((allPkg = entryStore.getPackageBlocks(pkgId &= 0xFF)) == null) {
            return null;
        }
        for (PackageBlock packageBlock : allPkg) {
            String name = packageBlock.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private static String getPackageName(EntryGroup entryGroup) {
        if (entryGroup == null) {
            return null;
        }
        return ValueDecoder.getPackageName(entryGroup.pickOne());
    }

    private static String getPackageName(Entry entry) {
        if (entry == null) {
            return null;
        }
        PackageBlock packageBlock = entry.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        return packageBlock.getName();
    }

    private static EntryGroup searchEntryGroup(EntryStore store, PackageBlock packageBlock, int resourceId) {
        TableBlock tableBlock;
        if (packageBlock != null && (tableBlock = packageBlock.getTableBlock()) != null) {
            for (PackageBlock pkg : tableBlock.listPackages()) {
                EntryGroup entryGroup = pkg.getEntryGroup(resourceId);
                if (entryGroup == null) continue;
                return entryGroup;
            }
        }
        if (store != null) {
            return store.getEntryGroup(resourceId);
        }
        return null;
    }

    private static String decodeIntEntryString(PackageBlock packageBlock, int data) {
        if (packageBlock == null) {
            return null;
        }
        TableBlock tableBlock = packageBlock.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        TableStringPool pool = tableBlock.getTableStringPool();
        TableString tableString = (TableString)pool.get(data);
        if (tableString == null) {
            return null;
        }
        return ValueDecoder.escapeSpecialCharacter(tableString.getHtml());
    }

    private static AttributeBag getAttributeBag(EntryStore store, int resourceId) {
        ResTableMapEntry mapEntry = ValueDecoder.getAttributeValueBag(store, resourceId);
        if (mapEntry == null) {
            return null;
        }
        return AttributeBag.create((ResValueMapArray)mapEntry.getValue());
    }

    private static ResTableMapEntry getAttributeValueBag(EntryStore store, int resourceId) {
        if (store == null) {
            return null;
        }
        Collection<EntryGroup> foundGroups = store.getEntryGroups(resourceId);
        ResTableMapEntry best = null;
        for (EntryGroup group : foundGroups) {
            ResTableMapEntry valueBag = ValueDecoder.getAttributeValueBag(group);
            best = ValueDecoder.chooseBest(best, valueBag);
        }
        return best;
    }

    private static ResTableMapEntry getAttributeValueBag(EntryGroup entryGroup) {
        if (entryGroup == null) {
            return null;
        }
        ResTableMapEntry best = null;
        Iterator iterator = entryGroup.iterator(true);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            ResTableMapEntry valueBag = ValueDecoder.getAttributeValueBag(entry);
            best = ValueDecoder.chooseBest(best, valueBag);
        }
        return best;
    }

    private static ResTableMapEntry getAttributeValueBag(Entry entry) {
        if (entry == null) {
            return null;
        }
        TableEntry<?, ?> tableEntry = entry.getTableEntry();
        if (tableEntry instanceof ResTableMapEntry) {
            return (ResTableMapEntry)tableEntry;
        }
        return null;
    }

    private static ResTableMapEntry chooseBest(ResTableMapEntry entry1, ResTableMapEntry entry2) {
        if (entry1 == null) {
            return entry2;
        }
        if (entry2 == null) {
            return entry1;
        }
        if (((ResValueMapArray)entry2.getValue()).childesCount() > ((ResValueMapArray)entry1.getValue()).childesCount()) {
            return entry2;
        }
        return entry1;
    }

    private static boolean isEqualString(String str1, String str2) {
        if (ValueDecoder.isEmpty(str1)) {
            return ValueDecoder.isEmpty(str2);
        }
        return str1.equals(str2);
    }

    private static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return (str = str.trim()).length() == 0;
    }
}

