/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.CoderBoolean;
import com.reandroid.arsc.coder.CoderColorARGB4;
import com.reandroid.arsc.coder.CoderColorARGB8;
import com.reandroid.arsc.coder.CoderColorRGB4;
import com.reandroid.arsc.coder.CoderColorRGB8;
import com.reandroid.arsc.coder.CoderDimension;
import com.reandroid.arsc.coder.CoderFloat;
import com.reandroid.arsc.coder.CoderFraction;
import com.reandroid.arsc.coder.CoderHex;
import com.reandroid.arsc.coder.CoderInteger;
import com.reandroid.arsc.coder.CoderNull;
import com.reandroid.arsc.coder.CoderNullAttribute;
import com.reandroid.arsc.coder.CoderNullReference;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.ValueType;
import java.util.HashMap;
import java.util.Map;

public class ValueCoder {
    private static final String UNKNOWN_RESOURCE_ID_PREFIX_ATTR;
    private static final String UNKNOWN_RESOURCE_ID_PREFIX_REF;
    private static final int UNKNOWN_RESOURCE_ID_LENGTH_ATTR;
    private static final int UNKNOWN_RESOURCE_ID_LENGTH_REF;
    private static final char UNKNOWN_RESOURCE_ID_FIRST;
    public static final Coder[] CODERS;
    private static final Map<ValueType, Coder> CODER_MAP;
    private static final Coder[] CODERS_NULL;

    public static String decodeUnknownResourceId(boolean is_reference, int referenceId) {
        String prefix = is_reference ? UNKNOWN_RESOURCE_ID_PREFIX_REF : UNKNOWN_RESOURCE_ID_PREFIX_ATTR;
        return HexUtil.toHex8(prefix, referenceId);
    }

    public static EncodeResult encodeUnknownResourceId(String text) {
        int referenceId;
        ValueType valueType;
        String prefix;
        if (text == null) {
            return null;
        }
        EncodeResult encodeResult = ValueCoder.encodeNull(text);
        if (encodeResult != null) {
            return encodeResult;
        }
        int length = text.length();
        if (length != UNKNOWN_RESOURCE_ID_LENGTH_ATTR && length != UNKNOWN_RESOURCE_ID_LENGTH_REF) {
            return null;
        }
        if (text.startsWith(UNKNOWN_RESOURCE_ID_PREFIX_ATTR)) {
            prefix = UNKNOWN_RESOURCE_ID_PREFIX_ATTR;
            valueType = ValueType.ATTRIBUTE;
        } else if (text.startsWith(UNKNOWN_RESOURCE_ID_PREFIX_REF)) {
            prefix = UNKNOWN_RESOURCE_ID_PREFIX_REF;
            valueType = ValueType.REFERENCE;
        } else {
            return null;
        }
        String hexString = text.substring(prefix.length());
        try {
            referenceId = HexUtil.parseHex(hexString);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return new EncodeResult(valueType, referenceId);
    }

    public static EncodeResult encode(String text, AttributeDataFormat ... expectedDataFormats) {
        if (expectedDataFormats == null || expectedDataFormats.length == 0) {
            return ValueCoder.encodeAny(text);
        }
        return ValueCoder.encodeWithin(text, expectedDataFormats);
    }

    public static EncodeResult encode(String text, ValueType ... expectedTypes) {
        if (expectedTypes == null || expectedTypes.length == 0) {
            return ValueCoder.encodeAny(text);
        }
        return ValueCoder.encodeWithin(text, expectedTypes);
    }

    public static EncodeResult encode(String text) {
        return ValueCoder.encodeAny(text);
    }

    private static EncodeResult encodeWithin(String text, AttributeDataFormat ... expectedDataFormats) {
        if (text == null || text.length() == 0) {
            return null;
        }
        for (AttributeDataFormat dataFormat : expectedDataFormats) {
            EncodeResult encodeResult = ValueCoder.encodeWithin(text, dataFormat.valueTypes());
            if (encodeResult == null) continue;
            return encodeResult;
        }
        return null;
    }

    private static EncodeResult encodeWithin(String text, ValueType ... expectedTypes) {
        EncodeResult encodeResult;
        if (text == null || text.length() == 0) {
            return null;
        }
        char first = text.charAt(0);
        if (first == UNKNOWN_RESOURCE_ID_FIRST && (encodeResult = ValueCoder.encodeUnknownResourceId(text)) != null) {
            return encodeResult;
        }
        for (ValueType valueType : expectedTypes) {
            Coder coder = ValueCoder.getCoder(valueType);
            if (coder == null || !coder.canStartWith(first) || (encodeResult = coder.encode(text)) == null) continue;
            return encodeResult;
        }
        return null;
    }

    private static EncodeResult encodeAny(String text) {
        EncodeResult encodeResult;
        if (text == null || text.length() == 0) {
            return null;
        }
        char first = text.charAt(0);
        if (first == UNKNOWN_RESOURCE_ID_FIRST && (encodeResult = ValueCoder.encodeUnknownResourceId(text)) != null) {
            return encodeResult;
        }
        for (Coder coder : CODERS) {
            if (!coder.canStartWith(first) || (encodeResult = coder.encode(text)) == null) continue;
            return encodeResult;
        }
        return null;
    }

    public static String decode(ValueType valueType, int data) {
        String decoded = ValueCoder.decodeNull(valueType, data);
        if (decoded != null) {
            return decoded;
        }
        Coder coder = CODER_MAP.get((Object)valueType);
        if (coder == null) {
            return null;
        }
        return coder.decode(data);
    }

    private static EncodeResult encodeNull(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length != 5 && length != 6) {
            return null;
        }
        char first = text.charAt(0);
        for (Coder coder : CODERS_NULL) {
            EncodeResult encodeResult;
            if (!coder.canStartWith(first) || (encodeResult = coder.encode(text)) == null) continue;
            return encodeResult;
        }
        return null;
    }

    private static String decodeNull(ValueType valueType, int data) {
        if (data != 0 && data != 1) {
            return null;
        }
        if (valueType == ValueType.NULL) {
            return CoderNull.INS.decode(data);
        }
        if (data != 0) {
            return null;
        }
        if (valueType == ValueType.ATTRIBUTE) {
            return CoderNullAttribute.INS.decode(data);
        }
        if (valueType == ValueType.REFERENCE) {
            return CoderNullReference.INS.decode(data);
        }
        return null;
    }

    public static Coder getCoder(ValueType valueType) {
        return CODER_MAP.get((Object)valueType);
    }

    static {
        String prefix;
        UNKNOWN_RESOURCE_ID_FIRST = (char)85;
        UNKNOWN_RESOURCE_ID_PREFIX_ATTR = prefix = "UNK_ATTR0x";
        UNKNOWN_RESOURCE_ID_LENGTH_ATTR = prefix.length() + 8;
        UNKNOWN_RESOURCE_ID_PREFIX_REF = prefix = "UNK_REF0x";
        UNKNOWN_RESOURCE_ID_LENGTH_REF = prefix.length() + 8;
        CODERS = new Coder[]{CoderNull.INS, CoderBoolean.INS, CoderDimension.INS, CoderFraction.INS, CoderColorARGB4.INS, CoderColorRGB4.INS, CoderColorRGB8.INS, CoderColorARGB8.INS, CoderFloat.INS, CoderHex.INS, CoderInteger.INS};
        HashMap<ValueType, Coder> map = new HashMap<ValueType, Coder>();
        map.put(CoderNull.INS.getValueType(), CoderNull.INS);
        map.put(CoderBoolean.INS.getValueType(), CoderBoolean.INS);
        map.put(CoderDimension.INS.getValueType(), CoderDimension.INS);
        map.put(CoderFraction.INS.getValueType(), CoderFraction.INS);
        map.put(CoderColorRGB4.INS.getValueType(), CoderColorRGB4.INS);
        map.put(CoderColorARGB4.INS.getValueType(), CoderColorARGB4.INS);
        map.put(CoderColorRGB8.INS.getValueType(), CoderColorRGB8.INS);
        map.put(CoderColorARGB8.INS.getValueType(), CoderColorARGB8.INS);
        map.put(CoderFloat.INS.getValueType(), CoderFloat.INS);
        map.put(CoderHex.INS.getValueType(), CoderHex.INS);
        map.put(CoderInteger.INS.getValueType(), CoderInteger.INS);
        CODER_MAP = map;
        CODERS_NULL = new Coder[]{CoderNullReference.INS, CoderNullAttribute.INS, CoderNull.INS};
    }
}

