/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.apk.AndroidFrameworks;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.util.FrameworkTable;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Value;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.EntryStore;
import java.io.IOException;

public class Decoder {
    private final EntryStore entryStore;
    private int currentPackageId;
    private ApkFile mApkFile;
    private static NullEntryDecoder NULL_ENTRY_STORE_DECODER;

    public Decoder(EntryStore entryStore, int currentPackageId) {
        this.entryStore = entryStore;
        this.currentPackageId = currentPackageId;
    }

    public String decodeResourceName(int resourceId) {
        return this.decodeResourceName(resourceId, true);
    }

    public String decodeResourceName(int resourceId, boolean defaultHex) {
        if (resourceId == 0) {
            return null;
        }
        EntryGroup entryGroup = this.getEntryStore().getEntryGroup(resourceId);
        if (entryGroup != null) {
            return entryGroup.getSpecName();
        }
        if (defaultHex) {
            return this.hexResourceName(resourceId);
        }
        return null;
    }

    private String hexResourceName(int resourceId) {
        return ValueCoder.decodeUnknownResourceId(false, resourceId);
    }

    public String decodeValue(Value value) {
        if (value == null) {
            return null;
        }
        ValueType valueType = value.getValueType();
        if (valueType == ValueType.STRING) {
            return value.getValueAsString();
        }
        return ValueDecoder.decode(this.getEntryStore(), this.getCurrentPackageId(), value);
    }

    public String decodeAttributeValue(AttributeValue attributeValue) {
        return this.decodeAttributeValue(attributeValue, true);
    }

    public String decodeAttributeValue(AttributeValue attributeValue, boolean escapeStartChar) {
        if (attributeValue == null) {
            return null;
        }
        String result = ValueDecoder.decode(this.getEntryStore(), this.getCurrentPackageId(), attributeValue);
        if (!escapeStartChar || result == null || result.length() == 0 || attributeValue.getValueType() != ValueType.STRING) {
            return result;
        }
        return ValueDecoder.escapeSpecialCharacter(result);
    }

    private EntryStore getEntryStore() {
        return this.entryStore;
    }

    public int getCurrentPackageId() {
        return this.currentPackageId;
    }

    public void setCurrentPackageId(int currentPackageId) {
        this.currentPackageId = currentPackageId;
    }

    public ApkFile getApkFile() {
        return this.mApkFile;
    }

    public void setApkFile(ApkFile apkFile) {
        this.mApkFile = apkFile;
    }

    public boolean isNullDecoder() {
        return false;
    }

    public static Decoder create(ResXmlDocument resXmlDocument) {
        int currentPackageId;
        MainChunk mainChunk = resXmlDocument.getMainChunk();
        if (mainChunk == null) {
            return Decoder.getNullEntryStoreDecoder();
        }
        ApkFile apkFile = mainChunk.getApkFile();
        if (apkFile == null) {
            return Decoder.getNullEntryStoreDecoder();
        }
        TableBlock tableBlock = apkFile.getTableBlock();
        if (tableBlock == null) {
            return Decoder.getNullEntryStoreDecoder();
        }
        AndroidManifestBlock manifestBlock = apkFile.getAndroidManifestBlock();
        if (manifestBlock != null && (currentPackageId = manifestBlock.guessCurrentPackageId()) != 0) {
            return Decoder.create(tableBlock, currentPackageId);
        }
        return Decoder.create(tableBlock);
    }

    public static Decoder create(TableBlock tableBlock) {
        PackageBlock packageBlock;
        if (!tableBlock.hasFramework() && !tableBlock.isAndroid()) {
            tableBlock.addFramework(Decoder.getFramework());
        }
        int currentPackageId = (packageBlock = tableBlock.pickOne()) != null ? packageBlock.getId() : 127;
        return Decoder.create(tableBlock, currentPackageId);
    }

    public static Decoder create(TableBlock tableBlock, int currentPackageId) {
        PackageBlock packageBlock;
        TableBlock framework;
        if (!tableBlock.hasFramework() && !tableBlock.isAndroid() && (framework = Decoder.getFramework()) != null && (packageBlock = framework.pickOne()) != null && packageBlock.getId() != currentPackageId) {
            tableBlock.addFramework(framework);
        }
        return new Decoder(tableBlock, currentPackageId);
    }

    private static TableBlock getFramework() {
        try {
            FrameworkApk frameworkApk = AndroidFrameworks.getCurrent();
            if (frameworkApk == null) {
                frameworkApk = AndroidFrameworks.getLatest();
                AndroidFrameworks.setCurrent(frameworkApk);
            }
            return frameworkApk.getTableBlock();
        }
        catch (IOException iOException) {
            return new FrameworkTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Decoder getNullEntryStoreDecoder() {
        if (NULL_ENTRY_STORE_DECODER != null) {
            return NULL_ENTRY_STORE_DECODER;
        }
        Class<Decoder> clazz = Decoder.class;
        synchronized (Decoder.class) {
            NullEntryDecoder decoder;
            NULL_ENTRY_STORE_DECODER = decoder = new NullEntryDecoder(Decoder.getFramework(), 127);
            // ** MonitorExit[var0] (shouldn't be in output)
            return decoder;
        }
    }

    static class NullEntryDecoder
    extends Decoder {
        public NullEntryDecoder(EntryStore entryStore, int currentPackageId) {
            super(entryStore, currentPackageId);
        }

        @Override
        public boolean isNullDecoder() {
            return true;
        }
    }
}

