/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.ValueType;

public class CoderHex
extends Coder {
    public static final CoderHex INS = new CoderHex();

    @Override
    public EncodeResult encode(String text) {
        int length = text.length();
        if (length < 3 || length > 10) {
            return null;
        }
        if (text.charAt(1) != 'x') {
            return null;
        }
        Integer value = CoderHex.parseHex(text);
        if (value == null) {
            return null;
        }
        return new EncodeResult(ValueType.HEX, value);
    }

    @Override
    public String decode(int data) {
        return HexUtil.toHex8(data);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.HEX;
    }

    @Override
    boolean canStartWith(char first) {
        return first == '0';
    }
}

