/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.ValueType;

public abstract class Coder {
    public abstract EncodeResult encode(String var1);

    public abstract String decode(int var1);

    public abstract ValueType getValueType();

    abstract boolean canStartWith(char var1);

    static Integer parseInteger(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    static Integer parseHex(String text) {
        try {
            return HexUtil.parseHex(text);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    static Float parseFloat(String text) {
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    static boolean isNumberStart(char ch) {
        return ch == '-' || ch <= '9' && ch >= '0';
    }
}

