/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlText;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.json.JSONObject;
import com.reandroid.xml.XMLText;

public class ResXmlTextNode
extends ResXmlNode {
    private final ResXmlText resXmlText;
    public static final String NAME_text = "text";

    public ResXmlTextNode(ResXmlText resXmlText) {
        super(1);
        this.resXmlText = resXmlText;
        this.addChild(0, resXmlText);
    }

    public ResXmlTextNode() {
        this(new ResXmlText());
    }

    public ResXmlText getResXmlText() {
        return this.resXmlText;
    }

    public int getLineNumber() {
        return this.getResXmlText().getLineNumber();
    }

    public String getComment() {
        return this.getResXmlText().getComment();
    }

    @Override
    public int getDepth() {
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            return parent.getDepth() + 1;
        }
        return 0;
    }

    @Override
    void addEvents(ParserEventList parserEventList) {
        String comment = this.getComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, false));
        }
        parserEventList.add(new ParserEvent(4, this));
    }

    public ResXmlElement getParentResXmlElement() {
        return this.getResXmlText().getParentResXmlElement();
    }

    public void setLineNumber(int lineNumber) {
        this.getResXmlText().setLineNumber(lineNumber);
    }

    public String getText() {
        return this.getResXmlText().getText();
    }

    public void setText(String text) {
        this.getResXmlText().setText(text);
    }

    public int getTextReference() {
        return this.getResXmlText().getTextReference();
    }

    public void setTextReference(int ref) {
        this.getResXmlText().setTextReference(ref);
    }

    @Override
    void onRemoved() {
        this.getResXmlText().onRemoved();
    }

    @Override
    void linkStringReferences() {
        this.getResXmlText().linkStringReferences();
    }

    public String toString() {
        String txt = this.getText();
        if (txt != null) {
            return txt;
        }
        return super.toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("node_type", NAME_text);
        jsonObject.put(NAME_text, this.getText());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setText(json.optString(NAME_text, null));
    }

    public XMLText decodeToXml() {
        XMLText xmlText = new XMLText(ValueDecoder.escapeSpecialCharacter(this.getText()));
        xmlText.setLineNumber(this.getLineNumber());
        return xmlText;
    }
}

