/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.xml.SchemaAttr;
import com.reandroid.xml.XMLAttribute;
import java.util.HashSet;
import java.util.Set;

public class ResXmlStartNamespace
extends ResXmlNamespace {
    private final Set<ResXmlAttribute> mReferencedAttributes = new HashSet<ResXmlAttribute>();

    public ResXmlStartNamespace() {
        super(ChunkType.XML_START_NAMESPACE);
    }

    public ResXmlEndNamespace getEnd() {
        return (ResXmlEndNamespace)this.getPair();
    }

    public void setEnd(ResXmlEndNamespace namespace) {
        this.setPair(namespace);
    }

    @Override
    void linkStringReferences() {
        super.linkStringReferences();
        ResXmlEndNamespace end = this.getEnd();
        if (end != null) {
            end.linkStringReferences();
        }
    }

    @Override
    void onRemoved() {
        ResXmlEndNamespace end = this.getEnd();
        if (end != null) {
            end.onRemoved();
        }
        this.mReferencedAttributes.clear();
    }

    public boolean hasReferencedAttributes() {
        return this.mReferencedAttributes.size() > 0;
    }

    public void clearReferencedAttributes() {
        this.mReferencedAttributes.clear();
    }

    public Set<ResXmlAttribute> getReferencedAttributes() {
        return this.mReferencedAttributes;
    }

    void addAttributeReference(ResXmlAttribute attribute) {
        if (attribute != null) {
            this.mReferencedAttributes.add(attribute);
        }
    }

    void removeAttributeReference(ResXmlAttribute attribute) {
        if (attribute != null) {
            this.mReferencedAttributes.remove(attribute);
        }
    }

    public XMLAttribute decodeToXml() {
        String uri = this.getUri();
        String prefix = this.getPrefix();
        if (this.isEmpty(uri) || this.isEmpty(prefix)) {
            return null;
        }
        SchemaAttr schemaAttr = new SchemaAttr(prefix, uri);
        schemaAttr.setLineNumber(this.getLineNumber());
        return schemaAttr;
    }

    private boolean isEmpty(String txt) {
        if (txt == null) {
            return true;
        }
        return (txt = txt.trim()).length() == 0;
    }
}

