/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.array.ResXmlAttributeArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.BaseXmlChunk;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.XmlNodeHeader;
import com.reandroid.arsc.item.ShortItem;
import java.util.Collection;

public class ResXmlStartElement
extends BaseXmlChunk {
    private final ShortItem mAttributeStart = new ShortItem(20);
    private final ShortItem mAttributeUnitSize = new ShortItem(20);
    private final ShortItem mAttributeCount = new ShortItem();
    private final ShortItem mIdAttributePosition = new ShortItem();
    private final ShortItem mClassAttributePosition = new ShortItem();
    private final ShortItem mStyleAttributePosition = new ShortItem();
    private final ResXmlAttributeArray mAttributeArray = new ResXmlAttributeArray((HeaderBlock)this.getHeaderBlock(), this.mAttributeStart, this.mAttributeCount, this.mAttributeUnitSize);
    private ResXmlEndElement mResXmlEndElement;
    private static final short ATTRIBUTES_UNIT_SIZE = 20;
    private static final short ATTRIBUTES_DEFAULT_START = 20;
    private static final String ATTRIBUTE_NAME_CLASS = "class";
    private static final String ATTRIBUTE_NAME_STYLE = "style";
    private static final int ATTRIBUTE_RESOURCE_ID_id = 0x10100D0;

    public ResXmlStartElement() {
        super(ChunkType.XML_START_ELEMENT, 7);
        this.addChild(this.mAttributeStart);
        this.addChild(this.mAttributeUnitSize);
        this.addChild(this.mAttributeCount);
        this.addChild(this.mIdAttributePosition);
        this.addChild(this.mClassAttributePosition);
        this.addChild(this.mStyleAttributePosition);
        this.addChild(this.mAttributeArray);
    }

    public int removeUndefinedAttributes() {
        return this.getResXmlAttributeArray().removeUndefinedAttributes();
    }

    public ResXmlAttribute getIdAttribute() {
        return (ResXmlAttribute)this.getResXmlAttributeArray().get(this.mIdAttributePosition.unsignedInt() - 1);
    }

    public ResXmlAttribute getClassAttribute() {
        return (ResXmlAttribute)this.getResXmlAttributeArray().get(this.mClassAttributePosition.unsignedInt() - 1);
    }

    public ResXmlAttribute getStyleAttribute() {
        return (ResXmlAttribute)this.getResXmlAttributeArray().get(this.mStyleAttributePosition.unsignedInt() - 1);
    }

    void setAttributesUnitSize(int size) {
        this.mAttributeArray.setAttributesUnitSize(size);
    }

    public ResXmlAttribute newAttribute() {
        ResXmlAttributeArray attributeArray = this.getResXmlAttributeArray();
        return (ResXmlAttribute)attributeArray.createNext();
    }

    @Override
    void linkStringReferences() {
        super.linkStringReferences();
        ResXmlEndElement end = this.getResXmlEndElement();
        if (end != null) {
            end.linkStringReferences();
        }
    }

    @Override
    void onRemoved() {
        super.onRemoved();
        ResXmlEndElement end = this.getResXmlEndElement();
        if (end != null) {
            end.onRemoved();
        }
        for (ResXmlAttribute attr : this.listResXmlAttributes()) {
            attr.onRemoved();
        }
    }

    @Override
    protected void onPreRefreshRefresh() {
        this.sortAttributes();
    }

    private void sortAttributes() {
        ResXmlAttributeArray array = this.getResXmlAttributeArray();
        ResXmlAttribute idAttribute = (ResXmlAttribute)array.get(this.mIdAttributePosition.get() - 1);
        ResXmlAttribute classAttribute = (ResXmlAttribute)array.get(this.mClassAttributePosition.get() - 1);
        ResXmlAttribute styleAttribute = (ResXmlAttribute)array.get(this.mStyleAttributePosition.get() - 1);
        array.sortAttributes();
        if (idAttribute != null) {
            this.mIdAttributePosition.set((short)(idAttribute.getIndex() + 1));
        }
        if (classAttribute != null) {
            this.mClassAttributePosition.set((short)(classAttribute.getIndex() + 1));
            if (!ATTRIBUTE_NAME_CLASS.equals(classAttribute.getName())) {
                classAttribute.setName(ATTRIBUTE_NAME_CLASS, 0);
            }
        }
        if (styleAttribute != null) {
            this.mStyleAttributePosition.set((short)(styleAttribute.getIndex() + 1));
            if (!ATTRIBUTE_NAME_STYLE.equals(styleAttribute.getName())) {
                styleAttribute.setName(ATTRIBUTE_NAME_STYLE, 0);
            }
        }
    }

    void calculatePositions() {
        ResXmlAttribute idAttribute = this.getAttribute(0x10100D0);
        ResXmlAttribute classAttribute = this.getNoIdAttribute(ATTRIBUTE_NAME_CLASS);
        ResXmlAttribute styleAttribute = this.getNoIdAttribute(ATTRIBUTE_NAME_STYLE);
        if (idAttribute != null) {
            this.mIdAttributePosition.set((short)(idAttribute.getIndex() + 1));
        }
        if (classAttribute != null) {
            this.mClassAttributePosition.set((short)(classAttribute.getIndex() + 1));
        }
        if (styleAttribute != null) {
            this.mStyleAttributePosition.set((short)(styleAttribute.getIndex() + 1));
        }
    }

    public ResXmlAttribute getAttribute(int resourceId) {
        for (ResXmlAttribute attribute : this.listResXmlAttributes()) {
            if (resourceId != attribute.getNameResourceID()) continue;
            return attribute;
        }
        return null;
    }

    private ResXmlAttribute getNoIdAttribute(String name) {
        for (ResXmlAttribute attribute : this.listResXmlAttributes()) {
            if (attribute.getNameResourceID() != 0 || !name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public ResXmlAttribute getAttribute(String uri, String name) {
        if (name == null) {
            return null;
        }
        for (ResXmlAttribute attribute : this.listResXmlAttributes()) {
            if (!name.equals(attribute.getName()) && !name.equals(attribute.getFullName())) continue;
            if (uri != null) {
                if (!uri.equals(attribute.getUri())) continue;
                return attribute;
            }
            return attribute;
        }
        return null;
    }

    public ResXmlAttribute searchAttributeByName(String name) {
        if (name == null) {
            return null;
        }
        for (ResXmlAttribute attribute : this.listResXmlAttributes()) {
            if (!name.equals(attribute.getName()) && !name.equals(attribute.getFullName())) continue;
            return attribute;
        }
        return null;
    }

    public ResXmlAttribute searchAttributeByResourceId(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        for (ResXmlAttribute attribute : this.listResXmlAttributes()) {
            if (resourceId != attribute.getNameResourceID()) continue;
            return attribute;
        }
        return null;
    }

    public String getTagName() {
        String prefix = this.getPrefix();
        String name = this.getName();
        if (prefix == null) {
            return name;
        }
        return prefix + ":" + name;
    }

    public void setName(String name) {
        this.setString(name);
        ResXmlEndElement endElement = this.getResXmlEndElement();
        if (endElement != null) {
            endElement.setString(name);
        }
    }

    public Collection<ResXmlAttribute> listResXmlAttributes() {
        return this.getResXmlAttributeArray().listItems();
    }

    public ResXmlAttributeArray getResXmlAttributeArray() {
        return this.mAttributeArray;
    }

    @Override
    public String getUri() {
        int uriRef = this.getNamespaceReference();
        if (uriRef < 0) {
            return null;
        }
        ResXmlElement parentElement = this.getParentResXmlElement();
        ResXmlStartNamespace startNamespace = parentElement.getStartNamespaceByUriRef(uriRef);
        if (startNamespace != null) {
            return startNamespace.getUri();
        }
        return null;
    }

    public String getPrefix() {
        int uriRef = this.getNamespaceReference();
        if (uriRef < 0) {
            return null;
        }
        ResXmlElement parentElement = this.getParentResXmlElement();
        ResXmlStartNamespace startNamespace = parentElement.getStartNamespaceByUriRef(uriRef);
        if (startNamespace != null) {
            return startNamespace.getPrefix();
        }
        return null;
    }

    public void setResXmlEndElement(ResXmlEndElement element) {
        this.mResXmlEndElement = element;
    }

    public ResXmlEndElement getResXmlEndElement() {
        return this.mResXmlEndElement;
    }

    @Override
    protected void onChunkRefreshed() {
        this.refreshAttributeStart();
        this.refreshAttributeCount();
    }

    private void refreshAttributeStart() {
        int start = this.countUpTo(this.mAttributeArray);
        this.mAttributeStart.set((short)(start -= ((XmlNodeHeader)this.getHeaderBlock()).getHeaderSize()));
    }

    private void refreshAttributeCount() {
        int count = this.mAttributeArray.childesCount();
        this.mAttributeCount.set((short)count);
    }

    @Override
    public String toString() {
        String txt = this.getTagName();
        if (txt == null) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(txt);
        ResXmlAttribute[] allAttr = (ResXmlAttribute[])this.mAttributeArray.getChildes();
        if (allAttr != null) {
            for (int i = 0; i < allAttr.length && i <= 10; ++i) {
                builder.append(" ");
                builder.append(allAttr[i].toString());
            }
        }
        return builder.toString();
    }
}

