/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import android.content.res.XmlResourceParser;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.coder.Decoder;
import com.reandroid.arsc.value.ValueType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ResXmlPullParser
implements XmlResourceParser {
    private Decoder mDecoder;
    private final ParserEventList mEventList = new ParserEventList();
    private ResXmlDocument mDocument;
    private boolean mDocumentCreatedHere;
    private DocumentLoadedListener documentLoadedListener;
    private boolean processNamespaces;
    private boolean reportNamespaceAttrs;
    private boolean mIsTagStared;

    public ResXmlPullParser(Decoder decoder) {
        this.mDecoder = decoder;
        this.processNamespaces = false;
        this.reportNamespaceAttrs = false;
    }

    public ResXmlPullParser() {
        this(null);
    }

    public synchronized ResXmlPullParser getParser() {
        if (this.isBusy()) {
            return new ResXmlPullParser(this.getDecoder());
        }
        this.closeDocument();
        return this;
    }

    public synchronized boolean isBusy() {
        return !this.mEventList.hasNext();
    }

    public synchronized void setResXmlDocument(ResXmlDocument xmlDocument) {
        this.closeDocument();
        this.mDocument = xmlDocument;
        this.initDefaultFeatures();
        this.initializeDecoder(xmlDocument);
        xmlDocument.addEvents(this.mEventList);
    }

    public ResXmlDocument getResXmlDocument() {
        return this.mDocument;
    }

    public void setDecoder(Decoder decoder) {
        this.mDecoder = decoder;
    }

    public Decoder getDecoder() {
        return this.mDecoder;
    }

    private void initializeDecoder(ResXmlDocument xmlDocument) {
        Decoder decoder = this.mDecoder;
        if (decoder != null) {
            if (decoder.getApkFile() == null) {
                decoder.setApkFile(xmlDocument.getApkFile());
            }
            return;
        }
        ApkFile apkFile = xmlDocument.getApkFile();
        if (apkFile != null && (decoder = apkFile.getDecoder()) != null) {
            this.mDecoder = decoder;
            return;
        }
        this.mDecoder = Decoder.create(xmlDocument);
    }

    public void closeDocument() {
        this.mEventList.clear();
        this.mIsTagStared = false;
        this.destroyDocument();
    }

    private void destroyDocument() {
        if (!this.mDocumentCreatedHere) {
            return;
        }
        this.mDocumentCreatedHere = false;
        if (this.mDocument == null) {
            return;
        }
        this.mDocument.destroy();
        this.mDocument = null;
    }

    @Override
    public void close() {
        this.closeDocument();
    }

    @Override
    public int getAttributeCount() {
        ResXmlElement element = this.getCurrentElement();
        if (element == null) {
            return 0;
        }
        int count = element.getAttributeCount();
        if (this.isCountNamespacesAsAttribute()) {
            count += element.getNamespaceCount();
        }
        return count;
    }

    @Override
    public String getAttributeName(int index) {
        int nsCount;
        if (this.isCountNamespacesAsAttribute() && index < (nsCount = this.getNamespaceCountInternal())) {
            return this.getNamespaceAttributeName(index);
        }
        return this.decodeAttributeName(this.getResXmlAttributeAt(index));
    }

    @Override
    public String getAttributeValue(int index) {
        int nsCount;
        if (this.isCountNamespacesAsAttribute() && index < (nsCount = this.getNamespaceCountInternal())) {
            return this.getNamespaceAttributeValue(index);
        }
        return this.decodeAttributeValue(this.getResXmlAttributeAt(index));
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        return this.decodeAttributeValue(this.getAttribute(namespace, name));
    }

    @Override
    public String getPositionDescription() {
        return null;
    }

    @Override
    public int getAttributeNameResource(int index) {
        ResXmlAttribute attribute = this.getResXmlAttributeAt(index);
        if (attribute != null) {
            return attribute.getNameResourceID();
        }
        return 0;
    }

    @Override
    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute == null) {
            return 0;
        }
        List<String> list = Arrays.asList(options);
        int index = list.indexOf(this.decodeAttributeValue(xmlAttribute));
        if (index == -1) {
            return defaultValue;
        }
        return index;
    }

    @Override
    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute == null || xmlAttribute.getValueType() != ValueType.BOOLEAN) {
            return defaultValue;
        }
        return xmlAttribute.getValueAsBoolean();
    }

    @Override
    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute == null) {
            return 0;
        }
        ValueType valueType = xmlAttribute.getValueType();
        if (valueType == ValueType.ATTRIBUTE || valueType == ValueType.REFERENCE || valueType == ValueType.DYNAMIC_ATTRIBUTE || valueType == ValueType.DYNAMIC_REFERENCE) {
            return xmlAttribute.getData();
        }
        return defaultValue;
    }

    @Override
    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute == null) {
            return 0;
        }
        ValueType valueType = xmlAttribute.getValueType();
        if (valueType == ValueType.DEC || valueType == ValueType.HEX) {
            return xmlAttribute.getData();
        }
        return defaultValue;
    }

    @Override
    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute == null) {
            return 0;
        }
        ValueType valueType = xmlAttribute.getValueType();
        if (valueType == ValueType.DEC) {
            return xmlAttribute.getData();
        }
        return defaultValue;
    }

    @Override
    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        ResXmlAttribute xmlAttribute = this.getAttribute(namespace, attribute);
        if (xmlAttribute == null) {
            return 0.0f;
        }
        ValueType valueType = xmlAttribute.getValueType();
        if (valueType == ValueType.FLOAT) {
            return Float.intBitsToFloat(xmlAttribute.getData());
        }
        return defaultValue;
    }

    @Override
    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute == null) {
            return 0;
        }
        List<String> list = Arrays.asList(options);
        int i = list.indexOf(this.decodeAttributeValue(xmlAttribute));
        if (i == -1) {
            return defaultValue;
        }
        return index;
    }

    @Override
    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute == null || xmlAttribute.getValueType() != ValueType.BOOLEAN) {
            return defaultValue;
        }
        return xmlAttribute.getValueAsBoolean();
    }

    @Override
    public int getAttributeResourceValue(int index, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute == null) {
            return 0;
        }
        ValueType valueType = xmlAttribute.getValueType();
        if (valueType == ValueType.ATTRIBUTE || valueType == ValueType.REFERENCE || valueType == ValueType.DYNAMIC_ATTRIBUTE || valueType == ValueType.DYNAMIC_REFERENCE) {
            return xmlAttribute.getData();
        }
        return defaultValue;
    }

    @Override
    public int getAttributeIntValue(int index, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute == null) {
            return defaultValue;
        }
        return xmlAttribute.getData();
    }

    @Override
    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute == null) {
            return 0;
        }
        return xmlAttribute.getData();
    }

    @Override
    public float getAttributeFloatValue(int index, float defaultValue) {
        ResXmlAttribute xmlAttribute = this.getResXmlAttributeAt(index);
        if (xmlAttribute == null) {
            return 0.0f;
        }
        ValueType valueType = xmlAttribute.getValueType();
        if (valueType == ValueType.FLOAT) {
            return Float.intBitsToFloat(xmlAttribute.getData());
        }
        return defaultValue;
    }

    @Override
    public String getIdAttribute() {
        ResXmlAttribute attribute;
        ResXmlStartElement startElement = this.getResXmlStartElement();
        if (startElement != null && (attribute = startElement.getIdAttribute()) != null) {
            return attribute.getName();
        }
        return null;
    }

    @Override
    public String getClassAttribute() {
        ResXmlAttribute attribute;
        ResXmlStartElement startElement = this.getResXmlStartElement();
        if (startElement != null && (attribute = startElement.getClassAttribute()) != null) {
            return attribute.getName();
        }
        return null;
    }

    @Override
    public int getIdAttributeResourceValue(int defaultValue) {
        ResXmlAttribute attribute;
        ResXmlStartElement startElement = this.getResXmlStartElement();
        if (startElement != null && (attribute = startElement.getIdAttribute()) != null) {
            return attribute.getNameResourceID();
        }
        return 0;
    }

    @Override
    public int getStyleAttribute() {
        ResXmlAttribute attribute;
        ResXmlStartElement startElement = this.getResXmlStartElement();
        if (startElement != null && (attribute = startElement.getStyleAttribute()) != null) {
            return attribute.getNameResourceID();
        }
        return 0;
    }

    @Override
    public void setFeature(String name, boolean state) throws XmlPullParserException {
        boolean changed;
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            changed = this.processNamespaces != state;
            this.processNamespaces = state;
        } else if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name)) {
            changed = this.reportNamespaceAttrs != state;
            this.reportNamespaceAttrs = state;
        } else {
            throw new XmlPullParserException("Unsupported feature: " + name);
        }
        if (changed && this.mIsTagStared) {
            throw new XmlPullParserException("Feature changed during parsing: " + name + ", state=" + state);
        }
    }

    @Override
    public boolean getFeature(String name) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            return this.processNamespaces;
        }
        if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name)) {
            return this.reportNamespaceAttrs;
        }
        return false;
    }

    @Override
    public void setProperty(String name, Object value) throws XmlPullParserException {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setInput(Reader in) throws XmlPullParserException {
        InputStream inputStream = ResXmlPullParser.getFromLock(in);
        if (inputStream == null) {
            throw new XmlPullParserException("Can't parse binary xml from reader");
        }
        this.setInput(inputStream, null);
    }

    @Override
    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.loadResXmlDocument(inputStream);
    }

    @Override
    public String getInputEncoding() {
        return "UTF-8";
    }

    @Override
    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
    }

    @Override
    public int getNamespaceCount(int depth) throws XmlPullParserException {
        ResXmlElement element;
        if (this.isCountNamespacesAsAttribute()) {
            return 0;
        }
        for (element = this.getCurrentElement(); element != null && element.getDepth() > depth; element = element.getParentResXmlElement()) {
        }
        if (element != null) {
            return element.getNamespaceCount();
        }
        return 0;
    }

    @Override
    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getNamespace(pos).getPrefix();
        }
        return null;
    }

    @Override
    public String getNamespaceUri(int pos) throws XmlPullParserException {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getNamespace(pos).getUri();
        }
        return null;
    }

    @Override
    public String getNamespace(String prefix) {
        ResXmlStartNamespace startNamespace;
        ResXmlElement element = this.getCurrentElement();
        if (element != null && (startNamespace = element.getStartNamespaceByPrefix(prefix)) != null) {
            return startNamespace.getUri();
        }
        return null;
    }

    @Override
    public int getDepth() {
        int event = this.mEventList.getType();
        if (event == 2 || event == 3 || event == 4) {
            return this.mEventList.getXmlNode().getDepth();
        }
        return 0;
    }

    @Override
    public int getLineNumber() {
        return this.mEventList.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return 0;
    }

    @Override
    public boolean isWhitespace() throws XmlPullParserException {
        String text = this.getText();
        if (text == null) {
            return true;
        }
        return (text = text.trim()).length() == 0;
    }

    @Override
    public String getText() {
        return this.mEventList.getText();
    }

    @Override
    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String text = this.getText();
        if (text == null) {
            holderForStartAndLength[0] = -1;
            holderForStartAndLength[1] = -1;
            return null;
        }
        char[] result = text.toCharArray();
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = result.length;
        return result;
    }

    @Override
    public String getNamespace() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getTagUri();
        }
        return null;
    }

    @Override
    public String getName() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getTag();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getTagPrefix();
        }
        return null;
    }

    @Override
    public boolean isEmptyElementTag() throws XmlPullParserException {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.countResXmlNodes() == 0 && element.getAttributeCount() == 0;
        }
        return true;
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.processNamespaces) {
            return null;
        }
        ResXmlAttribute attribute = this.getResXmlAttributeAt(index);
        if (attribute != null) {
            return attribute.getUri();
        }
        return null;
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.processNamespaces) {
            return null;
        }
        ResXmlAttribute attribute = this.getResXmlAttributeAt(index);
        if (attribute != null) {
            return attribute.getNamePrefix();
        }
        return null;
    }

    @Override
    public String getAttributeType(int index) {
        return "CDATA";
    }

    @Override
    public boolean isAttributeDefault(int index) {
        return false;
    }

    private String decodeAttributeName(ResXmlAttribute attribute) {
        String name;
        if (attribute == null) {
            return null;
        }
        int resourceId = attribute.getNameResourceID();
        if (resourceId == 0 || this.mDecoder == null) {
            name = attribute.getName();
        } else {
            name = this.mDecoder.decodeResourceName(attribute.getNameResourceID(), true);
            if (this.processNamespaces) {
                name = attribute.getNamePrefix() + ":" + name;
            }
        }
        return name;
    }

    private String decodeAttributeValue(ResXmlAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        return this.mDecoder.decodeAttributeValue(attribute);
    }

    public ResXmlAttribute getResXmlAttributeAt(int index) {
        index = this.getRealAttributeIndex(index);
        ResXmlElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        return element.getAttributeAt(index);
    }

    public ResXmlAttribute getAttribute(String namespace, String name) {
        ResXmlElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        for (ResXmlAttribute attribute : element.listAttributes()) {
            if (!Objects.equals(namespace, attribute.getUri()) || !Objects.equals(name, attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    private ResXmlStartElement getResXmlStartElement() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getStartElement();
        }
        return null;
    }

    public ResXmlElement getCurrentElement() {
        int type = this.mEventList.getType();
        if (type == 2 || type == 3) {
            return this.mEventList.getElement();
        }
        return null;
    }

    private int getRealAttributeIndex(int index) {
        if (this.isCountNamespacesAsAttribute()) {
            index -= this.getNamespaceCountInternal();
        }
        return index;
    }

    private int getNamespaceCountInternal() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getNamespaceCount();
        }
        return 0;
    }

    private boolean isCountNamespacesAsAttribute() {
        return this.processNamespaces & this.reportNamespaceAttrs;
    }

    private String getNamespaceAttributeName(int index) {
        ResXmlStartNamespace namespace = this.getCurrentElement().getNamespace(index);
        String prefix = namespace.getPrefix();
        if (this.processNamespaces) {
            prefix = "xmlns:" + prefix;
        }
        return prefix;
    }

    private String getNamespaceAttributeValue(int index) {
        ResXmlStartNamespace namespace = this.getCurrentElement().getNamespace(index);
        return namespace.getUri();
    }

    @Override
    public int getEventType() throws XmlPullParserException {
        return this.mEventList.getType();
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        this.mEventList.next();
        int type = this.mEventList.getType();
        if (type == 2) {
            this.mIsTagStared = true;
        }
        return type;
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    @Override
    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("expected: " + TYPES[type] + " {" + namespace + "}" + name, this, null);
        }
    }

    @Override
    public String nextText() throws XmlPullParserException, IOException {
        int event = this.getEventType();
        if (event != 2) {
            throw new XmlPullParserException("precondition: START_TAG", this, null);
        }
        while (event != 4 && event != 3 && event != 1) {
            event = this.next();
        }
        if (event == 4) {
            return this.getText();
        }
        return "";
    }

    @Override
    public int nextTag() throws XmlPullParserException, IOException {
        int event = this.getEventType();
        if (event != 2) {
            throw new XmlPullParserException("precondition: START_TAG", this, null);
        }
        event = this.next();
        while (event != 2 && event != 1) {
            event = this.next();
        }
        return event;
    }

    private static InputStream getFromLock(Reader reader) {
        try {
            Field field = Reader.class.getDeclaredField("lock");
            field.setAccessible(true);
            Object obj = field.get(reader);
            if (obj instanceof InputStream) {
                return (InputStream)obj;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void setDocumentLoadedListener(DocumentLoadedListener documentLoadedListener) {
        this.documentLoadedListener = documentLoadedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResXmlDocument(InputStream inputStream) throws XmlPullParserException {
        ResXmlPullParser resXmlPullParser = this;
        synchronized (resXmlPullParser) {
            ResXmlDocument xmlDocument = new ResXmlDocument();
            try {
                xmlDocument.readBytes(inputStream);
            }
            catch (IOException exception) {
                XmlPullParserException pullParserException = new XmlPullParserException(exception.getMessage());
                pullParserException.initCause(exception);
                throw pullParserException;
            }
            DocumentLoadedListener listener = this.documentLoadedListener;
            if (listener != null) {
                xmlDocument = listener.onDocumentLoaded(xmlDocument);
            }
            this.setResXmlDocument(xmlDocument);
            this.mDocumentCreatedHere = true;
        }
    }

    private void initDefaultFeatures() {
        this.processNamespaces = true;
        this.reportNamespaceAttrs = true;
    }

    public static interface DocumentLoadedListener {
        public ResXmlDocument onDocumentLoaded(ResXmlDocument var1);
    }
}

