/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlText;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.common.EntryStore;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.XMLText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class ResXmlElement
extends ResXmlNode
implements JSONConvert<JSONObject>,
Comparator<ResXmlNode> {
    private final BlockList<ResXmlStartNamespace> mStartNamespaceList = new BlockList();
    private final SingleBlockContainer<ResXmlStartElement> mStartElementContainer = new SingleBlockContainer();
    private final BlockList<ResXmlNode> mBody = new BlockList();
    private final SingleBlockContainer<ResXmlEndElement> mEndElementContainer = new SingleBlockContainer();
    private final BlockList<ResXmlEndNamespace> mEndNamespaceList = new BlockList();
    private int mLevel;
    public static final String NS_ANDROID_URI = "http://schemas.android.com/apk/res/android";
    public static final String NS_ANDROID_PREFIX = "android";
    static final String NAME_element = "element";
    static final String NAME_name = "name";
    static final String NAME_comment = "comment";
    static final String NAME_text = "text";
    static final String NAME_namespaces = "namespaces";
    static final String NAME_namespace_uri = "namespace_uri";
    static final String NAME_namespace_prefix = "namespace_prefix";
    private static final String NAME_line = "line";
    static final String NAME_attributes = "attributes";
    static final String NAME_childes = "childes";

    public ResXmlElement() {
        super(5);
        this.addChild(0, this.mStartNamespaceList);
        this.addChild(1, this.mStartElementContainer);
        this.addChild(2, this.mBody);
        this.addChild(3, this.mEndElementContainer);
        this.addChild(4, this.mEndNamespaceList);
    }

    public int removeUndefinedAttributes() {
        int count = 0;
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            count += start.removeUndefinedAttributes();
        }
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (!(xmlNode instanceof ResXmlElement)) continue;
            count += ((ResXmlElement)xmlNode).removeUndefinedAttributes();
        }
        return count;
    }

    public void changeIndex(ResXmlElement element, int index) {
        int i = 0;
        for (ResXmlNode xmlNode : this.mBody.getChildes()) {
            if (i == index) {
                element.setIndex(i);
                ++i;
            }
            if (xmlNode == element) continue;
            xmlNode.setIndex(i);
            ++i;
        }
        this.mBody.sort(this);
    }

    public int lastIndexOf(String tagName) {
        List<ResXmlElement> elementList = this.listElements(tagName);
        int i = elementList.size();
        if (i == 0) {
            return -1;
        }
        return elementList.get(--i).getIndex();
    }

    public int indexOf(String tagName) {
        ResXmlElement element = this.getElementByTagName(tagName);
        if (element != null) {
            return element.getIndex();
        }
        return -1;
    }

    public int indexOf(ResXmlElement element) {
        int index = 0;
        for (ResXmlNode xmlNode : this.mBody.getChildes()) {
            if (xmlNode == element) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void setAttributesUnitSize(int size, boolean setToAll) {
        ResXmlStartElement startElement = this.getStartElement();
        startElement.setAttributesUnitSize(size);
        if (setToAll) {
            for (ResXmlElement child : this.listElements()) {
                child.setAttributesUnitSize(size, setToAll);
            }
        }
    }

    public String getStartComment() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            return start.getComment();
        }
        return null;
    }

    String getEndComment() {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            return end.getComment();
        }
        return null;
    }

    public int getStartLineNumber() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            return start.getLineNumber();
        }
        return 0;
    }

    public int getEndLineNumber() {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            return end.getLineNumber();
        }
        return 0;
    }

    public void setComment(String comment) {
        this.getStartElement().setComment(comment);
    }

    public void calculatePositions() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.calculatePositions();
        }
    }

    public ResXmlAttribute newAttribute() {
        return this.getStartElement().newAttribute();
    }

    @Override
    void onRemoved() {
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.onRemoved();
        }
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.onRemoved();
        }
        for (ResXmlNode xmlNode : this.listXmlNodes()) {
            xmlNode.onRemoved();
        }
    }

    @Override
    void linkStringReferences() {
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.linkStringReferences();
        }
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.linkStringReferences();
        }
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            xmlNode.linkStringReferences();
        }
    }

    public ResXmlElement createChildElement() {
        return this.createChildElement(null);
    }

    public ResXmlElement createChildElement(String tag) {
        int lineNo = this.getStartElement().getLineNumber() + 1;
        ResXmlElement resXmlElement = new ResXmlElement();
        resXmlElement.newStartElement(lineNo);
        this.addElement(resXmlElement);
        if (tag != null) {
            resXmlElement.setTag(tag);
        }
        return resXmlElement;
    }

    public ResXmlAttribute getOrCreateAndroidAttribute(String name, int resourceId) {
        return this.getOrCreateAttribute(NS_ANDROID_URI, NS_ANDROID_PREFIX, name, resourceId);
    }

    public ResXmlAttribute getOrCreateAttribute(String uri, String prefix, String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createAttribute(name, resourceId);
            if (uri != null && resourceId != 0) {
                ResXmlElement root = this.getRootResXmlElement();
                ResXmlStartNamespace ns = root.getOrCreateNamespace(uri, prefix);
                attribute.setNamespaceReference(ns.getUriReference());
            }
        }
        return attribute;
    }

    public ResXmlAttribute getOrCreateAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createAttribute(name, resourceId);
        }
        return attribute;
    }

    public ResXmlAttribute createAndroidAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.createAttribute(name, resourceId);
        ResXmlStartNamespace ns = this.getOrCreateNamespace(NS_ANDROID_URI, NS_ANDROID_PREFIX);
        attribute.setNamespaceReference(ns.getUriReference());
        return attribute;
    }

    public ResXmlAttribute createAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = new ResXmlAttribute();
        this.addAttribute(attribute);
        attribute.setName(name, resourceId);
        return attribute;
    }

    public void addAttribute(ResXmlAttribute attribute) {
        this.getStartElement().getResXmlAttributeArray().add(attribute);
    }

    public ResXmlElement getElementByTagName(String name) {
        if (name == null) {
            return null;
        }
        for (ResXmlElement child : this.listElements()) {
            if (!name.equals(child.getTag()) && !name.equals(child.getTagName())) continue;
            return child;
        }
        return null;
    }

    private ResXmlAttribute searchAttribute(String name, int resourceId) {
        if (resourceId == 0) {
            return this.searchAttributeByName(name);
        }
        return this.searchAttributeByResourceId(resourceId);
    }

    public ResXmlAttribute searchAttributeByName(String name) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.searchAttributeByName(name);
        }
        return null;
    }

    public ResXmlAttribute searchAttributeByResourceId(int resourceId) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.searchAttributeByResourceId(resourceId);
        }
        return null;
    }

    public void setTag(String tag) {
        ResXmlStringPool pool = this.getStringPool();
        if (pool == null) {
            return;
        }
        this.ensureStartEndElement();
        ResXmlStartElement start = this.getStartElement();
        String prefix = null;
        String name = tag;
        int i = tag.lastIndexOf(58);
        if (i >= 0) {
            prefix = tag.substring(0, i);
            name = tag.substring(++i);
        }
        start.setName(name);
        ResXmlStartNamespace ns = this.getStartNamespaceByPrefix(prefix);
        if (ns != null) {
            start.setNamespaceReference(ns.getUriReference());
        }
    }

    public String getTagName() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getTagName();
        }
        return null;
    }

    public String getTag() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getName();
        }
        return null;
    }

    public String getTagUri() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getUri();
        }
        return null;
    }

    public String getTagPrefix() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getPrefix();
        }
        return null;
    }

    public int getAttributeCount() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getResXmlAttributeArray().childesCount();
        }
        return 0;
    }

    public ResXmlAttribute getAttributeAt(int index) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return (ResXmlAttribute)startElement.getResXmlAttributeArray().get(index);
        }
        return null;
    }

    public Collection<ResXmlAttribute> listAttributes() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.listResXmlAttributes();
        }
        return new ArrayList<ResXmlAttribute>();
    }

    public ResXmlStringPool getStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ResXmlDocument) {
                return ((ResXmlDocument)parent).getStringPool();
            }
            if (!(parent instanceof ResXmlElement)) continue;
            return ((ResXmlElement)parent).getStringPool();
        }
        return null;
    }

    public ResXmlIDMap getResXmlIDMap() {
        ResXmlDocument resXmlDocument = this.getParentDocument();
        if (resXmlDocument != null) {
            return resXmlDocument.getResXmlIDMap();
        }
        return null;
    }

    public ResXmlDocument getParentDocument() {
        return this.getParentInstance(ResXmlDocument.class);
    }

    @Override
    public int getDepth() {
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            return parent.getDepth() + 1;
        }
        return 0;
    }

    @Override
    void addEvents(ParserEventList parserEventList) {
        String comment = this.getStartComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, false));
        }
        parserEventList.add(new ParserEvent(2, this));
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            xmlNode.addEvents(parserEventList);
        }
        comment = this.getEndComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, true));
        }
        parserEventList.add(new ParserEvent(3, this));
    }

    public int getLevel() {
        return this.mLevel;
    }

    private void setLevel(int level) {
        this.mLevel = level;
    }

    public void addElement(ResXmlElement element) {
        this.mBody.add(element);
    }

    public boolean removeAttribute(ResXmlAttribute resXmlAttribute) {
        if (resXmlAttribute != null) {
            resXmlAttribute.onRemoved();
        }
        return this.getStartElement().getResXmlAttributeArray().remove(resXmlAttribute);
    }

    public boolean removeElement(ResXmlElement element) {
        if (element != null && element.getParent() != null) {
            element.onRemoved();
        }
        return this.mBody.remove(element);
    }

    public boolean removeNode(ResXmlNode node) {
        if (node instanceof ResXmlElement) {
            return this.removeElement((ResXmlElement)node);
        }
        return this.mBody.remove(node);
    }

    public int countElements() {
        int result = 0;
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (!(xmlNode instanceof ResXmlElement)) continue;
            ++result;
        }
        return result;
    }

    public void clearChildes() {
        ArrayList<ResXmlNode> copyOfNodeList = new ArrayList<ResXmlNode>(this.mBody.getChildes());
        for (ResXmlNode xmlNode : copyOfNodeList) {
            if (xmlNode == null) continue;
            xmlNode.onRemoved();
            this.mBody.remove(xmlNode);
        }
    }

    public ResXmlNode getResXmlNode(int position) {
        return this.mBody.get(position);
    }

    public int countResXmlNodes() {
        return this.mBody.size();
    }

    public boolean hasText() {
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (!(xmlNode instanceof ResXmlTextNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasElement() {
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (!(xmlNode instanceof ResXmlElement)) continue;
            return true;
        }
        return false;
    }

    public List<ResXmlNode> listXmlNodes() {
        return new ArrayList<ResXmlNode>(this.getXmlNodes());
    }

    private List<ResXmlNode> getXmlNodes() {
        return this.mBody.getChildes();
    }

    public List<ResXmlText> listXmlText() {
        ArrayList<ResXmlText> results = new ArrayList<ResXmlText>();
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (!(xmlNode instanceof ResXmlTextNode)) continue;
            results.add(((ResXmlTextNode)xmlNode).getResXmlText());
        }
        return results;
    }

    public List<ResXmlTextNode> listXmlTextNodes() {
        ArrayList<ResXmlTextNode> results = new ArrayList<ResXmlTextNode>();
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (!(xmlNode instanceof ResXmlTextNode)) continue;
            results.add((ResXmlTextNode)xmlNode);
        }
        return results;
    }

    public List<ResXmlElement> listElements() {
        ArrayList<ResXmlElement> results = new ArrayList<ResXmlElement>();
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (!(xmlNode instanceof ResXmlElement)) continue;
            results.add((ResXmlElement)xmlNode);
        }
        return results;
    }

    public List<ResXmlElement> listElements(String name) {
        ArrayList<ResXmlElement> results = new ArrayList<ResXmlElement>();
        if (name == null) {
            return results;
        }
        for (ResXmlElement element : this.listElements()) {
            if (!name.equals(element.getTag()) && !name.equals(element.getTagName())) continue;
            results.add(element);
        }
        return results;
    }

    public ResXmlElement getRootResXmlElement() {
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            return parent.getRootResXmlElement();
        }
        return this;
    }

    public ResXmlElement getParentResXmlElement() {
        return this.getParentInstance(ResXmlElement.class);
    }

    public ResXmlStartNamespace getStartNamespaceByUriRef(int uriRef) {
        if (uriRef < 0) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (uriRef != ns.getUriReference()) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByUriRef(uriRef);
        }
        return null;
    }

    public ResXmlStartNamespace getNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (!uri.equals(ns.getUri()) || !prefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getNamespace(uri, prefix);
        }
        return null;
    }

    public ResXmlStartNamespace getOrCreateNamespace(String uri, String prefix) {
        ResXmlStartNamespace exist = this.getNamespace(uri, prefix);
        if (exist != null) {
            return exist;
        }
        return this.getRootResXmlElement().createNamespace(uri, prefix);
    }

    public ResXmlStartNamespace createNamespace(String uri, String prefix) {
        ResXmlStartNamespace startNamespace = new ResXmlStartNamespace();
        ResXmlEndNamespace endNamespace = new ResXmlEndNamespace();
        startNamespace.setEnd(endNamespace);
        this.addStartNamespace(startNamespace);
        this.addEndNamespace(endNamespace, true);
        ResXmlStringPool stringPool = this.getStringPool();
        ResXmlString xmlString = stringPool.createNew(uri);
        startNamespace.setUriReference(xmlString.getIndex());
        startNamespace.setPrefix(prefix);
        return startNamespace;
    }

    public ResXmlStartNamespace getStartNamespaceByUri(String uri) {
        if (uri == null) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (!uri.equals(ns.getUri())) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByUri(uri);
        }
        return null;
    }

    public ResXmlStartNamespace getStartNamespaceByPrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByPrefix(prefix);
        }
        return null;
    }

    public List<ResXmlStartNamespace> getStartNamespaceList() {
        return this.mStartNamespaceList.getChildes();
    }

    public int getNamespaceCount() {
        return this.mStartNamespaceList.size();
    }

    public ResXmlStartNamespace getNamespace(int index) {
        return this.mStartNamespaceList.get(index);
    }

    public void addStartNamespace(ResXmlStartNamespace item) {
        this.mStartNamespaceList.add(item);
    }

    private List<ResXmlEndNamespace> getEndNamespaceList() {
        return this.mEndNamespaceList.getChildes();
    }

    private void addEndNamespace(ResXmlEndNamespace item, boolean at_first) {
        if (at_first) {
            this.mEndNamespaceList.add(0, item);
        } else {
            this.mEndNamespaceList.add(item);
        }
    }

    void removeNamespace(ResXmlStartNamespace startNamespace) {
        if (startNamespace == null) {
            return;
        }
        startNamespace.onRemoved();
        this.mStartNamespaceList.remove(startNamespace);
        this.mEndNamespaceList.remove(startNamespace.getEnd());
    }

    ResXmlStartElement newStartElement(int lineNo) {
        ResXmlStartElement startElement = new ResXmlStartElement();
        this.setStartElement(startElement);
        ResXmlEndElement endElement = new ResXmlEndElement();
        startElement.setResXmlEndElement(endElement);
        this.setEndElement(endElement);
        endElement.setResXmlStartElement(startElement);
        startElement.setLineNumber(lineNo);
        endElement.setLineNumber(lineNo);
        return startElement;
    }

    public ResXmlStartElement getStartElement() {
        return this.mStartElementContainer.getItem();
    }

    private void setStartElement(ResXmlStartElement item) {
        this.mStartElementContainer.setItem(item);
    }

    private ResXmlEndElement getEndElement() {
        return this.mEndElementContainer.getItem();
    }

    private void setEndElement(ResXmlEndElement item) {
        this.mEndElementContainer.setItem(item);
    }

    public void addResXmlTextNode(ResXmlTextNode xmlTextNode) {
        this.mBody.add(xmlTextNode);
    }

    public void addResXmlText(ResXmlText xmlText) {
        if (xmlText != null) {
            this.addResXmlTextNode(new ResXmlTextNode(xmlText));
        }
    }

    public void addResXmlText(String text) {
        if (text == null) {
            return;
        }
        ResXmlTextNode xmlTextNode = new ResXmlTextNode();
        this.addResXmlTextNode(xmlTextNode);
        xmlTextNode.setText(text);
    }

    private boolean isBalanced() {
        return this.isElementBalanced() && this.isNamespaceBalanced();
    }

    private boolean isNamespaceBalanced() {
        return this.mStartNamespaceList.size() == this.mEndNamespaceList.size();
    }

    private boolean isElementBalanced() {
        return this.hasStartElement() && this.hasEndElement();
    }

    private boolean hasStartElement() {
        return this.mStartElementContainer.hasItem();
    }

    private boolean hasEndElement() {
        return this.mEndElementContainer.hasItem();
    }

    private void linkStartEnd() {
        this.linkStartEndElement();
        this.linkStartEndNameSpaces();
    }

    private void linkStartEndElement() {
        ResXmlStartElement start = this.getStartElement();
        ResXmlEndElement end = this.getEndElement();
        if (start == null || end == null) {
            return;
        }
        start.setResXmlEndElement(end);
        end.setResXmlStartElement(start);
    }

    private void ensureStartEndElement() {
        ResXmlStartElement start = this.getStartElement();
        ResXmlEndElement end = this.getEndElement();
        if (start != null && end != null) {
            return;
        }
        if (start == null) {
            start = new ResXmlStartElement();
            this.setStartElement(start);
        }
        if (end == null) {
            end = new ResXmlEndElement();
            this.setEndElement(end);
        }
        this.linkStartEndElement();
    }

    private void linkStartEndNameSpaces() {
        if (!this.isNamespaceBalanced()) {
            return;
        }
        int max = this.mStartNamespaceList.size();
        for (int i = 0; i < max; ++i) {
            ResXmlStartNamespace start = this.mStartNamespaceList.get(i);
            ResXmlEndNamespace end = this.mEndNamespaceList.get(max - i - 1);
            start.setEnd(end);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int pos = reader.getPosition();
        while (this.readNext(reader) && pos != reader.getPosition()) {
            pos = reader.getPosition();
        }
    }

    private boolean readNext(BlockReader reader) throws IOException {
        int pos = reader.getPosition();
        if (this.isBalanced()) {
            return false;
        }
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == null) {
            this.unknownChunk(reader, headerBlock);
            return false;
        }
        if (chunkType == ChunkType.XML_START_ELEMENT) {
            this.onStartElement(reader);
        } else if (chunkType == ChunkType.XML_END_ELEMENT) {
            this.onEndElement(reader);
        } else if (chunkType == ChunkType.XML_START_NAMESPACE) {
            this.onStartNamespace(reader);
        } else if (chunkType == ChunkType.XML_END_NAMESPACE) {
            this.onEndNamespace(reader);
        } else if (chunkType == ChunkType.XML_CDATA) {
            this.onXmlText(reader);
        } else {
            this.unexpectedChunk(reader, headerBlock);
        }
        if (!this.isBalanced()) {
            if (!reader.isAvailable()) {
                this.unBalancedFinish(reader);
            } else if (pos != reader.getPosition()) {
                return true;
            }
        }
        this.linkStartEnd();
        this.onFinishedRead(reader, headerBlock);
        return false;
    }

    private void onFinishedRead(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        int avail = reader.available();
        if (avail > 0 && this.getLevel() == 0) {
            this.onFinishedUnexpected(reader);
            return;
        }
        this.onFinishedSuccess(reader, headerBlock);
    }

    private void onFinishedSuccess(BlockReader reader, HeaderBlock headerBlock) throws IOException {
    }

    private void onFinishedUnexpected(BlockReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("Unexpected finish reading: reader=").append(reader.toString());
        InfoHeader header = reader.readHeaderBlock();
        if (header != null) {
            builder.append(", next header=");
            builder.append(header.toString());
        }
        throw new IOException(builder.toString());
    }

    private void onStartElement(BlockReader reader) throws IOException {
        if (this.hasStartElement()) {
            ResXmlElement childElement = new ResXmlElement();
            this.addElement(childElement);
            childElement.setLevel(this.getLevel() + 1);
            childElement.readBytes(reader);
        } else {
            ResXmlStartElement startElement = new ResXmlStartElement();
            this.setStartElement(startElement);
            startElement.readBytes(reader);
        }
    }

    private void onEndElement(BlockReader reader) throws IOException {
        if (this.hasEndElement()) {
            this.multipleEndElement(reader);
            return;
        }
        ResXmlEndElement endElement = new ResXmlEndElement();
        this.setEndElement(endElement);
        endElement.readBytes(reader);
    }

    private void onStartNamespace(BlockReader reader) throws IOException {
        ResXmlStartNamespace startNamespace = new ResXmlStartNamespace();
        this.addStartNamespace(startNamespace);
        startNamespace.readBytes(reader);
    }

    private void onEndNamespace(BlockReader reader) throws IOException {
        ResXmlEndNamespace endNamespace = new ResXmlEndNamespace();
        this.addEndNamespace(endNamespace, false);
        endNamespace.readBytes(reader);
    }

    private void onXmlText(BlockReader reader) throws IOException {
        ResXmlText xmlText = new ResXmlText();
        this.addResXmlText(xmlText);
        xmlText.readBytes(reader);
    }

    private void unknownChunk(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unknown chunk: " + headerBlock.toString());
    }

    private void multipleEndElement(BlockReader reader) throws IOException {
        throw new IOException("Multiple end element: " + reader.toString());
    }

    private void unexpectedChunk(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unexpected chunk: " + headerBlock.toString());
    }

    private void unBalancedFinish(BlockReader reader) throws IOException {
        if (!this.isNamespaceBalanced()) {
            throw new IOException("Unbalanced namespace: start=" + this.mStartNamespaceList.size() + ", end=" + this.mEndNamespaceList.size());
        }
        if (!this.isElementBalanced()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unbalanced element: start=");
            ResXmlStartElement startElement = this.getStartElement();
            if (startElement != null) {
                builder.append(startElement);
            } else {
                builder.append("null");
            }
            builder.append(", end=");
            ResXmlEndElement endElement = this.getEndElement();
            if (endElement != null) {
                builder.append(endElement);
            } else {
                builder.append("null");
            }
            throw new IOException(builder.toString());
        }
    }

    @Override
    public JSONObject toJson() {
        String uri;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("node_type", NAME_element);
        ResXmlStartElement start = this.getStartElement();
        jsonObject.put(NAME_line, start.getLineNumber());
        int i = 0;
        JSONArray nsList = new JSONArray();
        for (ResXmlStartNamespace namespace : this.getStartNamespaceList()) {
            JSONObject ns = new JSONObject();
            ns.put(NAME_namespace_uri, namespace.getUri());
            ns.put(NAME_namespace_prefix, namespace.getPrefix());
            nsList.put(i, ns);
            ++i;
        }
        if (i > 0) {
            jsonObject.put(NAME_namespaces, nsList);
        }
        jsonObject.put(NAME_name, start.getName());
        String comment = start.getComment();
        if (comment != null) {
            jsonObject.put(NAME_comment, comment);
        }
        if ((uri = start.getUri()) != null) {
            jsonObject.put(NAME_namespace_uri, uri);
        }
        JSONArray attrArray = start.getResXmlAttributeArray().toJson();
        jsonObject.put(NAME_attributes, attrArray);
        i = 0;
        JSONArray childes = new JSONArray();
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            childes.put(i, xmlNode.toJson());
            ++i;
        }
        if (i > 0) {
            jsonObject.put(NAME_childes, childes);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        JSONArray childArray;
        JSONArray attributes;
        String uri;
        ResXmlStartElement start = this.getStartElement();
        int lineNo = json.optInt(NAME_line, 1);
        if (start == null) {
            start = this.newStartElement(lineNo);
        } else {
            start.setLineNumber(lineNo);
        }
        JSONArray nsArray = json.optJSONArray(NAME_namespaces);
        if (nsArray != null) {
            int length = nsArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject nsObject = nsArray.getJSONObject(i);
                String uri2 = nsObject.optString(NAME_namespace_uri, "");
                String prefix = nsObject.optString(NAME_namespace_prefix, "");
                this.getOrCreateNamespace(uri2, prefix);
            }
        }
        this.setTag(json.getString(NAME_name));
        start.setComment(json.optString(NAME_comment, null));
        String text = json.optString(NAME_text, null);
        if (text != null) {
            this.addResXmlText(text);
        }
        if ((uri = json.optString(NAME_namespace_uri, null)) != null) {
            ResXmlStartNamespace ns = this.getStartNamespaceByUri(uri);
            if (ns == null) {
                throw new IllegalArgumentException("Undefined uri: " + uri + ", must be defined in array: " + NAME_namespaces);
            }
            start.setNamespaceReference(ns.getUriReference());
        }
        if ((attributes = json.optJSONArray(NAME_attributes)) != null) {
            start.getResXmlAttributeArray().fromJson(attributes);
        }
        if ((childArray = json.optJSONArray(NAME_childes)) != null) {
            int length = childArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject childObject = childArray.getJSONObject(i);
                if (this.isTextNode(childObject)) {
                    ResXmlTextNode xmlTextNode = new ResXmlTextNode();
                    this.addResXmlTextNode(xmlTextNode);
                    xmlTextNode.fromJson(childObject);
                    continue;
                }
                ResXmlElement childElement = this.createChildElement();
                childElement.fromJson(childObject);
            }
        }
        start.calculatePositions();
    }

    private boolean isTextNode(JSONObject childObject) {
        String type = childObject.optString("node_type", null);
        if (NAME_text.equals(type)) {
            return true;
        }
        if (NAME_element.equals(type)) {
            return false;
        }
        return childObject.has(NAME_text);
    }

    public XMLElement decodeToXml(EntryStore entryStore, int currentPackageId) throws XMLException {
        XMLElement xmlElement = new XMLElement(this.getTagName());
        xmlElement.setLineNumber(this.getStartElement().getLineNumber());
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            xmlElement.addAttribute(startNamespace.decodeToXml());
        }
        for (ResXmlAttribute resXmlAttribute : this.listAttributes()) {
            XMLAttribute xmlAttribute = resXmlAttribute.decodeToXml(entryStore, currentPackageId);
            xmlElement.addAttribute(xmlAttribute);
        }
        String comment = this.getStartComment();
        if (comment != null) {
            xmlElement.addComment(new XMLComment(comment));
        }
        if ((comment = this.getEndComment()) != null) {
            xmlElement.addComment(new XMLComment(comment));
        }
        for (ResXmlNode xmlNode : this.getXmlNodes()) {
            if (xmlNode instanceof ResXmlElement) {
                ResXmlElement childResXmlElement = (ResXmlElement)xmlNode;
                XMLElement childXMLElement = childResXmlElement.decodeToXml(entryStore, currentPackageId);
                xmlElement.addChild(childXMLElement);
                continue;
            }
            if (!(xmlNode instanceof ResXmlTextNode)) continue;
            ResXmlTextNode childResXmlTextNode = (ResXmlTextNode)xmlNode;
            XMLText xmlText = childResXmlTextNode.decodeToXml();
            xmlElement.addText(xmlText);
        }
        return xmlElement;
    }

    @Override
    public int compare(ResXmlNode node1, ResXmlNode node2) {
        return Integer.compare(node1.getIndex(), node2.getIndex());
    }

    public String toString() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("<");
            builder.append(start.toString());
            if (this.hasText() && !this.hasElement()) {
                builder.append(">");
                for (ResXmlText xmlText : this.listXmlText()) {
                    builder.append(xmlText.getText());
                }
                builder.append("</");
                builder.append(start.getTagName());
                builder.append(">");
            } else {
                builder.append("/>");
            }
            return builder.toString();
        }
        return "NULL";
    }

    static ResXmlElement newResXmlElement(String tag) {
        ResXmlElement resXmlElement = new ResXmlElement();
        ResXmlStartElement startElement = new ResXmlStartElement();
        resXmlElement.setStartElement(startElement);
        ResXmlEndElement endElement = new ResXmlEndElement();
        resXmlElement.setEndElement(endElement);
        resXmlElement.setTag(tag);
        return resXmlElement;
    }
}

