/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResIdBuilder;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.EntryStore;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResXmlDocument
extends Chunk<HeaderBlock>
implements MainChunk,
ParentChunk,
JSONConvert<JSONObject> {
    private final ResXmlStringPool mResXmlStringPool = new ResXmlStringPool(true);
    private final ResXmlIDMap mResXmlIDMap = new ResXmlIDMap();
    private ResXmlElement mResXmlElement = new ResXmlElement();
    private final SingleBlockContainer<ResXmlElement> mResXmlElementContainer = new SingleBlockContainer();
    private ApkFile mApkFile;
    private PackageBlock mPackageBlock;
    private static final String NAME_element = "element";
    private static final String NAME_styled_strings = "styled_strings";

    public ResXmlDocument() {
        super(new HeaderBlock(ChunkType.XML), 3);
        this.mResXmlElementContainer.setItem(this.mResXmlElement);
        this.addChild(this.mResXmlStringPool);
        this.addChild(this.mResXmlIDMap);
        this.addChild(this.mResXmlElementContainer);
    }

    public String refreshFull() {
        int count;
        int sizeOld = ((HeaderBlock)this.getHeaderBlock()).getChunkSize();
        StringBuilder message = new StringBuilder();
        boolean appendOnce = false;
        ResXmlElement root = this.getResXmlElement();
        if (root != null && (count = root.removeUndefinedAttributes()) != 0) {
            message.append("Removed undefined attributes = ");
            message.append(count);
            appendOnce = true;
        }
        if ((count = this.getStringPool().removeUnusedStrings().size()) != 0) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Removed xml strings = ");
            message.append(count);
            appendOnce = true;
        }
        this.refresh();
        int sizeNew = ((HeaderBlock)this.getHeaderBlock()).getChunkSize();
        if (sizeOld != sizeNew) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Xml size changed = ");
            message.append(sizeOld);
            message.append(", ");
            message.append(sizeNew);
            appendOnce = true;
        }
        if (appendOnce) {
            return message.toString();
        }
        return null;
    }

    public void destroy() {
        ResXmlElement root = this.getResXmlElement();
        if (root != null) {
            root.clearChildes();
            this.setResXmlElement(null);
        }
        this.getResXmlIDMap().destroy();
        this.getStringPool().destroy();
        this.refresh();
    }

    public void setAttributesUnitSize(int size, boolean setToAll) {
        ResXmlElement root = this.getResXmlElement();
        if (root != null) {
            root.setAttributesUnitSize(size, setToAll);
        }
    }

    public ResXmlElement createRootElement(String tag) {
        int lineNo = 1;
        ResXmlElement resXmlElement = new ResXmlElement();
        resXmlElement.newStartElement(lineNo);
        this.setResXmlElement(resXmlElement);
        if (tag != null) {
            resXmlElement.setTag(tag);
        }
        return resXmlElement;
    }

    void linkStringReferences() {
        ResXmlElement element = this.getResXmlElement();
        if (element != null) {
            element.linkStringReferences();
        }
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.writeBytes(os);
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return os.toByteArray();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean readOk;
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return;
        }
        BlockReader chunkReader = reader.create(headerBlock.getChunkSize());
        headerBlock = this.getHeaderBlock();
        headerBlock.readBytes(chunkReader);
        headerBlock.setType(ChunkType.XML);
        while (chunkReader.isAvailable() && (readOk = this.readNext(chunkReader))) {
        }
        reader.offset(headerBlock.getChunkSize());
        chunkReader.close();
        this.onChunkLoaded();
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        this.linkStringReferences();
    }

    private boolean readNext(BlockReader reader) throws IOException {
        if (!reader.isAvailable()) {
            return false;
        }
        int position = reader.getPosition();
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.STRING) {
            this.mResXmlStringPool.readBytes(reader);
        } else if (chunkType == ChunkType.XML_RESOURCE_MAP) {
            this.mResXmlIDMap.readBytes(reader);
        } else {
            if (this.isElementChunk(chunkType)) {
                this.mResXmlElementContainer.readBytes(reader);
                return reader.isAvailable();
            }
            throw new IOException("Unexpected chunk " + headerBlock);
        }
        return reader.isAvailable() && position != reader.getPosition();
    }

    private boolean isElementChunk(ChunkType chunkType) {
        if (chunkType == ChunkType.XML_START_ELEMENT) {
            return true;
        }
        if (chunkType == ChunkType.XML_END_ELEMENT) {
            return true;
        }
        if (chunkType == ChunkType.XML_START_NAMESPACE) {
            return true;
        }
        if (chunkType == ChunkType.XML_END_NAMESPACE) {
            return true;
        }
        if (chunkType == ChunkType.XML_CDATA) {
            return true;
        }
        return chunkType == ChunkType.XML_LAST_CHUNK;
    }

    public ResXmlStringPool getStringPool() {
        return this.mResXmlStringPool;
    }

    @Override
    public ApkFile getApkFile() {
        return this.mApkFile;
    }

    @Override
    public void setApkFile(ApkFile apkFile) {
        this.mApkFile = apkFile;
    }

    @Override
    public PackageBlock getPackageBlock() {
        ApkFile apkFile = this.mApkFile;
        PackageBlock packageBlock = this.mPackageBlock;
        if (apkFile == null || packageBlock != null) {
            return packageBlock;
        }
        TableBlock tableBlock = apkFile.getTableBlock();
        if (tableBlock != null) {
            return tableBlock.pickOne();
        }
        return null;
    }

    public void setPackageBlock(PackageBlock packageBlock) {
        this.mPackageBlock = packageBlock;
    }

    @Override
    public TableBlock getTableBlock() {
        TableBlock tableBlock;
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null && (tableBlock = packageBlock.getTableBlock()) != null) {
            return tableBlock;
        }
        ApkFile apkFile = this.getApkFile();
        if (apkFile != null) {
            return apkFile.getTableBlock();
        }
        return null;
    }

    @Override
    public StringPool<?> getSpecStringPool() {
        return null;
    }

    @Override
    public MainChunk getMainChunk() {
        return this;
    }

    public ResXmlIDMap getResXmlIDMap() {
        return this.mResXmlIDMap;
    }

    public ResXmlElement getResXmlElement() {
        return this.mResXmlElement;
    }

    public void setResXmlElement(ResXmlElement resXmlElement) {
        this.mResXmlElement = resXmlElement;
        this.mResXmlElementContainer.setItem(resXmlElement);
    }

    @Override
    protected void onChunkRefreshed() {
    }

    public void readBytes(File file) throws IOException {
        BlockReader reader = new BlockReader(file);
        super.readBytes(reader);
    }

    public void readBytes(InputStream inputStream) throws IOException {
        BlockReader reader = new BlockReader(inputStream);
        super.readBytes(reader);
    }

    public final int writeBytes(File file) throws IOException {
        if (this.isNull()) {
            throw new IOException("Can NOT save null block");
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        int length = super.writeBytes(outputStream);
        ((OutputStream)outputStream).close();
        return length;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_element, this.getResXmlElement().toJson());
        JSONArray pool = this.getStringPool().toJson();
        if (pool != null) {
            jsonObject.put(NAME_styled_strings, pool);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.onFromJson(json);
        ResXmlElement xmlElement = this.getResXmlElement();
        xmlElement.fromJson(json.optJSONObject(NAME_element));
        this.refresh();
    }

    public XMLDocument decodeToXml() throws XMLException {
        ApkFile apkFile = this.getApkFile();
        if (apkFile == null) {
            throw new XMLException("Null parent apk file");
        }
        int currentPackageId = 0;
        AndroidManifestBlock manifestBlock = this instanceof AndroidManifestBlock ? (AndroidManifestBlock)this : apkFile.getAndroidManifestBlock();
        if (manifestBlock != null) {
            currentPackageId = manifestBlock.guessCurrentPackageId();
        }
        TableBlock tableBlock = apkFile.getTableBlock();
        return this.decodeToXml(tableBlock, currentPackageId);
    }

    public XMLDocument decodeToXml(EntryStore entryStore, int currentPackageId) throws XMLException {
        XMLDocument xmlDocument = new XMLDocument();
        XMLElement xmlElement = this.getResXmlElement().decodeToXml(entryStore, currentPackageId);
        xmlDocument.setDocumentElement(xmlElement);
        return xmlDocument;
    }

    private void onFromJson(JSONObject json) {
        List<JSONObject> attributeList = this.recursiveAttributes(json.optJSONObject(NAME_element));
        this.buildResourceIds(attributeList);
        Set<String> allStrings = this.recursiveStrings(json.optJSONObject(NAME_element));
        ResXmlStringPool stringPool = this.getStringPool();
        stringPool.addStrings(allStrings);
        stringPool.refresh();
    }

    private void buildResourceIds(List<JSONObject> attributeList) {
        ResIdBuilder builder = new ResIdBuilder();
        for (JSONObject attribute : attributeList) {
            int id = attribute.getInt("id");
            if (id == 0) continue;
            String name = attribute.getString("name");
            builder.add(id, name);
        }
        builder.buildTo(this.getResXmlIDMap());
    }

    private List<JSONObject> recursiveAttributes(JSONObject elementJson) {
        JSONArray childElements;
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        if (elementJson == null) {
            return results;
        }
        JSONArray attributes = elementJson.optJSONArray("attributes");
        if (attributes != null) {
            int length = attributes.length();
            for (int i = 0; i < length; ++i) {
                JSONObject attr = attributes.optJSONObject(i);
                if (attr == null) continue;
                results.add(attr);
            }
        }
        if ((childElements = elementJson.optJSONArray("childes")) != null) {
            int length = childElements.length();
            for (int i = 0; i < length; ++i) {
                JSONObject child = childElements.getJSONObject(i);
                results.addAll(this.recursiveAttributes(child));
            }
        }
        return results;
    }

    private Set<String> recursiveStrings(JSONObject elementJson) {
        JSONArray childElements;
        JSONArray attributes;
        HashSet<String> results = new HashSet<String>();
        if (elementJson == null) {
            return results;
        }
        results.add(elementJson.optString("namespace_uri"));
        results.add(elementJson.optString("name"));
        JSONArray namespaces = elementJson.optJSONArray("namespaces");
        if (namespaces != null) {
            int length = namespaces.length();
            for (int i = 0; i < length; ++i) {
                JSONObject nsObject = namespaces.getJSONObject(i);
                results.add(nsObject.getString("namespace_uri"));
                results.add(nsObject.getString("namespace_prefix"));
            }
        }
        if ((attributes = elementJson.optJSONArray("attributes")) != null) {
            int length = attributes.length();
            for (int i = 0; i < length; ++i) {
                JSONObject attr = attributes.optJSONObject(i);
                if (attr == null) continue;
                results.add(attr.getString("name"));
                ValueType valueType = ValueType.fromName(attr.getString("value_type"));
                if (valueType != ValueType.STRING) continue;
                results.add(attr.optString("data"));
            }
        }
        if ((childElements = elementJson.optJSONArray("childes")) != null) {
            int length = childElements.length();
            for (int i = 0; i < length; ++i) {
                JSONObject child = childElements.getJSONObject(i);
                results.addAll(this.recursiveStrings(child));
            }
        }
        return results;
    }

    void addEvents(ParserEventList parserEventList) {
        ResXmlElement xmlElement = this.getResXmlElement();
        parserEventList.add(new ParserEvent(0, xmlElement));
        if (xmlElement != null) {
            xmlElement.addEvents(parserEventList);
        }
        parserEventList.add(new ParserEvent(1, xmlElement));
    }

    public static boolean isResXmlBlock(File file) {
        if (file == null) {
            return false;
        }
        try {
            InfoHeader infoHeader = InfoHeader.readHeaderBlock(file);
            return ResXmlDocument.isResXmlBlock(infoHeader);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(InputStream inputStream) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(inputStream);
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(byte[] bytes) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(bytes);
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(BlockReader blockReader) {
        if (blockReader == null) {
            return false;
        }
        try {
            InfoHeader headerBlock = blockReader.readHeaderBlock();
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(HeaderBlock headerBlock) {
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        return chunkType == ChunkType.XML;
    }
}

