/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ReferenceBlock;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.EntryStore;
import com.reandroid.json.JSONObject;
import com.reandroid.xml.XMLAttribute;
import java.io.IOException;
import java.util.Objects;

public class ResXmlAttribute
extends ValueItem
implements AttributeValue,
Comparable<ResXmlAttribute> {
    private ReferenceItem mNSReference;
    private ReferenceItem mNameReference;
    private ReferenceItem mNameIdReference;
    private ReferenceItem mValueStringReference;
    public static final String NAME_id = "id";
    public static final String NAME_name = "name";
    public static final String NAME_namespace_uri = "namespace_uri";
    private static final int OFFSET_NS = 0;
    private static final int OFFSET_NAME = 4;
    private static final int OFFSET_STRING = 8;
    private static final int OFFSET_SIZE = 12;

    public ResXmlAttribute(int attributeUnitSize) {
        super(attributeUnitSize, 12);
        byte[] bts = this.getBytesInternal();
        ResXmlAttribute.putInteger(bts, 0, -1);
        ResXmlAttribute.putInteger(bts, 4, -1);
        ResXmlAttribute.putInteger(bts, 8, -1);
    }

    public ResXmlAttribute() {
        this(20);
    }

    @Override
    public boolean isUndefined() {
        return this.getNameReference() < 0;
    }

    public String getUri() {
        return this.getString(this.getNamespaceReference());
    }

    public String getFullName() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        String prefix = this.getNamePrefix();
        if (prefix == null) {
            return name;
        }
        return prefix + ":" + name;
    }

    public String getName() {
        return this.getString(this.getNameReference());
    }

    public String getNamePrefix() {
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement == null) {
            return null;
        }
        ResXmlStartNamespace startNamespace = xmlElement.getStartNamespaceByUriRef(this.getNamespaceReference());
        if (startNamespace == null) {
            return null;
        }
        return startNamespace.getPrefix();
    }

    public String getValueString() {
        return this.getString(this.getValueStringReference());
    }

    @Override
    public int getNameResourceID() {
        ResXmlID xmlID = this.getResXmlID();
        if (xmlID != null) {
            return xmlID.get();
        }
        return 0;
    }

    @Override
    public void setNameResourceID(int resourceId) {
        ResXmlIDMap xmlIDMap = this.getResXmlIDMap();
        if (xmlIDMap == null) {
            return;
        }
        ResXmlID xmlID = xmlIDMap.getOrCreate(resourceId);
        this.setNameReference(xmlID.getIndex());
    }

    @Override
    public Entry resolveName() {
        return this.resolve(this.getNameResourceID());
    }

    public void setName(String name, int resourceId) {
        if (Objects.equals(name, this.getName()) && resourceId == this.getNameResourceID()) {
            return;
        }
        this.unlink(this.mNameReference);
        this.unLinkNameId(this.getResXmlID());
        ResXmlString xmlString = this.getOrCreateAttributeName(name, resourceId);
        if (xmlString == null) {
            return;
        }
        this.setNameReference(xmlString.getIndex());
        this.mNameReference = this.link(4);
        this.linkNameId();
    }

    private void linkStartNameSpace() {
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement == null) {
            return;
        }
        ResXmlStartNamespace startNamespace = xmlElement.getStartNamespaceByUriRef(this.getNamespaceReference());
        if (startNamespace == null) {
            return;
        }
        startNamespace.addAttributeReference(this);
    }

    private void unLinkStartNameSpace() {
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement == null) {
            return;
        }
        ResXmlStartNamespace startNamespace = xmlElement.getStartNamespaceByUriRef(this.getNamespaceReference());
        if (startNamespace == null) {
            return;
        }
        startNamespace.removeAttributeReference(this);
    }

    private ResXmlString getOrCreateAttributeName(String name, int resourceId) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.getOrCreateAttribute(resourceId, name);
    }

    public ResXmlElement getParentResXmlElement() {
        return this.getParent(ResXmlElement.class);
    }

    public int getAttributesUnitSize() {
        return 12 + super.getSize();
    }

    public void setAttributesUnitSize(int size) {
        int eight = size - 12;
        super.setSize(eight);
    }

    private String getString(int ref) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        StringItem stringItem = this.getStringItem(ref);
        if (stringItem == null) {
            return null;
        }
        return stringItem.getHtml();
    }

    private StringItem getStringItem(int ref) {
        if (ref < 0) {
            return null;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.get(ref);
    }

    private ResXmlID getResXmlID() {
        ResXmlIDMap xmlIDMap = this.getResXmlIDMap();
        if (xmlIDMap == null) {
            return null;
        }
        return (ResXmlID)xmlIDMap.getResXmlIDArray().get(this.getNameReference());
    }

    private ResXmlIDMap getResXmlIDMap() {
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getResXmlIDMap();
        }
        return null;
    }

    int getNamespaceReference() {
        return ResXmlAttribute.getInteger(this.getBytesInternal(), 0);
    }

    public void setNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            this.setNamespaceReference(-1);
            return;
        }
        ResXmlElement parentElement = this.getParentResXmlElement();
        if (parentElement == null) {
            return;
        }
        ResXmlStartNamespace ns = parentElement.getOrCreateNamespace(uri, prefix);
        this.setNamespaceReference(ns.getUriReference());
    }

    public void setNamespaceReference(int ref) {
        if (ref == this.getNamespaceReference()) {
            return;
        }
        StringItem stringItem = this.getStringItem(this.getNamespaceReference());
        ResXmlAttribute.putInteger(this.getBytesInternal(), 0, ref);
        if (stringItem != null) {
            stringItem.removeReference(this.mNSReference);
        }
        this.mNSReference = this.link(0);
        this.linkStartNameSpace();
    }

    int getNameReference() {
        return ResXmlAttribute.getInteger(this.getBytesInternal(), 4);
    }

    void setNameReference(int ref) {
        if (ref == this.getNameReference()) {
            return;
        }
        this.unLinkNameId(this.getResXmlID());
        this.unlink(this.mNameReference);
        ResXmlAttribute.putInteger(this.getBytesInternal(), 4, ref);
        this.mNameReference = this.link(4);
        this.linkNameId();
    }

    int getValueStringReference() {
        return ResXmlAttribute.getInteger(this.getBytesInternal(), 8);
    }

    void setValueStringReference(int ref) {
        if (ref == this.getValueStringReference() && this.mValueStringReference != null) {
            return;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        Object stringItem = stringPool.get(ref);
        this.unlink(this.mValueStringReference);
        if (stringItem != null) {
            ref = ((Block)stringItem).getIndex();
        }
        ResXmlAttribute.putInteger(this.getBytesInternal(), 8, ref);
        ReferenceBlock<ResXmlAttribute> referenceItem = null;
        if (stringItem != null) {
            referenceItem = new ReferenceBlock<ResXmlAttribute>(this, 8);
            ((StringItem)stringItem).addReference(referenceItem);
        }
        this.mValueStringReference = referenceItem;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        super.onDataLoaded();
        this.linkAll();
        this.linkStartNameSpace();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.unLinkStartNameSpace();
        this.unlinkAll();
    }

    @Override
    protected void onUnlinkDataString(ReferenceItem referenceItem) {
        this.unlink(referenceItem);
    }

    @Override
    protected void onDataChanged() {
        if (this.getValueType() == ValueType.STRING) {
            this.setValueStringReference(this.getData());
        } else {
            this.setValueStringReference(-1);
        }
    }

    @Override
    public ResXmlDocument getParentChunk() {
        ResXmlElement element = this.getParentResXmlElement();
        if (element != null) {
            return element.getParentDocument();
        }
        return null;
    }

    private void linkNameId() {
        ResXmlID xmlID = this.getResXmlID();
        if (xmlID == null) {
            return;
        }
        this.unLinkNameId(xmlID);
        ReferenceBlock<ResXmlAttribute> referenceItem = new ReferenceBlock<ResXmlAttribute>(this, 4);
        xmlID.addReference(referenceItem);
        this.mNameIdReference = referenceItem;
    }

    private void unLinkNameId(ResXmlID xmlID) {
        ReferenceItem referenceItem = this.mNameIdReference;
        if (referenceItem == null || xmlID == null) {
            return;
        }
        xmlID.removeReference(referenceItem);
        this.mNameIdReference = null;
        if (xmlID.hasReference()) {
            return;
        }
        ResXmlIDMap xmlIDMap = this.getResXmlIDMap();
        if (xmlIDMap == null) {
            return;
        }
        xmlIDMap.removeSafely(xmlID);
    }

    private void linkAll() {
        this.unlink(this.mNSReference);
        this.mNSReference = this.link(0);
        this.unlink(this.mNameReference);
        this.mNameReference = this.link(4);
        this.unlink(this.mValueStringReference);
        this.mValueStringReference = this.link(8);
        this.linkNameId();
    }

    private void unlinkAll() {
        this.unlink(this.mNSReference);
        this.unlink(this.mNameReference);
        this.unlink(this.mValueStringReference);
        this.mNSReference = null;
        this.mNameReference = null;
        this.mValueStringReference = null;
        this.unLinkNameId(this.getResXmlID());
    }

    private ReferenceItem link(int offset) {
        if (offset < 0) {
            return null;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        int ref = ResXmlAttribute.getInteger(this.getBytesInternal(), offset);
        Object stringItem = stringPool.get(ref);
        if (stringItem == null) {
            return null;
        }
        ReferenceBlock<ResXmlAttribute> referenceItem = new ReferenceBlock<ResXmlAttribute>(this, offset);
        ((StringItem)stringItem).addReference(referenceItem);
        return referenceItem;
    }

    private void unlink(ReferenceItem reference) {
        if (reference == null) {
            return;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        stringPool.removeReference(reference);
    }

    public ResXmlStringPool getStringPool() {
        StringPool<?> stringPool = super.getStringPool();
        if (stringPool instanceof ResXmlStringPool) {
            return (ResXmlStringPool)stringPool;
        }
        return null;
    }

    @Override
    public int compareTo(ResXmlAttribute other) {
        String name2;
        int id1 = this.getNameResourceID();
        int id2 = other.getNameResourceID();
        if (id1 == 0 && id2 != 0) {
            return 1;
        }
        if (id2 == 0 && id1 != 0) {
            return -1;
        }
        if (id1 != 0) {
            return Integer.compare(id1, id2);
        }
        String name1 = this.getName();
        if (name1 == null) {
            name1 = "";
        }
        if ((name2 = other.getName()) == null) {
            name2 = "";
        }
        return name1.compareTo(name2);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_name, this.getName());
        jsonObject.put(NAME_id, this.getNameResourceID());
        jsonObject.put(NAME_namespace_uri, this.getUri());
        ValueType valueType = this.getValueType();
        jsonObject.put("value_type", valueType.name());
        if (valueType == ValueType.STRING) {
            jsonObject.put("data", this.getValueAsString());
        } else if (valueType == ValueType.BOOLEAN) {
            jsonObject.put("data", this.getValueAsBoolean());
        } else {
            jsonObject.put("data", this.getData());
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        ValueType valueType;
        String name = json.optString(NAME_name, "");
        int id = json.optInt(NAME_id, 0);
        this.setName(name, id);
        String uri = json.optString(NAME_namespace_uri, null);
        if (uri != null) {
            ResXmlStartNamespace ns = this.getParentResXmlElement().getStartNamespaceByUri(uri);
            if (ns == null) {
                ns = this.getParentResXmlElement().getRootResXmlElement().getOrCreateNamespace(uri, "");
            }
            this.setNamespaceReference(ns.getUriReference());
        }
        if ((valueType = ValueType.fromName(json.getString("value_type"))) == ValueType.STRING) {
            this.setValueAsString(json.optString("data", ""));
        } else if (valueType == ValueType.BOOLEAN) {
            this.setValueAsBoolean(json.getBoolean("data"));
        } else {
            this.setValueType(valueType);
            this.setData(json.getInt("data"));
        }
    }

    public XMLAttribute decodeToXml(EntryStore entryStore, int currentPackageId) {
        EntryGroup group;
        int resourceId = this.getNameResourceID();
        String name = resourceId == 0 ? this.getName() : ((group = entryStore.getEntryGroup(resourceId)) == null ? ValueCoder.decodeUnknownResourceId(false, resourceId) : group.getSpecName());
        String prefix = this.getNamePrefix();
        if (prefix != null) {
            name = prefix + ":" + name;
        }
        ValueType valueType = this.getValueType();
        int raw = this.getData();
        String value = ValueDecoder.decode(entryStore, currentPackageId, this);
        XMLAttribute attribute = new XMLAttribute(name, value);
        attribute.setNameId(resourceId);
        if (valueType == ValueType.REFERENCE || valueType == ValueType.ATTRIBUTE) {
            attribute.setValueId(raw);
        }
        return attribute;
    }

    @Override
    public String toString() {
        String fullName = this.getFullName();
        if (fullName != null) {
            ValueType valueType;
            String valStr;
            int id = this.getNameResourceID();
            if (id != 0) {
                fullName = fullName + "(@" + HexUtil.toHex8(id) + ")";
            }
            if ((valStr = (valueType = this.getValueType()) == ValueType.STRING ? this.getValueAsString() : (valueType == ValueType.BOOLEAN ? String.valueOf(this.getValueAsBoolean()) : (valueType == ValueType.DEC ? String.valueOf(this.getData()) : "[" + (Object)((Object)valueType) + "] " + HexUtil.toHex8(this.getData())))) != null) {
                return fullName + "=\"" + valStr + "\"";
            }
            return fullName + "[" + (Object)((Object)valueType) + "]=\"" + this.getData() + "\"";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": ");
        builder.append(this.getIndex());
        builder.append("{NamespaceReference=").append(this.getNamespaceReference());
        builder.append(", NameReference=").append(this.getNameReference());
        builder.append(", ValueStringReference=").append(this.getValueStringReference());
        builder.append(", ValueSize=").append(this.getSize());
        builder.append(", ValueTypeByte=").append(this.getType() & 0xFF);
        builder.append(", Data=").append(this.getData());
        builder.append("}");
        return builder.toString();
    }
}

