/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.arsc.coder.ValueDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ParserEventList
implements Iterator<ParserEvent> {
    private final List<ParserEvent> eventList = new ArrayList<ParserEvent>();
    private int index;
    private ParserEvent mCurrent;
    private int type = -1;

    public void clear() {
        this.eventList.clear();
        this.reset();
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        if (this.type == 9) {
            return this.mCurrent.getComment();
        }
        if (this.type == 2 || this.type == 3) {
            return this.getElement().getTag();
        }
        if (this.type == 4) {
            String text = ((ResXmlTextNode)this.getXmlNode()).getText();
            if (text == null) {
                text = "";
            }
            return ValueDecoder.escapeSpecialCharacter(text);
        }
        return null;
    }

    public int getLineNumber() {
        if (this.type != 9 && this.type != 2 && this.type != 3) {
            return 0;
        }
        ResXmlNode xmlNode = this.getXmlNode();
        if (this.mCurrent.isEndComment() || this.type == 3) {
            return ((ResXmlElement)xmlNode).getEndLineNumber();
        }
        if (this.type == 4) {
            return ((ResXmlTextNode)xmlNode).getLineNumber();
        }
        return ((ResXmlElement)xmlNode).getStartLineNumber();
    }

    public ResXmlNode getXmlNode() {
        return this.mCurrent.getXmlNode();
    }

    public ResXmlElement getElement() {
        return (ResXmlElement)this.mCurrent.getXmlNode();
    }

    @Override
    public ParserEvent next() {
        if (!this.hasNext()) {
            return null;
        }
        ParserEvent event = this.get(this.index);
        ++this.index;
        this.mCurrent = event;
        this.type = event.getEvent();
        return event;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size();
    }

    public int size() {
        return this.eventList.size();
    }

    public int getIndex() {
        return this.index;
    }

    public void reset() {
        this.index = 0;
        this.mCurrent = null;
        this.type = -1;
    }

    void add(ParserEvent parserEvent) {
        if (parserEvent == null) {
            return;
        }
        this.eventList.add(parserEvent);
    }

    private ParserEvent get(int i) {
        return this.eventList.get(i);
    }
}

