/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.header.XmlNodeHeader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;

class BaseXmlChunk
extends Chunk<XmlNodeHeader> {
    private final IntegerItem mNamespaceReference = new IntegerItem(-1);
    private final IntegerItem mStringReference = new IntegerItem(-1);

    BaseXmlChunk(ChunkType chunkType, int initialChildesCount) {
        super(new XmlNodeHeader(chunkType), initialChildesCount + 2);
        this.addChild(this.mNamespaceReference);
        this.addChild(this.mStringReference);
    }

    void onRemoved() {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        stringPool.removeReference(((XmlNodeHeader)this.getHeaderBlock()).getCommentReference());
        stringPool.removeReference(this.mNamespaceReference);
        stringPool.removeReference(this.mStringReference);
    }

    void linkStringReferences() {
        this.linkStringReference(((XmlNodeHeader)this.getHeaderBlock()).getCommentReference());
        this.linkStringReference(this.mNamespaceReference);
        this.linkStringReference(this.mStringReference);
    }

    private void linkStringReference(IntegerItem item) {
        ResXmlString xmlString = this.getResXmlString(item.get());
        if (xmlString != null) {
            xmlString.addReferenceIfAbsent(item);
        }
    }

    void unLinkStringReference(IntegerItem item) {
        ResXmlString xmlString = this.getResXmlString(item.get());
        if (xmlString != null) {
            xmlString.removeReference(item);
        }
    }

    public void setLineNumber(int val) {
        ((XmlNodeHeader)this.getHeaderBlock()).getLineNumber().set(val);
    }

    public int getLineNumber() {
        return ((XmlNodeHeader)this.getHeaderBlock()).getLineNumber().get();
    }

    public void setCommentReference(int val) {
        if (val == this.getCommentReference()) {
            return;
        }
        IntegerItem comment = ((XmlNodeHeader)this.getHeaderBlock()).getCommentReference();
        this.unLinkStringReference(comment);
        ((XmlNodeHeader)this.getHeaderBlock()).getCommentReference().set(val);
        this.linkStringReference(comment);
    }

    public int getCommentReference() {
        return ((XmlNodeHeader)this.getHeaderBlock()).getCommentReference().get();
    }

    public void setNamespaceReference(int val) {
        if (val == this.getNamespaceReference()) {
            return;
        }
        this.unLinkStringReference(this.mNamespaceReference);
        this.mNamespaceReference.set(val);
        this.linkStringReference(this.mNamespaceReference);
    }

    public int getNamespaceReference() {
        return this.mNamespaceReference.get();
    }

    public void setStringReference(int val) {
        if (val == this.getStringReference()) {
            return;
        }
        this.unLinkStringReference(this.mStringReference);
        this.mStringReference.set(val);
        this.linkStringReference(this.mStringReference);
    }

    public int getStringReference() {
        return this.mStringReference.get();
    }

    public ResXmlString setString(String str) {
        ResXmlStringPool pool = this.getStringPool();
        if (pool == null) {
            return null;
        }
        ResXmlString xmlString = pool.getOrCreate(str);
        this.setStringReference(xmlString.getIndex());
        return xmlString;
    }

    public ResXmlStringPool getStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ResXmlDocument) {
                return ((ResXmlDocument)parent).getStringPool();
            }
            if (!(parent instanceof ResXmlElement)) continue;
            return ((ResXmlElement)parent).getStringPool();
        }
        return null;
    }

    public ResXmlString getResXmlString(int ref) {
        if (ref < 0) {
            return null;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool != null) {
            return (ResXmlString)stringPool.get(ref);
        }
        return null;
    }

    ResXmlString getOrCreateResXmlString(String str) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool != null) {
            return stringPool.getOrCreate(str);
        }
        return null;
    }

    String getString(int ref) {
        ResXmlString xmlString = this.getResXmlString(ref);
        if (xmlString != null) {
            return xmlString.get();
        }
        return null;
    }

    ResXmlString getOrCreateString(String str) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.getOrCreate(str);
    }

    public String getName() {
        return this.getString(this.getStringReference());
    }

    public String getUri() {
        return this.getString(this.getNamespaceReference());
    }

    public String getComment() {
        return this.getString(this.getCommentReference());
    }

    public void setComment(String comment) {
        if (comment == null || comment.length() == 0) {
            this.setCommentReference(-1);
        } else {
            String old = this.getComment();
            if (comment.equals(old)) {
                return;
            }
            ResXmlString xmlString = this.getOrCreateResXmlString(comment);
            this.setCommentReference(xmlString.getIndex());
        }
    }

    public ResXmlElement getParentResXmlElement() {
        return this.getParent(ResXmlElement.class);
    }

    @Override
    protected void onChunkRefreshed() {
    }

    @Override
    public String toString() {
        ChunkType chunkType = ((XmlNodeHeader)this.getHeaderBlock()).getChunkType();
        if (chunkType == null) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(chunkType.toString());
        builder.append(": line=");
        builder.append(this.getLineNumber());
        builder.append(" {");
        builder.append(this.getName());
        builder.append("}");
        return builder.toString();
    }
}

