/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ByteArray;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UnknownChunk
extends Chunk<HeaderBlock>
implements HeaderBlock.HeaderLoaded {
    private final ByteArray body = new ByteArray();
    private static final short INITIAL_CHUNK_TYPE = 0;

    public UnknownChunk() {
        super(new HeaderBlock(0), 1);
        this.addChild(this.body);
        this.setHeaderLoaded(this);
    }

    public ByteArray getBody() {
        return this.body;
    }

    @Override
    public void onChunkTypeLoaded(short type) {
    }

    @Override
    public void onHeaderSizeLoaded(int headerSize) {
    }

    @Override
    public void onChunkSizeLoaded(int headerSize, int chunkSize) {
        this.getBody().setSize(chunkSize - headerSize);
    }

    @Override
    void checkInvalidChunk(HeaderBlock headerBlock) throws IOException {
    }

    @Override
    protected void onChunkRefreshed() {
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.writeBytes(os);
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return os.toByteArray();
    }

    public int readBytes(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        int result = this.readBytes(inputStream);
        inputStream.close();
        return result;
    }

    public int readBytes(InputStream inputStream) throws IOException {
        int result = ((HeaderBlock)this.getHeaderBlock()).readBytes(inputStream);
        super.notifyBlockLoad();
        return result += this.getBody().readBytes(inputStream);
    }

    public final int writeBytes(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists() && dir.mkdirs()) {
            throw new IOException("Can not create directory: " + dir);
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        int length = super.writeBytes(outputStream);
        ((OutputStream)outputStream).close();
        return length;
    }

    @Override
    public String toString() {
        return this.getHeaderBlock() + " {Body=" + this.getBody().size() + "}";
    }
}

