/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.array.EntryArray;
import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.SparseOffsetsArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.TypeHeader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TypeBlock
extends Chunk<TypeHeader>
implements JSONConvert<JSONObject>,
Comparable<TypeBlock> {
    private final EntryArray mEntryArray;
    private TypeString mTypeString;
    public static final String NAME_name = "name";
    public static final String NAME_config = "config";
    public static final String NAME_id = "id";
    public static final String NAME_entries = "entries";
    public static final String NAME_is_sparse = "is_sparse";

    public TypeBlock(boolean sparse) {
        super(new TypeHeader(sparse), 2);
        TypeHeader header = (TypeHeader)this.getHeaderBlock();
        OffsetArray entryOffsets = sparse ? new SparseOffsetsArray() : new OffsetArray();
        this.mEntryArray = new EntryArray(entryOffsets, header.getCount(), header.getEntriesStart());
        this.addChild(entryOffsets);
        this.addChild(this.mEntryArray);
    }

    public String buildUniqueDirectoryName() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null && packageBlock.hasValidTypeNames()) {
            return this.getTypeName() + this.getResConfig().getQualifiers();
        }
        return "type_" + HexUtil.toHex2(this.getTypeId()) + this.getResConfig().getQualifiers();
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        EntryArray entryArray = this.getEntryArray();
        entryArray.linkTableStringsInternal(tableStringPool);
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        EntryArray entryArray = this.getEntryArray();
        entryArray.linkSpecStringsInternal(specStringPool);
    }

    public boolean isSparse() {
        return ((TypeHeader)this.getHeaderBlock()).isSparse();
    }

    public void destroy() {
        this.getEntryArray().destroy();
        this.setId(0);
        this.setParent(null);
    }

    public boolean removeNullEntries(int startId) {
        startId = 0xFFFF & startId;
        EntryArray entryArray = this.getEntryArray();
        entryArray.removeAllNull(startId);
        return entryArray.childesCount() == startId;
    }

    public PackageBlock getPackageBlock() {
        SpecTypePair specTypePair = this.getParent(SpecTypePair.class);
        if (specTypePair != null) {
            return specTypePair.getPackageBlock();
        }
        return null;
    }

    public String getTypeName() {
        TypeString typeString = this.getTypeString();
        if (typeString == null) {
            return null;
        }
        return typeString.get();
    }

    public TypeString getTypeString() {
        PackageBlock packageBlock;
        if (this.mTypeString != null) {
            if (this.mTypeString.getId() == this.getTypeId()) {
                return this.mTypeString;
            }
            this.mTypeString = null;
        }
        if ((packageBlock = this.getPackageBlock()) == null) {
            return null;
        }
        TypeStringPool typeStringPool = packageBlock.getTypeStringPool();
        this.mTypeString = typeStringPool.getById(this.getId());
        return this.mTypeString;
    }

    public byte getTypeId() {
        return ((TypeHeader)this.getHeaderBlock()).getId().get();
    }

    public int getId() {
        return ((TypeHeader)this.getHeaderBlock()).getId().unsignedInt();
    }

    public void setId(int id) {
        this.setTypeId((byte)(0xFF & id));
    }

    public void setTypeId(byte id) {
        ((TypeHeader)this.getHeaderBlock()).getId().set(id);
    }

    public void setTypeName(String name) {
        int id;
        TypeStringPool typeStringPool = this.getTypeStringPool();
        TypeString typeString = typeStringPool.getById(id = this.getId());
        if (typeString == null) {
            typeString = typeStringPool.getOrCreate(id, name);
        }
        typeString.set(name);
    }

    private TypeStringPool getTypeStringPool() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getTypeStringPool();
        }
        return null;
    }

    public void setEntryCount(int count) {
        IntegerItem entryCount = ((TypeHeader)this.getHeaderBlock()).getCount();
        if (count == entryCount.get()) {
            return;
        }
        entryCount.set(count);
        this.onSetEntryCount(count);
    }

    public boolean isEmpty() {
        return this.getEntryArray().isEmpty();
    }

    public boolean isDefault() {
        return this.getResConfig().isDefault();
    }

    public String getQualifiers() {
        return this.getResConfig().getQualifiers();
    }

    public void setQualifiers(String qualifiers) {
        this.getResConfig().parseQualifiers(qualifiers);
    }

    public int countNonNullEntries() {
        return this.getEntryArray().countNonNull();
    }

    public SpecTypePair getParentSpecTypePair() {
        return this.getParent(SpecTypePair.class);
    }

    public void cleanEntries() {
        PackageBlock packageBlock = this.getPackageBlock();
        List<Entry> allEntries = this.listEntries(true);
        for (Entry entry : allEntries) {
            if (packageBlock != null) {
                packageBlock.removeEntryGroup(entry);
            }
            entry.setNull(true);
        }
    }

    public void removeEntry(Entry entry) {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            packageBlock.removeEntryGroup(entry);
        }
        entry.setNull(true);
    }

    public Entry getOrCreateEntry(String name) {
        Entry entry = this.getEntryArray().getEntry(name);
        if (entry != null) {
            return entry;
        }
        SpecTypePair specTypePair = this.getParentSpecTypePair();
        Entry exist = specTypePair.getAnyEntry(name);
        int id = exist != null ? exist.getId() : specTypePair.getHighestEntryCount();
        SpecStringPool stringPool = this.getPackageBlock().getSpecStringPool();
        SpecString specString = (SpecString)stringPool.getOrCreate(name);
        entry = this.getOrCreateEntry((short)id);
        entry.setSpecReference(specString);
        return entry;
    }

    public Entry getOrCreateEntry(short entryId) {
        return this.getEntryArray().getOrCreate(entryId);
    }

    public Entry getEntry(short entryId) {
        return this.getEntryArray().getEntry(entryId);
    }

    public Entry getEntry(String entryName) {
        return this.getEntryArray().getEntry(entryName);
    }

    public Boolean hasComplexEntry() {
        SpecTypePair specTypePair = this.getParentSpecTypePair();
        if (specTypePair != null) {
            return specTypePair.hasComplexEntry();
        }
        return null;
    }

    public ResConfig getResConfig() {
        return ((TypeHeader)this.getHeaderBlock()).getConfig();
    }

    public EntryArray getEntryArray() {
        return this.mEntryArray;
    }

    public List<Entry> listEntries() {
        return this.listEntries(false);
    }

    public List<Entry> listEntries(boolean skipNullBlock) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        Iterator itr = this.getEntryArray().iterator(skipNullBlock);
        while (itr.hasNext()) {
            Entry block = (Entry)itr.next();
            results.add(block);
        }
        return results;
    }

    public Entry getEntry(int entryId) {
        return (Entry)this.getEntryArray().get(entryId);
    }

    private void onSetEntryCount(int count) {
        this.getEntryArray().setChildesCount(count);
    }

    @Override
    protected void onChunkRefreshed() {
        this.getEntryArray().refreshCountAndStart();
    }

    @Override
    protected void onPreRefreshRefresh() {
        ((TypeHeader)this.getHeaderBlock()).getConfig().refresh();
        super.onPreRefreshRefresh();
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.writeBytes(os);
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return os.toByteArray();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.isSparse()) {
            jsonObject.put(NAME_is_sparse, true);
        }
        jsonObject.put(NAME_id, this.getId());
        jsonObject.put(NAME_name, this.getTypeName());
        jsonObject.put(NAME_config, this.getResConfig().toJson());
        jsonObject.put(NAME_entries, this.getEntryArray().toJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setId(json.getInt(NAME_id));
        String name = json.optString(NAME_name);
        if (name != null) {
            this.setTypeName(name);
        }
        this.getEntryArray().fromJson(json.getJSONArray(NAME_entries));
        this.getResConfig().fromJson(json.getJSONObject(NAME_config));
    }

    public void merge(TypeBlock typeBlock) {
        if (typeBlock == null || typeBlock == this) {
            return;
        }
        if (this.getTypeId() != typeBlock.getTypeId()) {
            throw new IllegalArgumentException("Can not merge different id types: " + this.getTypeId() + "!=" + typeBlock.getTypeId());
        }
        this.setTypeName(typeBlock.getTypeName());
        this.getEntryArray().merge(typeBlock.getEntryArray());
    }

    @Override
    public int compareTo(TypeBlock typeBlock) {
        int id2;
        int id1 = this.getId();
        if (id1 != (id2 = typeBlock.getId())) {
            return Integer.compare(id1, id2);
        }
        String q1 = (this.isSparse() ? "1" : "0") + this.getResConfig().getQualifiers();
        String q2 = (typeBlock.isSparse() ? "1" : "0") + typeBlock.getResConfig().getQualifiers();
        return q1.compareTo(q2);
    }

    public boolean isEqualTypeName(String typeName) {
        return TypeBlock.isEqualTypeName(this.getTypeName(), typeName);
    }

    @Deprecated
    public Entry searchByEntryName(String entryName) {
        return this.getEntryArray().getEntry(entryName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTypeName());
        builder.append('{');
        builder.append(this.getHeaderBlock());
        builder.append('}');
        return builder.toString();
    }

    public static boolean isEqualTypeName(String name1, String name2) {
        if (name1 == null) {
            return name2 == null;
        }
        if (name2 == null) {
            return false;
        }
        if (name1.equals(name2)) {
            return true;
        }
        return TypeBlock.trimTypeName(name1).equals(TypeBlock.trimTypeName(name2));
    }

    private static String trimTypeName(String typeName) {
        while (typeName.length() > 0 && TypeBlock.isWildTypeNamePrefix(typeName.charAt(0))) {
            typeName = typeName.substring(1);
        }
        return typeName;
    }

    private static boolean isWildTypeNamePrefix(char ch) {
        switch (ch) {
            case '*': 
            case '+': 
            case '^': {
                return true;
            }
        }
        return false;
    }
}

