/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.BuildInfo;
import com.reandroid.arsc.array.PackageArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.TableHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.StagedAliasEntry;
import com.reandroid.common.EntryStore;
import com.reandroid.common.ReferenceResolver;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public class TableBlock
extends Chunk<TableHeader>
implements MainChunk,
JSONConvert<JSONObject>,
EntryStore {
    private final TableStringPool mTableStringPool;
    private final PackageArray mPackageArray;
    private final List<TableBlock> mFrameWorks;
    private ApkFile mApkFile;
    private ReferenceResolver referenceResolver;
    public static final String FILE_NAME = "resources.arsc";
    public static final String FILE_NAME_JSON = "resources.arsc.json";
    private static final String NAME_packages = "packages";
    public static final String NAME_styled_strings = "styled_strings";
    public static final String JSON_FILE_NAME = "resources.arsc.json";
    public static final String DIRECTORY_NAME = "resources";
    public static final String RES_JSON_DIRECTORY_NAME = "res-json";
    public static final String RES_FILES_DIRECTORY_NAME = "res-files";

    public TableBlock() {
        super(new TableHeader(), 2);
        TableHeader header = (TableHeader)this.getHeaderBlock();
        this.mTableStringPool = new TableStringPool(true);
        this.mPackageArray = new PackageArray(header.getPackageCount());
        this.mFrameWorks = new ArrayList<TableBlock>();
        this.addChild(this.mTableStringPool);
        this.addChild(this.mPackageArray);
    }

    public int removeUnusedSpecs() {
        int result = 0;
        for (PackageBlock packageBlock : this.listPackages()) {
            result += packageBlock.removeUnusedSpecs();
        }
        return result;
    }

    public String refreshFull() {
        int sizeOld = ((TableHeader)this.getHeaderBlock()).getChunkSize();
        StringBuilder message = new StringBuilder();
        boolean appendOnce = false;
        int count = this.getTableStringPool().removeUnusedStrings().size();
        if (count != 0) {
            message.append("Removed unused table strings = ");
            message.append(count);
            appendOnce = true;
        }
        for (PackageBlock packageBlock : this.listPackages()) {
            String packageMessage = packageBlock.refreshFull(false);
            if (packageMessage == null) continue;
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Package: ");
            message.append(packageBlock.getName());
            message.append("\n  ");
            packageMessage = packageMessage.replaceAll("\n", "\n  ");
            message.append(packageMessage);
            appendOnce = true;
        }
        this.refresh();
        int sizeNew = ((TableHeader)this.getHeaderBlock()).getChunkSize();
        if (sizeOld != sizeNew) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Table size changed = ");
            message.append(sizeOld);
            message.append(", ");
            message.append(sizeNew);
            appendOnce = true;
        }
        if (appendOnce) {
            return message.toString();
        }
        return null;
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        for (PackageBlock packageBlock : this.listPackages()) {
            packageBlock.linkTableStringsInternal(tableStringPool);
        }
    }

    public List<Entry> resolveReference(int referenceId) {
        return this.resolveReference(referenceId, null);
    }

    public List<Entry> resolveReferenceWithConfig(int referenceId, ResConfig resConfig) {
        ReferenceResolver resolver = this.referenceResolver;
        if (resolver == null) {
            this.referenceResolver = resolver = new ReferenceResolver(this);
        }
        return resolver.resolveWithConfig(referenceId, resConfig);
    }

    public List<Entry> resolveReference(int referenceId, Predicate<Entry> filter) {
        ReferenceResolver resolver = this.referenceResolver;
        if (resolver == null) {
            this.referenceResolver = resolver = new ReferenceResolver(this);
        }
        return resolver.resolveAll(referenceId, filter);
    }

    public void destroy() {
        this.getPackageArray().destroy();
        this.getStringPool().destroy();
        this.clearFrameworks();
        this.refresh();
    }

    public int countPackages() {
        return this.getPackageArray().childesCount();
    }

    public PackageBlock pickOne() {
        return this.getPackageArray().pickOne();
    }

    public PackageBlock pickOne(int packageId) {
        return this.getPackageArray().pickOne(packageId);
    }

    public void sortPackages() {
        this.getPackageArray().sort();
    }

    public Collection<PackageBlock> listPackages() {
        return this.getPackageArray().listItems();
    }

    public TableStringPool getStringPool() {
        return this.mTableStringPool;
    }

    @Override
    public ApkFile getApkFile() {
        return this.mApkFile;
    }

    @Override
    public void setApkFile(ApkFile apkFile) {
        this.mApkFile = apkFile;
    }

    @Override
    public TableBlock getTableBlock() {
        return this;
    }

    public TableStringPool getTableStringPool() {
        return this.mTableStringPool;
    }

    public PackageBlock getPackageBlockById(int pkgId) {
        return this.getPackageArray().getPackageBlockById(pkgId);
    }

    public PackageBlock newPackage(int id, String name) {
        PackageBlock packageBlock = (PackageBlock)this.getPackageArray().createNext();
        packageBlock.setId(id);
        packageBlock.setName(name);
        return packageBlock;
    }

    public PackageArray getPackageArray() {
        return this.mPackageArray;
    }

    private void refreshPackageCount() {
        int count = this.getPackageArray().childesCount();
        ((TableHeader)this.getHeaderBlock()).getPackageCount().set(count);
    }

    @Override
    protected void onChunkRefreshed() {
        this.refreshPackageCount();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        TableHeader tableHeader = (TableHeader)this.getHeaderBlock();
        tableHeader.readBytes(reader);
        if (tableHeader.getChunkType() != ChunkType.TABLE) {
            throw new IOException("Not resource table: " + tableHeader);
        }
        boolean stringPoolLoaded = false;
        InfoHeader infoHeader = reader.readHeaderBlock();
        PackageArray packageArray = this.mPackageArray;
        packageArray.clearChildes();
        while (infoHeader != null && reader.isAvailable()) {
            ChunkType chunkType = infoHeader.getChunkType();
            if (chunkType == ChunkType.STRING) {
                if (!stringPoolLoaded) {
                    this.mTableStringPool.readBytes(reader);
                    stringPoolLoaded = true;
                }
            } else if (chunkType == ChunkType.PACKAGE) {
                PackageBlock packageBlock = (PackageBlock)packageArray.createNext();
                packageBlock.readBytes(reader);
            } else {
                UnknownChunk unknownChunk = new UnknownChunk();
                unknownChunk.readBytes(reader);
                this.addChild(unknownChunk);
            }
            infoHeader = reader.readHeaderBlock();
        }
        reader.close();
    }

    public void readBytes(File file) throws IOException {
        BlockReader reader = new BlockReader(file);
        super.readBytes(reader);
    }

    public void readBytes(InputStream inputStream) throws IOException {
        BlockReader reader = new BlockReader(inputStream);
        super.readBytes(reader);
    }

    public final int writeBytes(File file) throws IOException {
        if (this.isNull()) {
            throw new IOException("Can NOT save null block");
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        int length = super.writeBytes(outputStream);
        ((OutputStream)outputStream).close();
        return length;
    }

    public Entry getAnyEntry(int resourceId) {
        Entry entry;
        if (resourceId == 0 || (resourceId >> 16 & 0xFF) == 0) {
            return null;
        }
        Entry result = null;
        for (PackageBlock packageBlock : this.listPackages()) {
            entry = packageBlock.getAnyEntry(resourceId);
            if (entry == null) continue;
            if (!entry.isNull()) {
                return entry;
            }
            if (result != null) continue;
            result = entry;
        }
        if (result != null) {
            return result;
        }
        for (TableBlock tableBlock : this.getFrameWorks()) {
            entry = tableBlock.getAnyEntry(resourceId);
            if (entry == null) continue;
            if (!entry.isNull()) {
                return entry;
            }
            if (result != null) continue;
            result = entry;
        }
        return result;
    }

    public EntryGroup search(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        EntryGroup entryGroup = this.searchLocal(resourceId);
        if (entryGroup != null) {
            return entryGroup;
        }
        for (TableBlock tableBlock : this.getFrameWorks()) {
            entryGroup = tableBlock.search(resourceId);
            if (entryGroup == null) continue;
            return entryGroup;
        }
        return null;
    }

    private EntryGroup searchLocal(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        int aliasId = this.searchResourceIdAlias(resourceId);
        for (PackageBlock packageBlock : this.listPackages()) {
            EntryGroup entryGroup = packageBlock.getEntryGroup(resourceId);
            if (entryGroup != null) {
                return entryGroup;
            }
            entryGroup = packageBlock.getEntryGroup(aliasId);
            if (entryGroup == null) continue;
            return entryGroup;
        }
        return null;
    }

    @Override
    public Collection<EntryGroup> getEntryGroups(int resourceId) {
        ArrayList<EntryGroup> results = new ArrayList<EntryGroup>();
        EntryGroup entryGroup = this.searchLocal(resourceId);
        if (entryGroup != null) {
            results.add(entryGroup);
        }
        for (TableBlock framework : this.getFrameWorks()) {
            results.addAll(framework.getEntryGroups(resourceId));
        }
        return results;
    }

    @Override
    public EntryGroup getEntryGroup(int resourceId) {
        return this.search(resourceId);
    }

    @Override
    public Collection<PackageBlock> getPackageBlocks(int packageId) {
        ArrayList<PackageBlock> results = new ArrayList<PackageBlock>();
        PackageBlock packageBlock = this.getPackageBlockById(packageId);
        if (packageBlock != null) {
            results.add(packageBlock);
        }
        for (TableBlock tableBlock : this.getFrameWorks()) {
            results.addAll(tableBlock.getPackageBlocks(packageId));
        }
        return results;
    }

    public int searchResourceIdAlias(int resourceId) {
        for (PackageBlock packageBlock : this.listPackages()) {
            StagedAliasEntry stagedAliasEntry = packageBlock.searchByStagedResId(resourceId);
            if (stagedAliasEntry == null) continue;
            return stagedAliasEntry.getFinalizedResId();
        }
        return 0;
    }

    public List<TableBlock> getFrameWorks() {
        return this.mFrameWorks;
    }

    public boolean isAndroid() {
        PackageBlock packageBlock = this.pickOne();
        if (packageBlock == null) {
            return false;
        }
        return "android".equals(packageBlock.getName()) && packageBlock.getId() == 1;
    }

    public boolean hasFramework() {
        return this.getFrameWorks().size() != 0;
    }

    public void addFramework(TableBlock tableBlock) {
        if (tableBlock == null || tableBlock == this) {
            return;
        }
        for (TableBlock frm : tableBlock.getFrameWorks()) {
            if (frm != this && frm != tableBlock && !tableBlock.equals(frm)) continue;
            return;
        }
        this.mFrameWorks.add(tableBlock);
    }

    public void removeFramework(TableBlock tableBlock) {
        this.mFrameWorks.remove(tableBlock);
    }

    public void clearFrameworks() {
        this.mFrameWorks.clear();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arsc_lib_version", BuildInfo.getVersion());
        jsonObject.put(NAME_packages, this.getPackageArray().toJson());
        JSONArray jsonArray = this.getStringPool().toJson();
        if (jsonArray != null) {
            jsonObject.put(NAME_styled_strings, jsonArray);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.getPackageArray().fromJson(json.getJSONArray(NAME_packages));
        this.refresh();
    }

    public void merge(TableBlock tableBlock) {
        if (tableBlock == null || tableBlock == this) {
            return;
        }
        if (this.countPackages() == 0 && this.getStringPool().countStrings() == 0) {
            this.getStringPool().merge(tableBlock.getStringPool());
        }
        this.getPackageArray().merge(tableBlock.getPackageArray());
        this.refresh();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": packages = ");
        builder.append(this.mPackageArray.childesCount());
        builder.append(", size = ");
        builder.append(((TableHeader)this.getHeaderBlock()).getChunkSize());
        builder.append(" bytes");
        return builder.toString();
    }

    @Deprecated
    public static TableBlock loadWithAndroidFramework(InputStream inputStream) throws IOException {
        return TableBlock.load(inputStream);
    }

    public static TableBlock load(File file) throws IOException {
        return TableBlock.load(new FileInputStream(file));
    }

    public static TableBlock load(InputStream inputStream) throws IOException {
        TableBlock tableBlock = new TableBlock();
        tableBlock.readBytes(inputStream);
        return tableBlock;
    }

    public static boolean isResTableBlock(File file) {
        if (file == null) {
            return false;
        }
        boolean result = false;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            result = TableBlock.isResTableBlock(inputStream);
            ((InputStream)inputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isResTableBlock(InputStream inputStream) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(inputStream);
            return TableBlock.isResTableBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResTableBlock(BlockReader blockReader) {
        if (blockReader == null) {
            return false;
        }
        try {
            InfoHeader headerBlock = blockReader.readHeaderBlock();
            return TableBlock.isResTableBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResTableBlock(HeaderBlock headerBlock) {
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        return chunkType == ChunkType.TABLE;
    }
}

