/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.array.TypeBlockArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.SpecHeader;
import com.reandroid.arsc.item.SpecFlag;
import com.reandroid.arsc.item.SpecFlagsArray;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.List;

public class SpecBlock
extends Chunk<SpecHeader>
implements JSONConvert<JSONObject> {
    private final SpecFlagsArray specFlagsArray;
    public static final String NAME_spec = "spec";
    public static final String NAME_spec_flags = "spec_flags";
    public static final String NAME_flag = "flag";

    public SpecBlock() {
        super(new SpecHeader(), 1);
        SpecHeader header = (SpecHeader)this.getHeaderBlock();
        this.specFlagsArray = new SpecFlagsArray(header.getEntryCount());
        this.addChild(this.specFlagsArray);
    }

    public void destroy() {
        this.setParent(null);
        this.getSpecFlagsArray().clear();
    }

    public SpecFlag getSpecFlag(int id) {
        return this.getSpecFlagsArray().getFlag(id);
    }

    public SpecFlagsArray getSpecFlagsArray() {
        return this.specFlagsArray;
    }

    public List<Integer> listSpecFlags() {
        return this.specFlagsArray.toList();
    }

    public byte getTypeId() {
        return ((SpecHeader)this.getHeaderBlock()).getId().get();
    }

    public int getId() {
        return ((SpecHeader)this.getHeaderBlock()).getId().unsignedInt();
    }

    public void setId(int id) {
        this.setTypeId((byte)(0xFF & id));
    }

    public void setTypeId(byte id) {
        ((SpecHeader)this.getHeaderBlock()).getId().set(id);
        this.getTypeBlockArray().setTypeId(id);
    }

    public TypeBlockArray getTypeBlockArray() {
        SpecTypePair specTypePair = this.getSpecTypePair();
        if (specTypePair != null) {
            return specTypePair.getTypeBlockArray();
        }
        return null;
    }

    SpecTypePair getSpecTypePair() {
        return this.getParent(SpecTypePair.class);
    }

    public int getEntryCount() {
        return this.specFlagsArray.size();
    }

    public void setEntryCount(int count) {
        this.specFlagsArray.setSize(count);
        this.specFlagsArray.refresh();
    }

    @Override
    protected void onChunkRefreshed() {
        this.specFlagsArray.refresh();
    }

    public void merge(SpecBlock specBlock) {
        if (specBlock == null || specBlock == this) {
            return;
        }
        this.getSpecFlagsArray().merge(specBlock.getSpecFlagsArray());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        TypeBlockArray typeBlockArray = this.getTypeBlockArray();
        if (typeBlockArray != null) {
            builder.append(", typesCount=");
            builder.append(typeBlockArray.childesCount());
        }
        return builder.toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", this.getId());
        jsonObject.put(NAME_spec_flags, this.getSpecFlagsArray().toJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setId(json.getInt("id"));
        this.getSpecFlagsArray().fromJson(json.optJSONArray(NAME_spec_flags));
    }

    public static enum Flag {
        SPEC_PUBLIC(64),
        SPEC_STAGED_API(32);

        private final byte flag;

        private Flag(byte flag) {
            this.flag = flag;
        }

        public byte getFlag() {
            return this.flag;
        }

        public static boolean isPublic(byte flag) {
            return (Flag.SPEC_PUBLIC.flag & flag) == Flag.SPEC_PUBLIC.flag;
        }

        public static boolean isStagedApi(byte flag) {
            return (Flag.SPEC_STAGED_API.flag & flag) == Flag.SPEC_STAGED_API.flag;
        }

        public static String toString(byte flagValue) {
            StringBuilder builder = new StringBuilder();
            boolean appendOnce = false;
            int sum = 0;
            int flagValueInt = flagValue & 0xFF;
            for (Flag flag : Flag.values()) {
                int flagInt = flag.flag & 0xFF;
                if ((flagInt & flagValueInt) != flagInt) continue;
                if (appendOnce) {
                    builder.append('|');
                }
                builder.append((Object)flag);
                appendOnce = true;
                sum |= flagInt;
            }
            if (sum != flagValueInt) {
                if (appendOnce) {
                    builder.append('|');
                }
                builder.append(HexUtil.toHex2((byte)flagValueInt));
            }
            return builder.toString();
        }
    }
}

