/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.BuildInfo;
import com.reandroid.arsc.array.LibraryInfoArray;
import com.reandroid.arsc.array.SpecTypePairArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.LibraryBlock;
import com.reandroid.arsc.chunk.OverlayablePolicy;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.StagedAlias;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.coder.CommonType;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.PackageBody;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.header.PackageHeader;
import com.reandroid.arsc.list.OverlayableList;
import com.reandroid.arsc.list.StagedAliasList;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.util.StringsUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.LibraryInfo;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.StagedAliasEntry;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackageBlock
extends Chunk<PackageHeader>
implements ParentChunk,
JSONConvert<JSONObject>,
Comparable<PackageBlock> {
    private final TypeStringPool mTypeStringPool;
    private final SpecStringPool mSpecStringPool;
    private final PackageBody mBody;
    private final Map<Integer, EntryGroup> mEntriesGroup;
    private boolean entryGroupMapLocked;
    public static final String NAME_package_id = "package_id";
    public static final String NAME_package_name = "package_name";
    private static final String NAME_specs = "specs";
    public static final String NAME_libraries = "libraries";
    public static final String NAME_staged_aliases = "staged_aliases";
    public static final String NAME_overlaybles = "overlaybles";
    public static final String JSON_FILE_NAME = "package.json";
    public static final String DIRECTORY_NAME_PREFIX = "package_";
    public static final String RES_DIRECTORY_NAME = "res";
    public static final String VALUES_DIRECTORY_NAME = "values";
    public static final String PUBLIC_XML = "public.xml";

    public PackageBlock() {
        super(new PackageHeader(), 3);
        PackageHeader header = (PackageHeader)this.getHeaderBlock();
        this.mTypeStringPool = new TypeStringPool(false, header.getTypeIdOffsetItem());
        this.mSpecStringPool = new SpecStringPool(true);
        this.mBody = new PackageBody();
        this.mEntriesGroup = new HashMap<Integer, EntryGroup>();
        this.entryGroupMapLocked = true;
        this.addChild(this.mTypeStringPool);
        this.addChild(this.mSpecStringPool);
        this.addChild(this.mBody);
    }

    public String buildDecodeDirectoryName() {
        int count = 0;
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock != null) {
            count = tableBlock.countPackages();
        }
        return DIRECTORY_NAME_PREFIX + StringsUtil.formatNumber(this.getIndex() + 1, count);
    }

    public boolean hasValidTypeNames() {
        HashSet<String> unique = new HashSet<String>();
        for (SpecTypePair specTypePair : this.listSpecTypePairs()) {
            String typeName = specTypePair.getTypeName();
            if (!CommonType.isCommonTypeName(typeName) || unique.contains(typeName)) {
                return false;
            }
            unique.add(typeName);
        }
        return true;
    }

    public int removeUnusedSpecs() {
        return this.getSpecStringPool().removeUnusedStrings().size();
    }

    public String refreshFull() {
        return this.refreshFull(true);
    }

    public String refreshFull(boolean elementsRefresh) {
        int sizeOld = ((PackageHeader)this.getHeaderBlock()).getChunkSize();
        StringBuilder message = new StringBuilder();
        boolean appendOnce = false;
        int count = this.removeUnusedSpecs();
        if (count != 0) {
            message.append("Removed unused spec strings = ");
            message.append(count);
            appendOnce = true;
        }
        this.sortTypes();
        if (!elementsRefresh) {
            if (appendOnce) {
                return message.toString();
            }
            return null;
        }
        this.refresh();
        int sizeNew = ((PackageHeader)this.getHeaderBlock()).getChunkSize();
        if (sizeOld != sizeNew) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Package size changed = ");
            message.append(sizeOld);
            message.append(", ");
            message.append(sizeNew);
            appendOnce = true;
        }
        if (appendOnce) {
            return message.toString();
        }
        return null;
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        for (SpecTypePair specTypePair : this.listSpecTypePairs()) {
            specTypePair.linkTableStringsInternal(tableStringPool);
        }
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        for (SpecTypePair specTypePair : this.listSpecTypePairs()) {
            specTypePair.linkSpecStringsInternal(specStringPool);
        }
    }

    public void destroy() {
        this.getEntriesGroupMap().clear();
        this.getPackageBody().destroy();
        this.getTypeStringPool().destroy();
        this.getSpecStringPool().destroy();
        this.setId(0);
        this.setName("");
    }

    public Entry getEntry(String qualifiers, String type, String name) {
        return this.getSpecTypePairArray().getEntry(qualifiers, type, name);
    }

    public Entry getEntry(ResConfig resConfig, String type, String name) {
        return this.getSpecTypePairArray().getEntry(resConfig, type, name);
    }

    public Entry getOrCreate(String qualifiers, String type, String name) {
        return this.getOrCreate(ResConfig.parse(qualifiers), type, name);
    }

    public Entry getOrCreate(ResConfig resConfig, String typeName, String name) {
        SpecTypePair specTypePair = this.getOrCreateSpecTypePair(typeName);
        TypeBlock typeBlock = specTypePair.getOrCreateTypeBlock(resConfig);
        return typeBlock.getOrCreateEntry(name);
    }

    public TypeBlock getOrCreateTypeBlock(String qualifiers, String typeName) {
        SpecTypePair specTypePair = this.getOrCreateSpecTypePair(typeName);
        return specTypePair.getOrCreateTypeBlock(qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(ResConfig resConfig, String typeName) {
        SpecTypePair specTypePair = this.getOrCreateSpecTypePair(typeName);
        return specTypePair.getOrCreateTypeBlock(resConfig);
    }

    public SpecTypePair getOrCreateSpecTypePair(String typeName) {
        return this.getSpecTypePairArray().getOrCreate(typeName);
    }

    public int getTypeIdOffset() {
        return ((PackageHeader)this.getHeaderBlock()).getTypeIdOffset();
    }

    public BlockList<UnknownChunk> getUnknownChunkList() {
        return this.mBody.getUnknownChunkList();
    }

    public StagedAliasEntry searchByStagedResId(int stagedResId) {
        for (StagedAlias stagedAlias : this.getStagedAliasList().getChildes()) {
            StagedAliasEntry entry = stagedAlias.getStagedAliasEntryArray().searchByStagedResId(stagedResId);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public List<StagedAlias> listStagedAlias() {
        return this.getStagedAliasList().getChildes();
    }

    public StagedAliasList getStagedAliasList() {
        return this.mBody.getStagedAliasList();
    }

    public OverlayableList getOverlayableList() {
        return this.mBody.getOverlayableList();
    }

    public BlockList<OverlayablePolicy> getOverlayablePolicyList() {
        return this.mBody.getOverlayablePolicyList();
    }

    public void sortTypes() {
        this.getSpecTypePairArray().sort();
    }

    public void removeEmpty() {
        this.getSpecTypePairArray().removeEmptyPairs();
    }

    public boolean isEmpty() {
        return this.getSpecTypePairArray().isEmpty();
    }

    public int getId() {
        return ((PackageHeader)this.getHeaderBlock()).getPackageId().get();
    }

    public void setId(byte id) {
        this.setId(0xFF & id);
    }

    public void setId(int id) {
        ((PackageHeader)this.getHeaderBlock()).getPackageId().set(id);
    }

    public String getName() {
        return ((PackageHeader)this.getHeaderBlock()).getPackageName().get();
    }

    public void setName(String name) {
        ((PackageHeader)this.getHeaderBlock()).getPackageName().set(name);
    }

    public TableBlock getTableBlock() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TableBlock)) continue;
            return (TableBlock)parent;
        }
        return null;
    }

    public TypeStringPool getTypeStringPool() {
        return this.mTypeStringPool;
    }

    public SpecStringPool getSpecStringPool() {
        return this.mSpecStringPool;
    }

    @Override
    public TableBlock getMainChunk() {
        return this.getTableBlock();
    }

    @Override
    public PackageBlock getPackageBlock() {
        return this;
    }

    public PackageBody getPackageBody() {
        return this.mBody;
    }

    public SpecTypePairArray getSpecTypePairArray() {
        return this.mBody.getSpecTypePairArray();
    }

    public Collection<LibraryInfo> listLibraryInfo() {
        return this.getLibraryBlock().listLibraryInfo();
    }

    public void addLibrary(LibraryBlock libraryBlock) {
        if (libraryBlock == null) {
            return;
        }
        for (LibraryInfo info : libraryBlock.getLibraryInfoArray().listItems()) {
            this.addLibraryInfo(info);
        }
    }

    public void addLibraryInfo(LibraryInfo info) {
        this.getLibraryBlock().addLibraryInfo(info);
    }

    public LibraryBlock getLibraryBlock() {
        return this.mBody.getLibraryBlock();
    }

    public Set<Integer> listResourceIds() {
        return this.getEntriesGroupMap().keySet();
    }

    public Entry getOrCreateEntry(byte typeId, short entryId, String qualifiers) {
        return this.getSpecTypePairArray().getOrCreateEntry(typeId, entryId, qualifiers);
    }

    public Entry getAnyEntry(int resourceId) {
        int packageId = resourceId >> 24 & 0xFF;
        if (packageId != this.getId()) {
            return null;
        }
        byte typeId = (byte)(resourceId >> 16 & 0xFF);
        short entryId = (short)(resourceId & 0xFFFF);
        return this.getSpecTypePairArray().getAnyEntry(typeId, entryId);
    }

    public Entry getEntry(byte typeId, short entryId, String qualifiers) {
        return this.getSpecTypePairArray().getEntry(typeId, entryId, qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(byte typeId, String qualifiers) {
        return this.getSpecTypePairArray().getOrCreateTypeBlock(typeId, qualifiers);
    }

    public TypeBlock getTypeBlock(byte typeId, String qualifiers) {
        return this.getSpecTypePairArray().getTypeBlock(typeId, qualifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockEntryGroup() {
        PackageBlock packageBlock = this;
        synchronized (packageBlock) {
            if (!this.entryGroupMapLocked) {
                return;
            }
            this.entryGroupMapLocked = false;
            Map<Integer, EntryGroup> map = this.mEntriesGroup;
            map.clear();
            this.createEntryGroupMap(map);
        }
    }

    private void createEntryGroupMap(Map<Integer, EntryGroup> map) {
        map.clear();
        for (SpecTypePair specTypePair : this.listSpecTypePairs()) {
            map.putAll(specTypePair.createEntryGroups(true));
        }
    }

    public Map<Integer, EntryGroup> getEntriesGroupMap() {
        this.unlockEntryGroup();
        return this.mEntriesGroup;
    }

    public Collection<EntryGroup> listEntryGroup() {
        return this.getEntriesGroupMap().values();
    }

    public int getEntryGroupCount() {
        return this.getEntriesGroupMap().size();
    }

    public EntryGroup getEntryGroup(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        EntryGroup entryGroup = this.getEntriesGroupMap().get(resourceId);
        if (entryGroup != null) {
            return entryGroup;
        }
        StagedAliasEntry stagedAliasEntry = this.searchByStagedResId(resourceId);
        if (stagedAliasEntry != null) {
            return this.getEntriesGroupMap().get(stagedAliasEntry.getFinalizedResId());
        }
        return null;
    }

    public void updateEntry(Entry entry) {
        if (this.entryGroupMapLocked) {
            return;
        }
        if (entry == null || entry.isNull()) {
            return;
        }
        int resourceId = entry.getResourceId();
        Map<Integer, EntryGroup> map = this.getEntriesGroupMap();
        EntryGroup group = map.get(resourceId);
        if (group == null) {
            group = new EntryGroup(resourceId);
            map.put(resourceId, group);
        }
        group.add(entry);
    }

    public void removeEntryGroup(Entry entry) {
        if (entry == null) {
            return;
        }
        int resourceId = entry.getResourceId();
        Map<Integer, EntryGroup> map = this.getEntriesGroupMap();
        EntryGroup group = map.get(resourceId);
        if (group == null) {
            return;
        }
        group.remove(entry);
        if (group.size() == 0) {
            map.remove(resourceId);
        }
    }

    public List<Entry> listEntries(byte typeId, int entryId) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        for (SpecTypePair pair : this.listSpecTypePair(typeId)) {
            results.addAll(pair.listEntries(entryId));
        }
        return results;
    }

    public List<SpecTypePair> listSpecTypePair(byte typeId) {
        ArrayList<SpecTypePair> results = new ArrayList<SpecTypePair>();
        for (SpecTypePair specTypePair : this.listSpecTypePairs()) {
            if (typeId != specTypePair.getTypeId()) continue;
            results.add(specTypePair);
        }
        return results;
    }

    public SpecTypePair getSpecTypePair(String typeName) {
        return this.getSpecTypePairArray().getSpecTypePair(typeName);
    }

    public SpecTypePair getSpecTypePair(int typeId) {
        return this.getSpecTypePairArray().getSpecTypePair((byte)typeId);
    }

    public EntryGroup getEntryGroup(String typeName, String entryName) {
        return this.getSpecTypePairArray().getEntryGroup(typeName, entryName);
    }

    public Collection<SpecTypePair> listSpecTypePairs() {
        return this.getSpecTypePairArray().listItems();
    }

    @Deprecated
    public Collection<SpecTypePair> listAllSpecTypePair() {
        return this.listSpecTypePairs();
    }

    private void refreshTypeStringPoolOffset() {
        int pos = this.countUpTo(this.mTypeStringPool);
        ((PackageHeader)this.getHeaderBlock()).getTypeStringPoolOffset().set(pos);
    }

    private void refreshTypeStringPoolCount() {
        ((PackageHeader)this.getHeaderBlock()).getTypeStringPoolCount().set(this.mTypeStringPool.countStrings());
    }

    private void refreshSpecStringPoolOffset() {
        int pos = this.countUpTo(this.mSpecStringPool);
        ((PackageHeader)this.getHeaderBlock()).getSpecStringPoolOffset().set(pos);
    }

    private void refreshSpecStringCount() {
        ((PackageHeader)this.getHeaderBlock()).getSpecStringPoolCount().set(this.mSpecStringPool.countStrings());
    }

    public void onEntryAdded(Entry entry) {
        this.updateEntry(entry);
    }

    @Override
    public void onChunkLoaded() {
    }

    @Override
    protected void onChunkRefreshed() {
        this.refreshTypeStringPoolOffset();
        this.refreshTypeStringPoolCount();
        this.refreshSpecStringPoolOffset();
        this.refreshSpecStringCount();
    }

    @Override
    public JSONObject toJson() {
        return this.toJson(true);
    }

    public JSONObject toJson(boolean addTypes) {
        JSONArray jsonArray;
        StagedAlias stagedAlias;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arsc_lib_version", BuildInfo.getVersion());
        jsonObject.put(NAME_package_id, this.getId());
        jsonObject.put(NAME_package_name, this.getName());
        jsonObject.put(NAME_specs, this.getSpecTypePairArray().toJson(!addTypes));
        LibraryInfoArray libraryInfoArray = this.getLibraryBlock().getLibraryInfoArray();
        if (libraryInfoArray.childesCount() > 0) {
            jsonObject.put(NAME_libraries, libraryInfoArray.toJson());
        }
        if ((stagedAlias = StagedAlias.mergeAll(this.getStagedAliasList().getChildes())) != null) {
            jsonObject.put(NAME_staged_aliases, stagedAlias.getStagedAliasEntryArray().toJson());
        }
        if ((jsonArray = this.getOverlayableList().toJson()) != null) {
            jsonObject.put(NAME_overlaybles, jsonArray);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setId(json.getInt(NAME_package_id));
        this.setName(json.getString(NAME_package_name));
        this.getSpecTypePairArray().fromJson(json.optJSONArray(NAME_specs));
        LibraryInfoArray libraryInfoArray = this.getLibraryBlock().getLibraryInfoArray();
        libraryInfoArray.fromJson(json.optJSONArray(NAME_libraries));
        if (json.has(NAME_staged_aliases)) {
            StagedAlias stagedAlias = new StagedAlias();
            stagedAlias.getStagedAliasEntryArray().fromJson(json.getJSONArray(NAME_staged_aliases));
            this.getStagedAliasList().add(stagedAlias);
        }
        if (json.has(NAME_overlaybles)) {
            this.getOverlayableList().fromJson(json.getJSONArray(NAME_overlaybles));
        }
    }

    public void merge(PackageBlock packageBlock) {
        if (packageBlock == null || packageBlock == this) {
            return;
        }
        if (this.getId() != packageBlock.getId()) {
            throw new IllegalArgumentException("Can not merge different id packages: " + this.getId() + "!=" + packageBlock.getId());
        }
        this.setName(packageBlock.getName());
        this.getLibraryBlock().merge(packageBlock.getLibraryBlock());
        this.mergeSpecStringPool(packageBlock);
        this.getSpecTypePairArray().merge(packageBlock.getSpecTypePairArray());
        this.getOverlayableList().merge(packageBlock.getOverlayableList());
        this.getStagedAliasList().merge(packageBlock.getStagedAliasList());
    }

    private void mergeSpecStringPool(PackageBlock coming) {
        this.getSpecStringPool().addStrings(coming.getSpecStringPool().toStringList());
    }

    @Override
    public int compareTo(PackageBlock pkg) {
        return Integer.compare(this.getId(), pkg.getId());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", id=");
        builder.append(HexUtil.toHex2((byte)this.getId()));
        builder.append(", name=");
        builder.append(this.getName());
        int libCount = this.getLibraryBlock().getLibraryCount();
        if (libCount > 0) {
            builder.append(", libraries=");
            builder.append(libCount);
        }
        return builder.toString();
    }
}

