/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.array.LibraryInfoArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.header.LibraryHeader;
import com.reandroid.arsc.value.LibraryInfo;
import java.util.Collection;

public class LibraryBlock
extends Chunk<LibraryHeader> {
    private final LibraryInfoArray mLibraryInfoArray;

    public LibraryBlock() {
        super(new LibraryHeader(), 1);
        LibraryHeader header = (LibraryHeader)this.getHeaderBlock();
        this.mLibraryInfoArray = new LibraryInfoArray(header.getCount());
        this.addChild(this.mLibraryInfoArray);
    }

    public LibraryInfoArray getLibraryInfoArray() {
        return this.mLibraryInfoArray;
    }

    public void addLibraryInfo(LibraryBlock libraryBlock) {
        if (libraryBlock == null) {
            return;
        }
        for (LibraryInfo info : libraryBlock.getLibraryInfoArray().listItems()) {
            this.addLibraryInfo(info);
        }
    }

    public void addLibraryInfo(LibraryInfo info) {
        if (info == null) {
            return;
        }
        this.getLibraryInfoArray().add(info);
        ((LibraryHeader)this.getHeaderBlock()).getCount().set(this.mLibraryInfoArray.childesCount());
    }

    public Collection<LibraryInfo> listLibraryInfo() {
        return this.getLibraryInfoArray().listItems();
    }

    @Override
    public boolean isNull() {
        return this.mLibraryInfoArray.childesCount() == 0;
    }

    public int getLibraryCount() {
        return this.mLibraryInfoArray.childesCount();
    }

    public void setLibraryCount(int count) {
        ((LibraryHeader)this.getHeaderBlock()).getCount().set(count);
        this.mLibraryInfoArray.setChildesCount(count);
    }

    @Override
    protected void onChunkRefreshed() {
        ((LibraryHeader)this.getHeaderBlock()).getCount().set(this.mLibraryInfoArray.childesCount());
    }

    public void merge(LibraryBlock libraryBlock) {
        if (libraryBlock == null || libraryBlock == this) {
            return;
        }
        this.getLibraryInfoArray().merge(libraryBlock.getLibraryInfoArray());
    }
}

