/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.util.HexUtil;

public enum ChunkType {
    NULL(0),
    STRING(1),
    TABLE(2),
    XML(3),
    XML_START_NAMESPACE(256),
    XML_END_NAMESPACE(257),
    XML_START_ELEMENT(258),
    XML_END_ELEMENT(259),
    XML_CDATA(260),
    XML_LAST_CHUNK(383),
    XML_RESOURCE_MAP(384),
    PACKAGE(512),
    TYPE(513),
    SPEC(514),
    LIBRARY(515),
    OVERLAYABLE(516),
    OVERLAYABLE_POLICY(517),
    STAGED_ALIAS(518);

    public final short ID;
    private static final ChunkType[] table_chunk_types;
    private static final ChunkType[] xml_chunk_types;

    private ChunkType(short id) {
        this.ID = id;
    }

    public String toString() {
        return this.name() + "(" + HexUtil.toHex4(this.ID) + ")";
    }

    public static ChunkType get(short id) {
        ChunkType[] all;
        for (ChunkType t : all = ChunkType.values()) {
            if (t.ID != id) continue;
            return t;
        }
        return null;
    }

    public static ChunkType getTable(short id) {
        for (ChunkType t : table_chunk_types) {
            if (t.ID != id) continue;
            return t;
        }
        return null;
    }

    public static ChunkType getXml(short id) {
        for (ChunkType t : xml_chunk_types) {
            if (t.ID != id) continue;
            return t;
        }
        return null;
    }

    static {
        table_chunk_types = new ChunkType[]{PACKAGE, TYPE, SPEC, LIBRARY};
        xml_chunk_types = new ChunkType[]{XML_START_NAMESPACE, XML_END_NAMESPACE, XML_START_ELEMENT, XML_END_ELEMENT, XML_CDATA, XML_LAST_CHUNK, XML_RESOURCE_MAP};
    }
}

