/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArrayCreator;
import com.reandroid.arsc.base.BlockContainer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public abstract class BlockArray<T extends Block>
extends BlockContainer<T>
implements BlockArrayCreator<T> {
    private T[] elementData = this.newInstance(0);

    public void removeAllNull(int start) {
        this.removeAll(start, true);
    }

    public void removeAll(int start) {
        this.removeAll(start, false);
    }

    private void removeAll(int start, boolean check_null) {
        List<T> removeList = this.subList(start);
        if (removeList.size() == 0 || check_null && !BlockArray.isAllNull(removeList)) {
            return;
        }
        T[] itemArray = this.elementData;
        for (Block item : removeList) {
            int index;
            if (item == null) continue;
            if (!item.isNull()) {
                item.setNull(true);
            }
            if ((index = item.getIndex()) < 0 || itemArray[index] != item) continue;
            item.setIndex(-1);
            item.setParent(null);
            itemArray[index] = null;
        }
        this.setChildesCount(start);
    }

    public List<T> subList(int start) {
        return this.subList(start, -1);
    }

    public List<T> subList(int start, int count) {
        int end;
        T[] items = this.elementData;
        if (items == null) {
            return new ArrayList();
        }
        int length = items.length;
        if (start >= length) {
            return new ArrayList();
        }
        if (start < 0) {
            start = 0;
        }
        if ((end = count) < 0) {
            end = items.length;
        } else {
            end = start + count;
            if (end > length) {
                end = length;
            }
        }
        ArrayList<T> results = new ArrayList<T>(end - start);
        for (int i = start; i < end; ++i) {
            results.add(items[i]);
        }
        return results;
    }

    public Collection<T> listItems() {
        return this.listItems(false);
    }

    public Collection<T> listItems(final boolean skipNullBlocks) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return BlockArray.this.iterator(skipNullBlocks);
            }

            @Override
            public boolean contains(Object o) {
                return BlockArray.this.contains(o);
            }

            @Override
            public int size() {
                return BlockArray.this.childesCount();
            }
        };
    }

    @Override
    public T[] getChildes() {
        return this.elementData;
    }

    public void ensureSize(int size) {
        if (size <= this.childesCount()) {
            return;
        }
        this.setChildesCount(size);
    }

    public void setChildesCount(int count) {
        if (count < 0) {
            count = 0;
        }
        if (count == 0) {
            this.clearChildes();
            return;
        }
        int diff = count - this.childesCount();
        if (diff == 0) {
            return;
        }
        this.changeSize(diff);
    }

    public void clearChildes() {
        T[] allChildes = this.elementData;
        if (allChildes == null || allChildes.length == 0) {
            return;
        }
        for (T block : allChildes) {
            if (block == null) continue;
            ((Block)block).setIndex(-1);
            ((Block)block).setParent(null);
            allChildes[i] = null;
        }
        this.elementData = this.newInstance(0);
    }

    public void addAll(T[] blocks) {
        if (blocks == null || blocks.length == 0) {
            return;
        }
        Object[] old = this.elementData;
        if (old == null) {
            old = this.newInstance(0);
        }
        int oldLen = old.length;
        int len = blocks.length;
        Block[] update = this.newInstance(oldLen + len);
        if (oldLen > 0) {
            System.arraycopy(old, 0, update, 0, oldLen);
        }
        boolean foundNull = false;
        for (int i = 0; i < len; ++i) {
            T item = blocks[i];
            if (item == null) {
                foundNull = true;
                continue;
            }
            int index = oldLen + i;
            update[index] = item;
            ((Block)item).setParent(this);
            ((Block)item).setIndex(index);
        }
        this.elementData = update;
        if (foundNull) {
            this.trimNullBlocks();
        }
    }

    public void sort(Comparator<T> comparator) {
        T[] data = this.elementData;
        if (comparator == null || data == null || data.length < 2) {
            return;
        }
        Arrays.sort(data, 0, data.length, comparator);
        for (int i = 0; i < data.length; ++i) {
            ((Block)data[i]).setIndex(i);
        }
    }

    public void insertItem(int index, T item) {
        int lastIndex;
        int count = this.childesCount();
        if (count < index) {
            count = index;
        }
        this.ensureSize(count + 1);
        Block[] childes = this.getChildes();
        for (int i = lastIndex = childes.length - 2; i >= index; --i) {
            Block exist = childes[i];
            childes[i] = null;
            int newIndex = i + 1;
            childes[newIndex] = exist;
            exist.setIndex(newIndex);
        }
        childes[index] = item;
        ((Block)item).setParent(this);
        ((Block)item).setIndex(index);
    }

    public void setItem(int index, T item) {
        this.ensureSize(index + 1);
        this.elementData[index] = item;
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
    }

    public void add(T block) {
        if (block == null) {
            return;
        }
        T[] old = this.elementData;
        int index = old.length;
        this.elementData = this.newInstance(index + 1);
        if (index > 0) {
            System.arraycopy(old, 0, this.elementData, 0, index);
        }
        this.elementData[index] = block;
        ((Block)block).setIndex(index);
        ((Block)block).setParent(this);
    }

    public final int countNonNull() {
        return this.countNonNull(true);
    }

    @Override
    public final int childesCount() {
        return this.elementData.length;
    }

    public final T createNext() {
        Object block = this.newInstance();
        this.add(block);
        return block;
    }

    public final T get(int i) {
        if (i >= this.childesCount() || i < 0) {
            return null;
        }
        return this.elementData[i];
    }

    public int indexOf(Object block) {
        T[] items = this.elementData;
        if (items == null) {
            return -1;
        }
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            if (block != items[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object block) {
        T[] items = this.elementData;
        if (items == null) {
            return -1;
        }
        int len = items.length;
        int result = -1;
        for (int i = 0; i < len; ++i) {
            if (block != items[i]) continue;
            result = i;
        }
        return result;
    }

    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    public Iterator<T> iterator(boolean skipNullBlock) {
        return new BlockIterator(skipNullBlock);
    }

    public Iterator<T> iterator(Predicate<T> tester) {
        return new PredicateIterator(tester);
    }

    public boolean contains(Object block) {
        T[] items = this.elementData;
        if (block == null || items == null) {
            return false;
        }
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            if (!this.isEqual(items[i], block)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEqual(T item, Object obj) {
        return obj == item;
    }

    public void remove(Collection<T> blockList) {
        T[] items = this.elementData;
        if (items == null || items.length == 0) {
            return;
        }
        int len = items.length;
        for (Block block : blockList) {
            int i;
            if (block == null || (i = block.getIndex()) < 0 || i >= len || items[i] != block) continue;
            items[i] = null;
        }
        this.trimNullBlocks();
    }

    public boolean remove(T block) {
        return this.remove(block, true);
    }

    protected boolean remove(T block, boolean trim) {
        T[] items = this.elementData;
        if (block == null || items == null) {
            return false;
        }
        boolean found = false;
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            if (block != items[i]) continue;
            items[i] = null;
            found = true;
        }
        if (found && trim) {
            this.trimNullBlocks();
        }
        return found;
    }

    protected void trimNullBlocks() {
        int len;
        T[] items = this.elementData;
        if (items == null) {
            return;
        }
        int count = this.countNonNull(false);
        if (count == (len = items.length)) {
            return;
        }
        Block[] update = this.newInstance(count);
        int index = 0;
        for (int i = 0; i < len; ++i) {
            T block = items[i];
            if (block == null) continue;
            update[index] = block;
            ((Block)block).setIndex(index);
            ++index;
        }
        this.elementData = update;
    }

    private int countNonNull(boolean is_null_check) {
        T[] items = this.elementData;
        if (items == null) {
            return 0;
        }
        int result = 0;
        for (T block : items) {
            if (block == null || is_null_check && ((Block)block).isNull()) continue;
            ++result;
        }
        return result;
    }

    private void changeSize(int amount) {
        T[] old = this.elementData;
        int index = old.length;
        int size = index + amount;
        Block[] update = this.newInstance(size);
        int end = index > size ? size : index;
        if (end > 0) {
            System.arraycopy(old, 0, update, 0, end);
        }
        for (int i = end; i < size; ++i) {
            Object item = this.newInstance();
            update[i] = item;
            ((Block)item).setIndex(i);
            ((Block)item).setParent(this);
        }
        this.elementData = update;
    }

    public String toString() {
        return "count=" + this.childesCount();
    }

    public static boolean isAllNull(Collection<? extends Block> itemsList) {
        for (Block block : itemsList) {
            if (block == null || block.isNull()) continue;
            return false;
        }
        return true;
    }

    private class PredicateIterator
    implements Iterator<T> {
        private int mCursor;
        private final int mMaxSize;
        private final Predicate<T> mTester;

        PredicateIterator(Predicate<T> tester) {
            this.mTester = tester;
            this.mCursor = 0;
            this.mMaxSize = BlockArray.this.childesCount();
        }

        @Override
        public boolean hasNext() {
            this.checkCursor();
            return this.hasItems();
        }

        @Override
        public T next() {
            if (this.hasItems()) {
                Object item = BlockArray.this.get(this.mCursor);
                ++this.mCursor;
                this.checkCursor();
                return item;
            }
            return null;
        }

        private boolean hasItems() {
            return this.mCursor < this.mMaxSize;
        }

        private void checkCursor() {
            if (this.mTester == null) {
                return;
            }
            while (this.hasItems() && !this.test(BlockArray.this.get(this.getCursor()))) {
                ++this.mCursor;
            }
        }

        private int getCursor() {
            return this.mCursor;
        }

        private boolean test(T item) {
            Predicate tester = this.mTester;
            if (tester != null) {
                return tester.test(item);
            }
            return true;
        }
    }

    private class BlockIterator
    implements Iterator<T> {
        private int mCursor;
        private final int mMaxSize;
        private final boolean mSkipNullBlock;

        BlockIterator(boolean skipNullBlock) {
            this.mSkipNullBlock = skipNullBlock;
            this.mCursor = 0;
            this.mMaxSize = BlockArray.this.childesCount();
        }

        @Override
        public boolean hasNext() {
            this.checkCursor();
            return !this.isFinished();
        }

        @Override
        public T next() {
            if (!this.isFinished()) {
                Object item = BlockArray.this.get(this.mCursor);
                ++this.mCursor;
                this.checkCursor();
                return item;
            }
            return null;
        }

        private boolean isFinished() {
            return this.mCursor >= this.mMaxSize;
        }

        private void checkCursor() {
            if (!this.mSkipNullBlock || this.isFinished()) {
                return;
            }
            Object item = BlockArray.this.get(this.mCursor);
            while (item == null || ((Block)item).isNull()) {
                ++this.mCursor;
                item = BlockArray.this.get(this.mCursor);
                if (this.mCursor < this.mMaxSize) continue;
                break;
            }
        }
    }
}

