/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Block {
    private int mIndex = -1;
    private Block mParent;
    private boolean mNull;
    private BlockLoad mBlockLoad;

    public abstract byte[] getBytes();

    public abstract int countBytes();

    public final int countUpTo(Block block) {
        BlockCounter counter = new BlockCounter(block);
        this.onCountUpTo(counter);
        return counter.COUNT;
    }

    public abstract void onCountUpTo(BlockCounter var1);

    public final void readBytes(BlockReader reader) throws IOException {
        this.onReadBytes(reader);
        this.notifyBlockLoad(reader);
    }

    public final void setBlockLoad(BlockLoad blockLoad) {
        this.mBlockLoad = blockLoad;
    }

    public void notifyBlockLoad() throws IOException {
        this.notifyBlockLoad(null);
    }

    private void notifyBlockLoad(BlockReader reader) throws IOException {
        BlockLoad blockLoad = this.mBlockLoad;
        if (blockLoad != null) {
            blockLoad.onBlockLoaded(reader, this);
        }
    }

    protected void onReadBytes(BlockReader reader) throws IOException {
    }

    public final int writeBytes(OutputStream stream) throws IOException {
        if (this.isNull()) {
            return 0;
        }
        return this.onWriteBytes(stream);
    }

    protected abstract int onWriteBytes(OutputStream var1) throws IOException;

    public boolean isNull() {
        return this.mNull;
    }

    public void setNull(boolean is_null) {
        this.mNull = is_null;
    }

    public final int getIndex() {
        return this.mIndex;
    }

    public final void setIndex(int index) {
        int old = this.mIndex;
        if (index == old) {
            return;
        }
        this.mIndex = index;
        if (old != -1 && index != -1) {
            this.onIndexChanged(old, index);
        }
    }

    public void onIndexChanged(int oldIndex, int newIndex) {
    }

    public final void setParent(Block parent) {
        if (parent == this) {
            return;
        }
        this.mParent = parent;
    }

    public final Block getParent() {
        return this.mParent;
    }

    public final <T> T getParent(Class<T> parentClass) {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getClass() != parentClass) continue;
            return (T)parent;
        }
        return null;
    }

    public final <T> T getParentInstance(Class<T> parentClass) {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            return (T)parent;
        }
        return null;
    }

    protected static byte[] addBytes(byte[] bts1, byte[] bts2) {
        boolean empty2;
        boolean empty1 = bts1 == null || bts1.length == 0;
        boolean bl = empty2 = bts2 == null || bts2.length == 0;
        if (empty1 && empty2) {
            return null;
        }
        if (empty1) {
            return bts2;
        }
        if (empty2) {
            return bts1;
        }
        int len = bts1.length + bts2.length;
        byte[] result = new byte[len];
        int start = bts1.length;
        System.arraycopy(bts1, 0, result, 0, start);
        System.arraycopy(bts2, 0, result, start, bts2.length);
        return result;
    }
}

