/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.OffsetBlockArray;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import java.io.IOException;

public class StyleArray
extends OffsetBlockArray<StyleItem>
implements JSONConvert<JSONArray> {
    private static final byte END_BYTE = -1;

    public StyleArray(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart) {
        super(offsets, itemCount, itemStart);
        this.setEndBytes((byte)-1);
    }

    @Override
    public void clearChildes() {
        for (StyleItem styleItem : this.listItems()) {
            styleItem.onRemoved();
        }
        super.clearChildes();
    }

    @Override
    void refreshEnd4Block(BlockReader reader, ByteArray end4Block) throws IOException {
        end4Block.clear();
        if (reader.available() < 4) {
            return;
        }
        IntegerItem integerItem = new IntegerItem();
        while (reader.available() >= 4) {
            int pos = reader.getPosition();
            integerItem.readBytes(reader);
            if (integerItem.get() != -1) {
                reader.seek(pos);
                break;
            }
            end4Block.add(integerItem.getBytes());
        }
    }

    @Override
    void refreshEnd4Block(ByteArray end4Block) {
        super.refreshEnd4Block(end4Block);
        if (this.childesCount() == 0) {
            return;
        }
        end4Block.ensureArraySize(8);
        end4Block.fill((byte)-1);
    }

    @Override
    protected void refreshChildes() {
    }

    @Override
    public StyleItem newInstance() {
        return new StyleItem();
    }

    public StyleItem[] newInstance(int len) {
        return new StyleItem[len];
    }

    @Override
    public JSONArray toJson() {
        if (this.childesCount() == 0) {
            return null;
        }
        return null;
    }

    @Override
    public void fromJson(JSONArray json) {
    }

    public void merge(StyleArray styleArray) {
        if (styleArray == null || styleArray == this) {
            return;
        }
        if (this.childesCount() != 0) {
            return;
        }
        int count = styleArray.childesCount();
        this.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            StyleItem exist = (StyleItem)this.get(i);
            StyleItem coming = (StyleItem)styleArray.get(i);
            exist.merge(coming);
        }
    }
}

