/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.OffsetBlockArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public abstract class StringArray<T extends StringItem>
extends OffsetBlockArray<T>
implements JSONConvert<JSONArray> {
    private boolean mUtf8;

    public StringArray(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        super(offsets, itemCount, itemStart);
        this.mUtf8 = is_utf8;
        this.setEndBytes((byte)0);
    }

    public List<String> toStringList() {
        return new AbstractList<String>(){

            @Override
            public String get(int i) {
                StringItem item = (StringItem)StringArray.this.get(i);
                if (item == null) {
                    return null;
                }
                return item.getHtml();
            }

            @Override
            public int size() {
                return StringArray.this.childesCount();
            }
        };
    }

    public List<T> removeUnusedStrings() {
        List<T> unusedList = this.listUnusedStringsToRemove();
        this.remove(unusedList);
        for (StringItem item : unusedList) {
            item.onRemoved();
        }
        return unusedList;
    }

    List<T> listUnusedStringsToRemove() {
        return this.listUnusedStrings();
    }

    public List<T> listUnusedStrings() {
        ArrayList<StringItem> results = new ArrayList<StringItem>();
        for (StringItem item : this.listItems()) {
            if (item.hasReference()) continue;
            results.add(item);
        }
        return results;
    }

    public void setUtf8(boolean is_utf8) {
        if (this.mUtf8 == is_utf8) {
            return;
        }
        this.mUtf8 = is_utf8;
        StringItem[] childes = (StringItem[])this.getChildes();
        if (childes != null) {
            int max = childes.length;
            for (int i = 0; i < max; ++i) {
                childes[i].setUtf8(is_utf8);
            }
        }
    }

    public boolean isUtf8() {
        return this.mUtf8;
    }

    @Override
    protected void refreshChildes() {
    }

    @Override
    public JSONArray toJson() {
        return this.toJson(true);
    }

    public JSONArray toJson(boolean styledOnly) {
        if (this.childesCount() == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (StringItem item : this.listItems()) {
            JSONObject jsonObject;
            if (item.isNull() || styledOnly && !item.hasStyle() || (jsonObject = item.toJson()) == null) continue;
            jsonArray.put(i, jsonObject);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + ".fromJson() NOT implemented");
    }
}

