/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.value.StagedAliasEntry;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import java.io.IOException;

public class StagedAliasEntryArray
extends BlockArray<StagedAliasEntry>
implements BlockLoad,
JSONConvert<JSONArray> {
    private final IntegerItem count;

    public StagedAliasEntryArray(IntegerItem count) {
        this.count = count;
        this.count.setBlockLoad(this);
    }

    public boolean contains(StagedAliasEntry aliasEntry) {
        StagedAliasEntry[] childes = (StagedAliasEntry[])this.getChildes();
        if (childes == null) {
            return false;
        }
        for (int i = 0; i < childes.length; ++i) {
            StagedAliasEntry entry = childes[i];
            if (!entry.isEqual(aliasEntry)) continue;
            return true;
        }
        return false;
    }

    public StagedAliasEntry searchByStagedResId(int stagedResId) {
        StagedAliasEntry[] childes = (StagedAliasEntry[])this.getChildes();
        if (childes == null) {
            return null;
        }
        for (int i = 0; i < childes.length; ++i) {
            StagedAliasEntry entry = childes[i];
            if (stagedResId != entry.getStagedResId()) continue;
            return entry;
        }
        return null;
    }

    public void addAll(StagedAliasEntry[] aliasEntries) {
        super.addAll((Block[])aliasEntries);
        this.updateCount();
    }

    public StagedAliasEntry[] newInstance(int len) {
        return new StagedAliasEntry[len];
    }

    @Override
    protected void onRefreshed() {
        this.updateCount();
    }

    @Override
    public StagedAliasEntry newInstance() {
        return new StagedAliasEntry();
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.count) {
            this.setChildesCount(this.count.get());
        }
    }

    private void updateCount() {
        this.count.set(this.childesCount());
    }

    @Override
    public JSONArray toJson() {
        StagedAliasEntry[] childes = (StagedAliasEntry[])this.getChildes();
        if (childes == null || childes.length == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < childes.length; ++i) {
            jsonArray.put(i, childes[i].toJson());
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clearChildes();
        if (json == null) {
            return;
        }
        int length = json.length();
        this.setChildesCount(length);
        for (int i = 0; i < length; ++i) {
            ((StagedAliasEntry)this.get(i)).fromJson(json.getJSONObject(i));
        }
    }
}

