/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SpecTypePairArray
extends BlockArray<SpecTypePair>
implements JSONConvert<JSONArray>,
Comparator<SpecTypePair> {
    public void sort() {
        for (SpecTypePair specTypePair : this.listItems()) {
            specTypePair.sortTypes();
        }
        this.sort(this);
    }

    public void removeEmptyPairs() {
        ArrayList allPairs = new ArrayList(this.listItems());
        boolean foundEmpty = false;
        for (SpecTypePair typePair : allPairs) {
            typePair.removeEmptyTypeBlocks();
            if (!typePair.isEmpty()) continue;
            super.remove(typePair, false);
            foundEmpty = true;
        }
        if (foundEmpty) {
            this.trimNullBlocks();
        }
    }

    public boolean isEmpty() {
        Iterator iterator = this.iterator(true);
        while (iterator.hasNext()) {
            SpecTypePair pair = (SpecTypePair)iterator.next();
            if (pair.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Entry getOrCreateEntry(byte typeId, short entryId, String qualifiers) {
        TypeBlock typeBlock = this.getOrCreateTypeBlock(typeId, qualifiers);
        return typeBlock.getOrCreateEntry(entryId);
    }

    public Entry getEntry(byte typeId, short entryId, String qualifiers) {
        TypeBlock typeBlock = this.getTypeBlock(typeId, qualifiers);
        if (typeBlock == null) {
            return null;
        }
        return typeBlock.getEntry(entryId);
    }

    public TypeBlock getOrCreateTypeBlock(byte typeId, String qualifiers) {
        SpecTypePair pair = this.getOrCreate(typeId);
        return pair.getOrCreateTypeBlock(qualifiers);
    }

    public TypeBlock getTypeBlock(byte typeId, String qualifiers) {
        SpecTypePair pair = this.getSpecTypePair(typeId);
        if (pair == null) {
            return null;
        }
        return pair.getTypeBlock(qualifiers);
    }

    public TypeBlock getOrCreate(byte typeId, ResConfig resConfig) {
        SpecTypePair pair = this.getOrCreate(typeId);
        return pair.getTypeBlockArray().getOrCreate(resConfig);
    }

    public SpecTypePair getOrCreate(byte typeId) {
        SpecTypePair pair = this.getSpecTypePair(typeId);
        if (pair != null) {
            return pair;
        }
        pair = (SpecTypePair)this.createNext();
        pair.setTypeId(typeId);
        return pair;
    }

    public SpecTypePair getOrCreate(String typeName) {
        SpecTypePair specTypePair = this.getSpecTypePair(typeName);
        if (specTypePair != null) {
            return specTypePair;
        }
        TypeString typeString = this.getOrCreateTypeString(typeName);
        byte id = (byte)typeString.getId();
        specTypePair = (SpecTypePair)this.createNext();
        specTypePair.setTypeId(id);
        return specTypePair;
    }

    public TypeBlock getOrCreateTypeBlock(String typeName, ResConfig resConfig) {
        return this.getOrCreate(typeName).getOrCreateTypeBlock(resConfig);
    }

    public TypeBlock getOrCreateTypeBlock(String typeName, String qualifiers) {
        return this.getOrCreate(typeName).getOrCreateTypeBlock(qualifiers);
    }

    public SpecTypePair getSpecTypePair(int typeId) {
        return this.getSpecTypePair((byte)typeId);
    }

    public SpecTypePair getSpecTypePair(byte typeId) {
        SpecTypePair[] items = (SpecTypePair[])this.getChildes();
        if (items == null) {
            return null;
        }
        for (SpecTypePair specTypePair : items) {
            if (specTypePair == null || specTypePair.getTypeId() != typeId) continue;
            return specTypePair;
        }
        return null;
    }

    public SpecTypePair getSpecTypePair(String typeName) {
        if (typeName == null) {
            return null;
        }
        Iterator itr = this.iterator(true);
        while (itr.hasNext()) {
            SpecTypePair specTypePair = (SpecTypePair)itr.next();
            if (!specTypePair.isEqualTypeName(typeName)) continue;
            return specTypePair;
        }
        return null;
    }

    public Entry getAnyEntry(byte typeId, short entryId) {
        if (typeId == 0) {
            return null;
        }
        SpecTypePair specTypePair = this.getSpecTypePair(typeId);
        if (specTypePair != null) {
            return specTypePair.getAnyEntry(entryId);
        }
        return null;
    }

    public Entry getAnyEntry(String typeName, String entryName) {
        SpecTypePair specTypePair = this.getSpecTypePair(typeName);
        if (specTypePair != null) {
            return specTypePair.getAnyEntry(entryName);
        }
        return null;
    }

    public Entry getEntry(String qualifiers, String typeName, String entryName) {
        ResConfig resConfig = new ResConfig();
        resConfig.parseQualifiers(qualifiers);
        return this.getEntry(resConfig, typeName, entryName);
    }

    public Entry getEntry(ResConfig resConfig, String typeName, String entryName) {
        SpecTypePair specTypePair = this.getSpecTypePair(typeName);
        if (specTypePair != null) {
            return specTypePair.getEntry(resConfig, entryName);
        }
        return null;
    }

    public EntryGroup getEntryGroup(String typeName, String entryName) {
        SpecTypePair specTypePair = this.getSpecTypePair(typeName);
        if (specTypePair != null) {
            return specTypePair.getEntryGroup(entryName);
        }
        return null;
    }

    @Override
    public SpecTypePair newInstance() {
        return new SpecTypePair();
    }

    public SpecTypePair[] newInstance(int len) {
        return new SpecTypePair[len];
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    protected void onPreRefreshRefresh() {
        this.validateEntryCounts();
    }

    private void validateEntryCounts() {
        Map<Byte, Integer> entryCountMap = this.mapHighestEntryCount();
        for (Map.Entry<Byte, Integer> entry : entryCountMap.entrySet()) {
            byte id = entry.getKey();
            int count = entry.getValue();
            SpecTypePair pair = this.getSpecTypePair(id);
            pair.getSpecBlock().setEntryCount(count);
            pair.getTypeBlockArray().setEntryCount(count);
        }
    }

    private Map<Byte, Integer> mapHighestEntryCount() {
        SpecTypePair[] childes;
        HashMap<Byte, Integer> results = new HashMap<Byte, Integer>();
        for (SpecTypePair pair : childes = (SpecTypePair[])this.getChildes()) {
            int count = pair.getHighestEntryCount();
            byte id = pair.getTypeId();
            Integer exist = (Integer)results.get(id);
            if (exist != null && count <= exist) continue;
            results.put(id, count);
        }
        return results;
    }

    public int getSmallestTypeId() {
        SpecTypePair[] childes = (SpecTypePair[])this.getChildes();
        if (childes == null) {
            return 0;
        }
        int result = 0;
        boolean firstFound = false;
        for (int i = 0; i < childes.length; ++i) {
            SpecTypePair pair = childes[i];
            if (pair == null) continue;
            int id = pair.getId();
            if (!firstFound) {
                result = id;
            }
            firstFound = true;
            if (id >= result) continue;
            result = id;
        }
        return result;
    }

    public int getHighestTypeId() {
        SpecTypePair[] childes = (SpecTypePair[])this.getChildes();
        if (childes == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < childes.length; ++i) {
            int id;
            SpecTypePair pair = childes[i];
            if (pair == null || (id = pair.getId()) <= result) continue;
            result = id;
        }
        return result;
    }

    private TypeString getOrCreateTypeString(String typeName) {
        TypeStringPool typeStringPool = this.getTypeStringPool();
        if (typeStringPool == null) {
            return null;
        }
        StringGroup group = typeStringPool.get(typeName);
        if (group != null) {
            return (TypeString)group.get(0);
        }
        int id = typeStringPool.getLastId() + 1;
        return typeStringPool.getOrCreate(id, typeName);
    }

    private TypeStringPool getTypeStringPool() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getTypeStringPool();
        }
        return null;
    }

    private PackageBlock getPackageBlock() {
        return this.getParentInstance(PackageBlock.class);
    }

    @Override
    public JSONArray toJson() {
        return this.toJson(false);
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json == null) {
            return;
        }
        int length = json.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            int id = jsonObject.getJSONObject("spec").getInt("id");
            SpecTypePair specTypePair = this.getOrCreate((byte)id);
            specTypePair.fromJson(jsonObject);
        }
    }

    public JSONArray toJson(boolean specsOnly) {
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (SpecTypePair specTypePair : this.listItems()) {
            JSONObject jsonObject = specTypePair.toJson(specsOnly);
            if (jsonObject == null) continue;
            jsonArray.put(i, jsonObject);
            ++i;
        }
        return jsonArray;
    }

    public void merge(SpecTypePairArray pairArray) {
        if (pairArray == null || pairArray == this) {
            return;
        }
        for (SpecTypePair typePair : pairArray.listItems()) {
            if (typePair.isEmpty()) continue;
            SpecTypePair exist = this.getOrCreate(typePair.getTypeId());
            exist.merge(typePair);
        }
    }

    @Deprecated
    public SpecTypePair searchByTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        SpecTypePair[] childes = (SpecTypePair[])this.getChildes();
        if (childes == null) {
            return null;
        }
        for (int i = 0; i < childes.length; ++i) {
            SpecTypePair specTypePair = childes[i];
            if (!typeName.equals(specTypePair.getTypeName())) continue;
            return specTypePair;
        }
        return null;
    }

    @Override
    public int compare(SpecTypePair typePair1, SpecTypePair typePair2) {
        return typePair1.compareTo(typePair2);
    }
}

