/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ResXmlAttributeArray
extends BlockArray<ResXmlAttribute>
implements Comparator<ResXmlAttribute>,
JSONConvert<JSONArray> {
    private final HeaderBlock mHeaderBlock;
    private final ShortItem mAttributeStart;
    private final ShortItem mAttributeCount;
    private final ShortItem mAttributesUnitSize;

    public ResXmlAttributeArray(HeaderBlock headerBlock, ShortItem attributeStart, ShortItem attributeCount, ShortItem attributesUnitSize) {
        this.mHeaderBlock = headerBlock;
        this.mAttributeStart = attributeStart;
        this.mAttributeCount = attributeCount;
        this.mAttributesUnitSize = attributesUnitSize;
    }

    public int removeUndefinedAttributes() {
        List<ResXmlAttribute> undefinedAttributes = this.listUndefined();
        super.remove(undefinedAttributes);
        return undefinedAttributes.size();
    }

    public List<ResXmlAttribute> listUndefined() {
        ArrayList<ResXmlAttribute> results = new ArrayList<ResXmlAttribute>();
        ResXmlAttribute[] attributes = (ResXmlAttribute[])this.getChildes();
        for (int i = 0; i < attributes.length; ++i) {
            ResXmlAttribute attribute = attributes[i];
            if (attribute == null || !attribute.isUndefined()) continue;
            results.add(attribute);
        }
        return results;
    }

    public void setAttributesUnitSize(int size) {
        ResXmlAttribute[] attributes = (ResXmlAttribute[])this.getChildes();
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].setAttributesUnitSize(size);
        }
        this.mAttributesUnitSize.set((short)size);
    }

    public void sortAttributes() {
        this.sort(this);
    }

    private void refreshCount() {
        short count = (short)this.childesCount();
        this.mAttributeCount.set(count);
    }

    private void refreshStart() {
        Block parent = this.getParent();
        if (parent == null) {
            return;
        }
        int start = parent.countUpTo(this);
        this.mAttributeStart.set((short)(start -= this.mHeaderBlock.countBytes()));
    }

    @Override
    public ResXmlAttribute newInstance() {
        return new ResXmlAttribute(this.mAttributesUnitSize.unsignedInt());
    }

    public ResXmlAttribute[] newInstance(int len) {
        return new ResXmlAttribute[len];
    }

    @Override
    protected void onRefreshed() {
        this.refreshCount();
        this.refreshStart();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int start = this.mHeaderBlock.getHeaderSize() + this.mAttributeStart.get();
        reader.seek(start);
        this.setChildesCount(this.mAttributeCount.get());
        int attributeSize = this.mAttributesUnitSize.unsignedInt();
        ResXmlAttribute[] childes = (ResXmlAttribute[])this.getChildes();
        for (int i = 0; i < childes.length; ++i) {
            int position = reader.getPosition();
            ResXmlAttribute attribute = childes[i];
            attribute.readBytes(reader);
            int remaining = attributeSize - (reader.getPosition() - position);
            reader.offset(remaining);
        }
    }

    @Override
    public void clearChildes() {
        ResXmlAttribute[] childes = (ResXmlAttribute[])this.getChildes();
        if (childes == null || childes.length == 0) {
            super.clearChildes();
            return;
        }
        for (ResXmlAttribute child : childes) {
            if (child == null) continue;
            child.onRemoved();
        }
        super.clearChildes();
    }

    @Override
    public int compare(ResXmlAttribute attr1, ResXmlAttribute attr2) {
        return attr1.compareTo(attr2);
    }

    @Override
    public JSONArray toJson() {
        this.sortAttributes();
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (ResXmlAttribute attr : this.listItems()) {
            JSONObject jsonObject = attr.toJson();
            jsonArray.put(i, jsonObject);
            ++i;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clearChildes();
        int length = json.length();
        this.ensureSize(length);
        for (int i = 0; i < length; ++i) {
            ResXmlAttribute attribute = (ResXmlAttribute)this.get(i);
            JSONObject jsonObject = json.getJSONObject(i);
            attribute.fromJson(jsonObject);
        }
    }
}

