/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class PackageArray
extends BlockArray<PackageBlock>
implements BlockLoad,
JSONConvert<JSONArray>,
Comparator<PackageBlock> {
    private final IntegerItem mPackageCount;

    public PackageArray(IntegerItem packageCount) {
        this.mPackageCount = packageCount;
        this.mPackageCount.setBlockLoad(this);
    }

    public void destroy() {
        Iterator itr = this.iterator(true);
        while (itr.hasNext()) {
            PackageBlock packageBlock = (PackageBlock)itr.next();
            packageBlock.destroy();
        }
        this.clearChildes();
    }

    public PackageBlock pickOne() {
        return this.pickOne((PackageBlock[])this.getChildes(), 0);
    }

    public PackageBlock pickOne(int packageId) {
        return this.pickOne((PackageBlock[])this.getChildes(), packageId);
    }

    private PackageBlock pickOne(PackageBlock[] items, int packageId) {
        if (items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            return items[0];
        }
        PackageBlock largest = null;
        for (PackageBlock packageBlock : items) {
            if (packageBlock == null || packageId != 0 && packageId != packageBlock.getId()) continue;
            if (largest == null) {
                largest = packageBlock;
                continue;
            }
            if (packageBlock.getEntriesGroupMap().size() <= largest.getEntriesGroupMap().size()) continue;
            largest = packageBlock;
        }
        return largest;
    }

    public void sort() {
        for (PackageBlock packageBlock : this.listItems()) {
            packageBlock.sortTypes();
        }
        this.sort(this);
    }

    public PackageBlock getOrCreate(byte pkgId) {
        return this.getOrCreate(0xFF & pkgId);
    }

    public PackageBlock getOrCreate(int pkgId) {
        PackageBlock packageBlock = this.getPackageBlockById(pkgId);
        if (packageBlock != null) {
            return packageBlock;
        }
        packageBlock = (PackageBlock)this.createNext();
        packageBlock.setId(pkgId);
        packageBlock.setName("PACKAGE NAME");
        return packageBlock;
    }

    public PackageBlock getPackageBlockById(byte pkgId) {
        return this.getPackageBlockById(0xFF & pkgId);
    }

    public PackageBlock getPackageBlockById(int pkgId) {
        Iterator itr = this.iterator(true);
        while (itr.hasNext()) {
            PackageBlock packageBlock = (PackageBlock)itr.next();
            if (packageBlock.getId() != pkgId) continue;
            return packageBlock;
        }
        return null;
    }

    @Override
    public PackageBlock newInstance() {
        return new PackageBlock();
    }

    public PackageBlock[] newInstance(int len) {
        return new PackageBlock[len];
    }

    @Override
    protected void onRefreshed() {
        this.refreshPackageCount();
    }

    private void refreshPackageCount() {
        this.mPackageCount.set(this.childesCount());
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender != this.mPackageCount) {
            return;
        }
        this.setChildesCount(this.mPackageCount.get());
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (PackageBlock packageBlock : this.listItems()) {
            JSONObject jsonObject = packageBlock.toJson();
            if (jsonObject == null) continue;
            jsonArray.put(i, jsonObject);
            ++i;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        int length = json.length();
        this.clearChildes();
        this.ensureSize(length);
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            PackageBlock packageBlock = (PackageBlock)this.get(i);
            packageBlock.fromJson(jsonObject);
        }
    }

    public void merge(PackageArray packageArray) {
        if (packageArray == null || packageArray == this) {
            return;
        }
        for (PackageBlock packageBlock : packageArray.listItems()) {
            PackageBlock exist = this.getOrCreate(packageBlock.getId());
            exist.merge(packageBlock);
        }
    }

    @Override
    public int compare(PackageBlock p1, PackageBlock p2) {
        return p1.compareTo(p2);
    }
}

