/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.IntegerItem;
import java.io.IOException;
import java.io.OutputStream;

public abstract class OffsetBlockArray<T extends Block>
extends BlockArray<T>
implements BlockLoad {
    private final OffsetArray mOffsets;
    private final IntegerItem mItemStart;
    private final IntegerItem mItemCount;
    private final ByteArray mEnd4Block;
    private byte mEnd4Type;

    public OffsetBlockArray(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart) {
        this.mOffsets = offsets;
        this.mItemCount = itemCount;
        this.mItemStart = itemStart;
        this.mEnd4Block = new ByteArray();
        this.mItemCount.setBlockLoad(this);
    }

    OffsetArray getOffsetArray() {
        return this.mOffsets;
    }

    void setEndBytes(byte b) {
        this.mEnd4Type = b;
        this.mEnd4Block.fill(b);
    }

    @Override
    public void clearChildes() {
        super.clearChildes();
        this.mOffsets.clear();
        this.mItemStart.set(0);
        this.mItemCount.set(0);
        this.mEnd4Block.clear();
    }

    @Override
    public int countBytes() {
        int result = super.countBytes();
        int endCount = this.mEnd4Block.countBytes();
        return result + endCount;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        super.onCountUpTo(counter);
        if (counter.FOUND) {
            return;
        }
        this.mEnd4Block.onCountUpTo(counter);
    }

    @Override
    public byte[] getBytes() {
        byte[] results = super.getBytes();
        if (results == null) {
            return null;
        }
        byte[] endBytes = this.mEnd4Block.getBytes();
        results = OffsetBlockArray.addBytes(results, endBytes);
        return results;
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        int result = super.onWriteBytes(stream);
        if (result == 0) {
            return 0;
        }
        return result += this.mEnd4Block.writeBytes(stream);
    }

    @Override
    protected void onRefreshed() {
        int count = this.childesCount();
        OffsetArray offsetArray = this.mOffsets;
        offsetArray.setSize(count);
        Block[] childes = this.getChildes();
        int sum = 0;
        if (childes != null) {
            int max = childes.length;
            for (int i = 0; i < max; ++i) {
                int offset;
                Block item = childes[i];
                if (item == null || item.isNull()) {
                    offset = -1;
                } else {
                    offset = sum;
                    sum += item.countBytes();
                }
                offsetArray.setOffset(i, offset);
            }
        }
        this.refreshCount();
        this.refreshStart();
        this.refreshEnd4Block();
    }

    public void refreshCountAndStart() {
        this.refreshCount();
        this.refreshStart();
    }

    void refreshCount() {
        this.mItemCount.set(this.childesCount());
    }

    private void refreshStart() {
        int count = this.childesCount();
        if (count == 0) {
            this.mItemStart.set(0);
            this.mEnd4Block.clear();
            return;
        }
        Block parent = this.getParent();
        if (parent == null) {
            return;
        }
        int start = parent.countUpTo(this);
        this.mItemStart.set(start);
    }

    void refreshEnd4Block(BlockReader reader, ByteArray end4Block) throws IOException {
        this.refreshEnd4Block();
    }

    void refreshEnd4Block(ByteArray end4Block) {
        if (this.childesCount() == 0) {
            end4Block.clear();
            return;
        }
        int count = this.countBytes();
        if (count % 4 == 0) {
            return;
        }
        end4Block.clear();
        count = this.countBytes();
        int add = 0;
        int rem = count % 4;
        while (rem != 0) {
            ++add;
            rem = ++count % 4;
        }
        end4Block.setSize(add);
        end4Block.fill(this.mEnd4Type);
    }

    private void refreshEnd4Block() {
        this.refreshEnd4Block(this.mEnd4Block);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int zeroPosition;
        Block[] childes = this.getChildes();
        if (childes == null || childes.length == 0) {
            return;
        }
        int[] offsetArray = this.mOffsets.getOffsets();
        int max = childes.length;
        int start = this.mItemStart.get();
        reader.seek(start);
        int maxPos = zeroPosition = reader.getPosition();
        for (int i = 0; i < max; ++i) {
            Block item = childes[i];
            int offset = offsetArray[i];
            if (offset == -1) {
                item.setNull(true);
                continue;
            }
            int itemStart = zeroPosition + offset;
            reader.seek(itemStart);
            item.readBytes(reader);
            int pos = reader.getPosition();
            if (pos <= maxPos) continue;
            maxPos = pos;
        }
        reader.seek(maxPos);
        this.refreshEnd4Block(reader, this.mEnd4Block);
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.mItemCount) {
            int count = this.mItemCount.get();
            this.setChildesCount(count);
            this.mOffsets.setSize(count);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": count = ");
        int s = this.childesCount();
        builder.append(s);
        int count = this.mItemCount.get();
        if (s != count) {
            builder.append(", countValue=");
            builder.append(count);
        }
        builder.append(", start=");
        builder.append(this.mItemStart.get());
        return builder.toString();
    }
}

