/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;

public abstract class CompoundItemArray<T extends ResValueMap>
extends BlockArray<T>
implements JSONConvert<JSONArray> {
    public AttributeDataFormat[] getFormats() {
        T formatsMap = this.getByType(AttributeType.FORMATS);
        if (formatsMap != null) {
            return AttributeDataFormat.decodeValueTypes(((ValueItem)formatsMap).getData());
        }
        return null;
    }

    public boolean containsType(AttributeType attributeType) {
        for (ResValueMap valueMap : (ResValueMap[])this.getChildes()) {
            if (attributeType != valueMap.getAttributeType()) continue;
            return true;
        }
        return false;
    }

    public T getByType(AttributeType attributeType) {
        if (attributeType == null) {
            return null;
        }
        for (ResValueMap valueMap : (ResValueMap[])this.getChildes()) {
            if (attributeType != valueMap.getAttributeType()) continue;
            return (T)valueMap;
        }
        return null;
    }

    public T getByName(int name) {
        for (ResValueMap resValueMap : (ResValueMap[])this.getChildes()) {
            if (resValueMap == null || name != resValueMap.getName()) continue;
            return (T)resValueMap;
        }
        return null;
    }

    @Override
    protected void onRefreshed() {
    }

    public void onRemoved() {
        for (ResValueMap resValueMap : (ResValueMap[])this.getChildes()) {
            resValueMap.onRemoved();
        }
    }

    @Override
    public void clearChildes() {
        this.onRemoved();
        super.clearChildes();
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        if (this.isNull()) {
            return jsonArray;
        }
        ResValueMap[] childes = (ResValueMap[])this.getChildes();
        for (int i = 0; i < childes.length; ++i) {
            jsonArray.put(i, childes[i].toJson());
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clearChildes();
        if (json == null) {
            return;
        }
        int count = json.length();
        this.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            ((ResValueMap)this.get(i)).fromJson(json.getJSONObject(i));
        }
    }

    public void merge(CompoundItemArray<?> mapArray) {
        if (mapArray == null || mapArray == this) {
            return;
        }
        this.clearChildes();
        int count = mapArray.childesCount();
        this.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            ResValueMap coming = (ResValueMap)mapArray.get(i);
            ResValueMap exist = (ResValueMap)this.get(i);
            exist.merge(coming);
        }
    }
}

