/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.writer;

import com.reandroid.archive.InputSource;
import com.reandroid.archive2.block.DataDescriptor;
import com.reandroid.archive2.block.LocalFileHeader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZipAligner {
    private final Map<Pattern, Integer> alignmentMap = new HashMap<Pattern, Integer>();
    private int defaultAlignment;
    private boolean enableDataDescriptor;
    private long mCurrentOffset;
    private static final int ALIGNMENT_4 = 4;
    private static final int ALIGNMENT_PAGE = 4096;

    public void setFileAlignment(Pattern patternFileName, int alignment) {
        if (patternFileName == null) {
            return;
        }
        this.alignmentMap.remove(patternFileName);
        if (alignment > 1) {
            this.alignmentMap.put(patternFileName, alignment);
        }
    }

    public void clearFileAlignment() {
        this.alignmentMap.clear();
    }

    public void setDefaultAlignment(int defaultAlignment) {
        if (defaultAlignment <= 0) {
            defaultAlignment = 1;
        }
        this.defaultAlignment = defaultAlignment;
    }

    public void setEnableDataDescriptor(boolean enableDataDescriptor) {
        this.enableDataDescriptor = enableDataDescriptor;
    }

    void reset() {
        this.mCurrentOffset = 0L;
    }

    void align(InputSource inputSource, LocalFileHeader lfh) {
        int padding;
        lfh.setExtra(null);
        if (inputSource.getMethod() != 0) {
            padding = 0;
            this.createDataDescriptor(lfh);
        } else {
            int alignment = this.getAlignment(inputSource.getAlias());
            long dataOffset = this.mCurrentOffset + (long)lfh.countBytes();
            padding = (int)(((long)alignment - dataOffset % (long)alignment) % (long)alignment);
        }
        lfh.setExtra(new byte[padding]);
        this.mCurrentOffset += lfh.getDataSize() + (long)lfh.countBytes();
        DataDescriptor dataDescriptor = lfh.getDataDescriptor();
        if (dataDescriptor != null) {
            this.mCurrentOffset += (long)dataDescriptor.countBytes();
        }
    }

    private void createDataDescriptor(LocalFileHeader lfh) {
        DataDescriptor dataDescriptor = this.enableDataDescriptor ? DataDescriptor.fromLocalFile(lfh) : null;
        lfh.setDataDescriptor(dataDescriptor);
    }

    private int getAlignment(String name) {
        for (Map.Entry<Pattern, Integer> entry : this.alignmentMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(name);
            if (!matcher.matches()) continue;
            return entry.getValue();
        }
        return this.defaultAlignment;
    }

    public static ZipAligner apkAligner() {
        ZipAligner zipAligner = new ZipAligner();
        zipAligner.setDefaultAlignment(4);
        Pattern patternNativeLib = Pattern.compile("^lib/.+\\.so$");
        zipAligner.setFileAlignment(patternNativeLib, 4096);
        zipAligner.setEnableDataDescriptor(true);
        return zipAligner;
    }
}

