/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.writer;

import com.reandroid.archive.InputSource;
import com.reandroid.archive2.ZipSignature;
import com.reandroid.archive2.block.CentralEntryHeader;
import com.reandroid.archive2.block.DataDescriptor;
import com.reandroid.archive2.block.LocalFileHeader;
import com.reandroid.archive2.io.CountingOutputStream;
import com.reandroid.archive2.io.FileChannelOutputStream;
import com.reandroid.archive2.writer.ApkWriter;
import com.reandroid.archive2.writer.BufferFileInput;
import com.reandroid.archive2.writer.BufferFileOutput;
import com.reandroid.archive2.writer.EntryBuffer;
import com.reandroid.archive2.writer.ZipAligner;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class OutputSource {
    private final InputSource inputSource;
    private LocalFileHeader lfh;
    private EntryBuffer entryBuffer;

    OutputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    void align(ZipAligner aligner) {
        LocalFileHeader lfh = this.getLocalFileHeader();
        if (aligner == null) {
            lfh.setExtra(null);
        } else {
            aligner.align(this.getInputSource(), lfh);
        }
    }

    void makeBuffer(BufferFileInput input, BufferFileOutput output) throws IOException {
        EntryBuffer entryBuffer = this.entryBuffer;
        if (entryBuffer != null) {
            return;
        }
        entryBuffer = this.makeFromEntry();
        if (entryBuffer != null) {
            this.entryBuffer = entryBuffer;
            return;
        }
        this.entryBuffer = this.writeBuffer(input, output);
    }

    private EntryBuffer writeBuffer(BufferFileInput input, BufferFileOutput output) throws IOException {
        long offset = output.position();
        this.writeBufferFile(output);
        long length = output.position() - offset;
        return new EntryBuffer(input, offset, length);
    }

    EntryBuffer makeFromEntry() {
        return null;
    }

    void writeApk(ApkWriter apkWriter) throws IOException {
        EntryBuffer entryBuffer = this.entryBuffer;
        FileChannel input = entryBuffer.getZipFileInput().getFileChannel();
        input.position(entryBuffer.getOffset());
        LocalFileHeader lfh = this.getLocalFileHeader();
        this.writeLFH(lfh, apkWriter);
        this.writeData(input, entryBuffer.getLength(), apkWriter);
        this.writeDD(lfh.getDataDescriptor(), apkWriter);
    }

    void writeCEH(ApkWriter apkWriter) throws IOException {
        LocalFileHeader lfh = this.getLocalFileHeader();
        CentralEntryHeader ceh = CentralEntryHeader.fromLocalFileHeader(lfh);
        ceh.writeBytes(apkWriter.getOutputStream());
    }

    private void writeLFH(LocalFileHeader lfh, ApkWriter apkWriter) throws IOException {
        lfh.writeBytes(apkWriter.getOutputStream());
    }

    private void writeData(FileChannel input, long length, ApkWriter apkWriter) throws IOException {
        long offset = apkWriter.position();
        LocalFileHeader lfh = this.getLocalFileHeader();
        lfh.setFileOffset(offset);
        apkWriter.write(input, length);
    }

    void writeDD(DataDescriptor dataDescriptor, ApkWriter apkWriter) throws IOException {
        if (dataDescriptor == null) {
            return;
        }
        dataDescriptor.writeBytes(apkWriter.getOutputStream());
    }

    private void writeBufferFile(BufferFileOutput output) throws IOException {
        LocalFileHeader lfh = this.getLocalFileHeader();
        InputSource inputSource = this.getInputSource();
        FileChannelOutputStream rawStream = output.getOutputStream();
        CountingOutputStream<FileChannelOutputStream> rawCounter = new CountingOutputStream<FileChannelOutputStream>(rawStream);
        CountingOutputStream<DeflaterOutputStream> deflateCounter = null;
        if (inputSource.getMethod() != 0) {
            DeflaterOutputStream deflaterInputStream = new DeflaterOutputStream(rawCounter, new Deflater(1, true), true);
            deflateCounter = new CountingOutputStream<DeflaterOutputStream>(deflaterInputStream, false);
        }
        if (deflateCounter != null) {
            rawCounter.disableCrc(true);
            inputSource.write(deflateCounter);
            deflateCounter.close();
            rawCounter.close();
        } else {
            inputSource.write(rawCounter);
        }
        lfh.setCompressedSize(rawCounter.getSize());
        if (deflateCounter != null) {
            lfh.setMethod(8);
            lfh.setCrc(deflateCounter.getCrc());
            lfh.setSize(deflateCounter.getSize());
        } else {
            lfh.setSize(rawCounter.getSize());
            lfh.setMethod(0);
            lfh.setCrc(rawCounter.getCrc());
        }
        inputSource.disposeInputSource();
    }

    InputSource getInputSource() {
        return this.inputSource;
    }

    LocalFileHeader getLocalFileHeader() {
        if (this.lfh == null) {
            this.lfh = this.createLocalFileHeader();
            this.lfh.setFileName(this.getInputSource().getAlias());
            this.clearAlignment(this.lfh);
        }
        return this.lfh;
    }

    LocalFileHeader createLocalFileHeader() {
        InputSource inputSource = this.getInputSource();
        LocalFileHeader lfh = new LocalFileHeader();
        lfh.setSignature(ZipSignature.LOCAL_FILE);
        lfh.getGeneralPurposeFlag().initDefault();
        lfh.setFileName(inputSource.getAlias());
        lfh.setMethod(inputSource.getMethod());
        return lfh;
    }

    private void clearAlignment(LocalFileHeader lfh) {
        lfh.getGeneralPurposeFlag().setHasDataDescriptor(false);
        lfh.setDataDescriptor(null);
        lfh.setExtra(null);
    }
}

