/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.writer;

import com.reandroid.archive.InputSource;
import com.reandroid.archive2.block.LocalFileHeader;
import com.reandroid.archive2.io.ArchiveEntrySource;
import com.reandroid.archive2.io.ZipFileInput;
import com.reandroid.archive2.io.ZipInput;
import com.reandroid.archive2.writer.EntryBuffer;
import com.reandroid.archive2.writer.OutputSource;

public class ArchiveOutputSource
extends OutputSource {
    public ArchiveOutputSource(InputSource inputSource) {
        super(inputSource);
    }

    ArchiveEntrySource getArchiveSource() {
        return (ArchiveEntrySource)super.getInputSource();
    }

    @Override
    EntryBuffer makeFromEntry() {
        ArchiveEntrySource entrySource = this.getArchiveSource();
        ZipInput zip = entrySource.getZipSource();
        if (!(zip instanceof ZipFileInput)) {
            return null;
        }
        LocalFileHeader lfh = entrySource.getArchiveEntry().getLocalFileHeader();
        if (lfh.getMethod() != this.getInputSource().getMethod()) {
            return null;
        }
        return new EntryBuffer((ZipFileInput)zip, lfh.getFileOffset(), lfh.getDataSize());
    }

    @Override
    public LocalFileHeader createLocalFileHeader() {
        ArchiveEntrySource source = this.getArchiveSource();
        return source.getArchiveEntry().getLocalFileHeader();
    }
}

