/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.writer;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.RenamedInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.WriteProgress;
import com.reandroid.archive2.ZipSignature;
import com.reandroid.archive2.block.ApkSignatureBlock;
import com.reandroid.archive2.block.EndRecord;
import com.reandroid.archive2.io.ArchiveEntrySource;
import com.reandroid.archive2.io.FileChannelOutputStream;
import com.reandroid.archive2.io.ZipFileOutput;
import com.reandroid.archive2.writer.ArchiveOutputSource;
import com.reandroid.archive2.writer.BufferFileInput;
import com.reandroid.archive2.writer.BufferFileOutput;
import com.reandroid.archive2.writer.OutputSource;
import com.reandroid.archive2.writer.RenamedArchiveSource;
import com.reandroid.archive2.writer.ZipAligner;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApkWriter
extends ZipFileOutput {
    private final Object mLock = new Object();
    private final Collection<? extends InputSource> sourceList;
    private ZipAligner zipAligner;
    private ApkSignatureBlock apkSignatureBlock;
    private APKLogger apkLogger;
    private WriteProgress writeProgress;

    public ApkWriter(File file, Collection<? extends InputSource> sourceList) throws IOException {
        super(file);
        this.sourceList = sourceList;
        this.zipAligner = ZipAligner.apkAligner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            List<OutputSource> outputList = this.buildOutputEntry();
            this.logMessage("Buffering compress changed files ...");
            BufferFileInput buffer = this.writeBuffer(outputList);
            buffer.unlock();
            this.align(outputList);
            this.writeApk(outputList);
            buffer.close();
            this.writeSignatureBlock();
            this.writeCEH(outputList);
            this.close();
            this.logMessage("Written to: " + this.getFile().getName());
        }
    }

    public void setApkSignatureBlock(ApkSignatureBlock apkSignatureBlock) {
        this.apkSignatureBlock = apkSignatureBlock;
    }

    public ZipAligner getZipAligner() {
        return this.zipAligner;
    }

    public void setZipAligner(ZipAligner zipAligner) {
        this.zipAligner = zipAligner;
    }

    private void writeCEH(List<OutputSource> outputList) throws IOException {
        this.logMessage("Writing CEH ...");
        EndRecord endRecord = new EndRecord();
        endRecord.setSignature(ZipSignature.END_RECORD);
        long offset = this.position();
        endRecord.setOffsetOfCentralDirectory((int)offset);
        endRecord.setNumberOfDirectories(outputList.size());
        endRecord.setTotalNumberOfDirectories(outputList.size());
        for (OutputSource outputSource : outputList) {
            outputSource.writeCEH(this);
        }
        long len = this.position() - offset;
        endRecord.setLengthOfCentralDirectory(len);
        endRecord.writeBytes(this.getOutputStream());
    }

    private void writeApk(List<OutputSource> outputList) throws IOException {
        this.logMessage("Writing files: " + outputList.size());
        for (OutputSource outputSource : outputList) {
            outputSource.writeApk(this);
        }
    }

    private void writeSignatureBlock() throws IOException {
        ApkSignatureBlock signatureBlock = this.apkSignatureBlock;
        if (signatureBlock == null) {
            return;
        }
        this.logMessage("Writing signature block ...");
        long offset = this.position();
        int alignment = 4096;
        int filesPadding = (int)(((long)alignment - offset % (long)alignment) % (long)alignment);
        FileChannelOutputStream outputStream = this.getOutputStream();
        if (filesPadding > 0) {
            ((OutputStream)outputStream).write(new byte[filesPadding]);
        }
        this.logMessage("files padding = " + filesPadding);
        signatureBlock.updatePadding();
        signatureBlock.writeBytes(outputStream);
    }

    private BufferFileInput writeBuffer(List<OutputSource> outputList) throws IOException {
        File bufferFile = this.getBufferFile();
        BufferFileOutput output = new BufferFileOutput(bufferFile);
        BufferFileInput input = new BufferFileInput(bufferFile);
        OutputSource tableSource = null;
        for (OutputSource outputSource : outputList) {
            InputSource inputSource = outputSource.getInputSource();
            if (tableSource == null && "resources.arsc".equals(inputSource.getAlias())) {
                tableSource = outputSource;
                continue;
            }
            this.onCompressFileProgress(inputSource.getAlias(), inputSource.getMethod(), output.position());
            outputSource.makeBuffer(input, output);
        }
        if (tableSource != null) {
            tableSource.makeBuffer(input, output);
        }
        output.close();
        return input;
    }

    private void align(List<OutputSource> outputList) {
        ZipAligner aligner = this.getZipAligner();
        if (aligner != null) {
            aligner.reset();
            this.logMessage("Zip align ...");
        }
        for (OutputSource outputSource : outputList) {
            outputSource.align(aligner);
        }
    }

    private File getBufferFile() {
        File file = this.getFile();
        File dir = file.getParentFile();
        String name = file.getAbsolutePath();
        name = "tmp" + name.hashCode();
        File bufFile = dir != null ? new File(dir, name) : new File(name);
        bufFile.deleteOnExit();
        return bufFile;
    }

    private List<OutputSource> buildOutputEntry() {
        Collection<? extends InputSource> sourceList = this.sourceList;
        ArrayList<OutputSource> results = new ArrayList<OutputSource>(sourceList.size());
        for (InputSource inputSource : sourceList) {
            results.add(this.toOutputSource(inputSource));
        }
        return results;
    }

    private OutputSource toOutputSource(InputSource inputSource) {
        Object renamed;
        if (inputSource instanceof ArchiveEntrySource) {
            return new ArchiveOutputSource(inputSource);
        }
        if (inputSource instanceof RenamedInputSource && (renamed = ((RenamedInputSource)inputSource).getInputSource()) instanceof ArchiveEntrySource) {
            return new RenamedArchiveSource((RenamedInputSource)inputSource);
        }
        return new OutputSource(inputSource);
    }

    public void setWriteProgress(WriteProgress writeProgress) {
        this.writeProgress = writeProgress;
    }

    private void onCompressFileProgress(String path, int mode, long writtenBytes) {
        if (this.writeProgress != null) {
            this.writeProgress.onCompressFile(path, mode, writtenBytes);
        }
    }

    APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    private void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }
}

