/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.model;

import com.reandroid.archive2.block.ApkSignatureBlock;
import com.reandroid.archive2.block.CentralEntryHeader;
import com.reandroid.archive2.block.DataDescriptor;
import com.reandroid.archive2.block.EndRecord;
import com.reandroid.archive2.block.LocalFileHeader;
import com.reandroid.archive2.block.SignatureFooter;
import com.reandroid.archive2.io.ZipInput;
import com.reandroid.archive2.model.CentralFileDirectory;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class LocalFileDirectory {
    private final CentralFileDirectory centralFileDirectory;
    private final List<LocalFileHeader> headerList;
    private ApkSignatureBlock apkSignatureBlock;

    public LocalFileDirectory(CentralFileDirectory centralFileDirectory) {
        this.centralFileDirectory = centralFileDirectory;
        this.headerList = new ArrayList<LocalFileHeader>();
    }

    public LocalFileDirectory() {
        this(new CentralFileDirectory());
    }

    public void visit(ZipInput zipInput) throws IOException {
        this.getCentralFileDirectory().visit(zipInput);
        this.visitLocalFile(zipInput);
        this.visitApkSigBlock(zipInput);
    }

    private void visitLocalFile(ZipInput zipInput) throws IOException {
        List<LocalFileHeader> headerList = this.getHeaderList();
        int index = 0;
        CentralFileDirectory centralFileDirectory = this.getCentralFileDirectory();
        long length = zipInput.getLength();
        InputStream inputStream = zipInput.getInputStream(0L, length);
        for (CentralEntryHeader ceh : centralFileDirectory.getHeaderList()) {
            int read;
            long offset = ceh.getLocalRelativeOffset();
            inputStream.reset();
            offset = inputStream.skip(offset);
            LocalFileHeader lfh = LocalFileHeader.read(inputStream);
            if (lfh == null) {
                throw new IOException("Error reading LFH at " + offset + ", for CEH = " + ceh.getFileName());
            }
            lfh.setFileOffset(offset += (long)lfh.countBytes());
            ceh.setFileOffset(offset);
            lfh.mergeZeroValues(ceh);
            inputStream.skip(lfh.getDataSize());
            DataDescriptor dataDescriptor = null;
            if (lfh.hasDataDescriptor() && (read = (dataDescriptor = new DataDescriptor()).readBytes(inputStream)) != dataDescriptor.countBytes()) {
                dataDescriptor = null;
            }
            lfh.setDataDescriptor(dataDescriptor);
            lfh.setIndex(index);
            headerList.add(lfh);
            ++index;
        }
    }

    private void visitApkSigBlock(ZipInput zipInput) throws IOException {
        CentralFileDirectory cfd = this.getCentralFileDirectory();
        SignatureFooter footer = cfd.getSignatureFooter();
        if (footer == null || !footer.isValid()) {
            return;
        }
        EndRecord endRecord = cfd.getEndRecord();
        long length = footer.getSignatureSize() + 8L;
        long offset = endRecord.getOffsetOfCentralDirectory() - length;
        ApkSignatureBlock apkSignatureBlock = new ApkSignatureBlock(footer);
        apkSignatureBlock.readBytes(new BlockReader(zipInput.getInputStream(offset, length)));
        this.apkSignatureBlock = apkSignatureBlock;
    }

    public ApkSignatureBlock getApkSigBlock() {
        return this.apkSignatureBlock;
    }

    public CentralFileDirectory getCentralFileDirectory() {
        return this.centralFileDirectory;
    }

    public List<LocalFileHeader> getHeaderList() {
        return this.headerList;
    }
}

