/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.model;

import com.reandroid.archive2.block.CentralEntryHeader;
import com.reandroid.archive2.block.EndRecord;
import com.reandroid.archive2.block.LocalFileHeader;
import com.reandroid.archive2.block.SignatureFooter;
import com.reandroid.archive2.io.ZipInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CentralFileDirectory {
    private final List<CentralEntryHeader> headerList = new ArrayList<CentralEntryHeader>();
    private EndRecord endRecord;
    private SignatureFooter signatureFooter;

    public CentralEntryHeader get(LocalFileHeader lfh) {
        String name = lfh.getFileName();
        CentralEntryHeader ceh = this.get(lfh.getIndex());
        if (ceh != null && Objects.equals(ceh.getFileName(), name)) {
            return ceh;
        }
        return this.get(name);
    }

    public CentralEntryHeader get(String name) {
        if (name == null) {
            name = "";
        }
        for (CentralEntryHeader ceh : this.getHeaderList()) {
            if (!name.equals(ceh.getFileName())) continue;
            return ceh;
        }
        return null;
    }

    public CentralEntryHeader get(int i) {
        if (i < 0 || i >= this.headerList.size()) {
            return null;
        }
        return this.headerList.get(i);
    }

    public int count() {
        return this.headerList.size();
    }

    public List<CentralEntryHeader> getHeaderList() {
        return this.headerList;
    }

    public SignatureFooter getSignatureFooter() {
        return this.signatureFooter;
    }

    public EndRecord getEndRecord() {
        return this.endRecord;
    }

    public void visit(ZipInput zipInput) throws IOException {
        int endLength;
        EndRecord endRecord;
        int length;
        byte[] footer = zipInput.getFooter(65581);
        if (footer.length < (length = (int)(endRecord = this.findEndRecord(footer)).getLengthOfCentralDirectory()) + (endLength = endRecord.countBytes())) {
            footer = zipInput.getFooter(24 + length + endLength);
        }
        int offset = footer.length - length - endLength;
        this.endRecord = endRecord;
        this.loadCentralFileHeaders(footer, offset, length);
        this.signatureFooter = this.tryFindSignatureFooter(footer, endRecord);
    }

    private void loadCentralFileHeaders(byte[] footer, int offset, int length) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(footer, offset, length);
        this.loadCentralFileHeaders(inputStream);
    }

    private void loadCentralFileHeaders(InputStream inputStream) throws IOException {
        List<CentralEntryHeader> headerList = this.headerList;
        CentralEntryHeader ceh = new CentralEntryHeader();
        ceh.readBytes(inputStream);
        while (ceh.isValidSignature()) {
            headerList.add(ceh);
            ceh = new CentralEntryHeader();
            ceh.readBytes(inputStream);
        }
        inputStream.close();
    }

    private EndRecord findEndRecord(byte[] footer) throws IOException {
        int start;
        int length = footer.length;
        int minLength = 22;
        for (int offset = start = length - minLength; offset >= 0; --offset) {
            EndRecord endRecord = new EndRecord();
            endRecord.putBytes(footer, offset, 0, minLength);
            if (!endRecord.isValidSignature()) continue;
            return endRecord;
        }
        throw new IOException("Failed to find end record");
    }

    private SignatureFooter tryFindSignatureFooter(byte[] footer, EndRecord endRecord) throws IOException {
        int length;
        int lenCd = (int)endRecord.getLengthOfCentralDirectory();
        int endLength = endRecord.countBytes();
        int offset = footer.length - endLength - lenCd - (length = 24);
        if (offset < 0) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(footer, offset, length);
        SignatureFooter signatureFooter = new SignatureFooter();
        signatureFooter.readBytes(inputStream);
        if (signatureFooter.isValid()) {
            return signatureFooter;
        }
        return null;
    }
}

