/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.io;

import com.reandroid.archive2.io.FileChannelOutputStream;
import com.reandroid.archive2.io.ReadOnlyStream;
import com.reandroid.archive2.io.ZipOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public class ZipFileOutput
extends ZipOutput {
    private final File file;
    private FileChannel fileChannel;
    private FileChannelOutputStream outputStream;

    public ZipFileOutput(File file) throws IOException {
        ZipFileOutput.initFile(file);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void write(FileChannel input, long length) throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        long pos = fileChannel.position();
        length = fileChannel.transferFrom(input, pos, length);
        fileChannel.position(pos + length);
    }

    @Override
    public long position() throws IOException {
        return this.getFileChannel().position();
    }

    @Override
    public void position(long pos) throws IOException {
        this.getFileChannel().position(pos);
    }

    @Override
    public void close() throws IOException {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            fileChannel.close();
        }
    }

    @Override
    public boolean isOpen() {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            return fileChannel.isOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel getFileChannel() throws IOException {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            return fileChannel;
        }
        ZipFileOutput zipFileOutput = this;
        synchronized (zipFileOutput) {
            this.fileChannel = fileChannel = FileChannel.open(this.file.toPath(), StandardOpenOption.WRITE);
            return fileChannel;
        }
    }

    @Override
    public void write(ReadOnlyStream readStream, long length) throws IOException {
        FileChannel input = readStream.getFileChannel();
        if (input != null) {
            this.write(input, length);
            return;
        }
        this.write(readStream.getInputStream(readStream.position(), length));
    }

    @Override
    public void write(InputStream inputStream) throws IOException {
        int read;
        FileChannel fileChannel = this.getFileChannel();
        long pos = fileChannel.position();
        int bufferLength = 102400000;
        byte[] buffer = new byte[bufferLength];
        long result = 0L;
        while ((read = inputStream.read(buffer, 0, bufferLength)) > 0) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, read);
            fileChannel.write(byteBuffer);
            result += (long)read;
        }
        inputStream.close();
        fileChannel.position(pos + result);
    }

    @Override
    public FileChannelOutputStream getOutputStream() throws IOException {
        FileChannelOutputStream outputStream = this.outputStream;
        if (outputStream == null) {
            this.outputStream = outputStream = new FileChannelOutputStream(this.getFileChannel());
        }
        return outputStream;
    }

    private static void initFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("Not file: " + file);
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
    }
}

