/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.io;

import java.io.IOException;
import java.io.InputStream;

public class SlicedInputStream
extends InputStream {
    private final InputStream inputStream;
    private final long mOffset;
    private final long mLength;
    private long mCount;
    private boolean mFinished;
    private boolean mStarted;

    public SlicedInputStream(InputStream inputStream, long offset, long length) {
        this.inputStream = inputStream;
        this.mOffset = offset;
        this.mLength = length;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.mFinished) {
            return -1;
        }
        this.checkStarted();
        long remain = this.mLength - this.mCount;
        if (remain <= 0L) {
            this.onFinished();
            return -1;
        }
        boolean finishNext = false;
        if ((long)len > remain) {
            len = (int)remain;
            finishNext = true;
        }
        int read = this.inputStream.read(bytes, off, len);
        this.mCount += (long)read;
        if (finishNext) {
            this.onFinished();
        }
        return read;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read() throws IOException {
        if (this.mFinished) {
            return -1;
        }
        this.checkStarted();
        long remain = this.mLength - this.mCount;
        if (remain <= 0L) {
            this.onFinished();
            return -1;
        }
        int result = this.inputStream.read();
        ++this.mCount;
        if (remain == 1L) {
            this.onFinished();
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkStarted();
        long amount = this.inputStream.skip(n);
        if (amount > 0L) {
            this.mCount += amount;
        }
        return amount;
    }

    @Override
    public void close() throws IOException {
        this.onFinished();
    }

    private void onFinished() throws IOException {
        this.mFinished = true;
        this.inputStream.close();
    }

    private void checkStarted() throws IOException {
        if (this.mStarted) {
            return;
        }
        this.mStarted = true;
        this.inputStream.skip(this.mOffset);
        this.mCount = 0L;
    }

    public String toString() {
        return "[" + this.mOffset + "," + this.mLength + "] " + this.mCount;
    }
}

