/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelOutputStream
extends OutputStream {
    private final FileChannel fileChannel;

    public FileChannelOutputStream(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        long position = this.fileChannel.position();
        length = this.fileChannel.write(ByteBuffer.wrap(bytes, offset, length));
        this.fileChannel.position(position + (long)length);
    }

    @Override
    public void write(int i) throws IOException {
        byte b = (byte)(i & 0xFF);
        this.write(new byte[]{b});
    }

    @Override
    public void close() {
    }
}

