/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.io;

import com.reandroid.archive.InputSource;
import com.reandroid.archive2.ArchiveEntry;
import com.reandroid.archive2.block.LocalFileHeader;
import com.reandroid.archive2.io.ZipInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ArchiveEntrySource
extends InputSource {
    private final ZipInput zipInput;
    private final ArchiveEntry archiveEntry;

    public ArchiveEntrySource(ZipInput zipInput, ArchiveEntry archiveEntry) {
        super(archiveEntry.getName());
        this.zipInput = zipInput;
        this.archiveEntry = archiveEntry;
        this.setMethod(archiveEntry.getMethod());
    }

    @Override
    public byte[] getBytes(int length) throws IOException {
        if (this.getMethod() != 0) {
            return super.getBytes(length);
        }
        FileChannel fileChannel = this.getFileChannel();
        byte[] bytes = new byte[length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        fileChannel.read(byteBuffer);
        return bytes;
    }

    public FileChannel getFileChannel() throws IOException {
        FileChannel fileChannel = this.getZipSource().getFileChannel();
        fileChannel.position(this.getFileOffset());
        return fileChannel;
    }

    public ZipInput getZipSource() {
        return this.zipInput;
    }

    public ArchiveEntry getArchiveEntry() {
        return this.archiveEntry;
    }

    public long getFileOffset() {
        return this.getArchiveEntry().getFileOffset();
    }

    @Override
    public void write(File file) throws IOException {
        if (this.getMethod() != 0) {
            super.write(file);
            return;
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        if (file.isFile()) {
            file.delete();
        }
        file.createNewFile();
        StandardOpenOption openOption = StandardOpenOption.WRITE;
        FileChannel outputChannel = FileChannel.open(file.toPath(), openOption);
        FileChannel fileChannel = this.getFileChannel();
        outputChannel.transferFrom(fileChannel, 0L, this.getLength());
        outputChannel.close();
    }

    @Override
    public long getLength() throws IOException {
        return this.getArchiveEntry().getDataSize();
    }

    @Override
    public long getCrc() throws IOException {
        return this.getArchiveEntry().getCrc();
    }

    @Override
    public InputStream openStream() throws IOException {
        ArchiveEntry archiveEntry = this.getArchiveEntry();
        LocalFileHeader lfh = archiveEntry.getLocalFileHeader();
        InputStream inputStream = this.getZipSource().getInputStream(archiveEntry.getFileOffset(), archiveEntry.getDataSize());
        if (lfh.getSize() == lfh.getCompressedSize()) {
            return inputStream;
        }
        return new InflaterInputStream(inputStream, new Inflater(true), 512);
    }
}

