/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block.pad;

import com.reandroid.archive2.block.SignatureId;
import com.reandroid.archive2.block.SignatureInfo;
import com.reandroid.archive2.block.SignatureScheme;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import java.io.IOException;

public class SchemePadding
extends SignatureScheme {
    private final ByteArray byteArray = new ByteArray();

    public SchemePadding() {
        super(1, SignatureId.PADDING);
        this.addChild(this.byteArray);
    }

    public int getPadding() {
        return this.byteArray.size();
    }

    public void setPadding(int padding) {
        this.byteArray.setSize(padding);
    }

    public byte[] getPaddingBytes() {
        return this.byteArray.getBytes();
    }

    public void setPadding(byte[] bytes) {
        this.byteArray.set(bytes);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        SignatureInfo signatureInfo = this.getSignatureInfo();
        int size = (int)signatureInfo.getDataSize() - 4;
        this.byteArray.setSize(size);
        super.onReadBytes(reader);
    }

    @Override
    public String toString() {
        return "padding = " + this.getPadding();
    }
}

