/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class ZipStringEncoding {
    private static final char REPLACEMENT = '?';
    private static final byte[] REPLACEMENT_BYTES = new byte[]{63};
    private static final String REPLACEMENT_STRING = String.valueOf('?');
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;
    private final boolean useReplacement;
    private final CharsetEncoder mEncoder;
    private final CharsetDecoder mDecoder;
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private static final ZipStringEncoding UTF8_ENCODING = ZipStringEncoding.getZipEncoding(UTF8);
    private static final ZipStringEncoding DEFAULT_ENCODING = ZipStringEncoding.getZipEncoding(Charset.defaultCharset().name());

    private static ByteBuffer encodeFully(CharsetEncoder enc, CharBuffer cb, ByteBuffer out) {
        ByteBuffer o = out;
        while (cb.hasRemaining()) {
            CoderResult result = enc.encode(cb, o, false);
            if (!result.isOverflow()) continue;
            int increment = ZipStringEncoding.estimateIncrementalEncodingSize(enc, cb.remaining());
            o = ZipStringEncoding.growBufferBy(o, increment);
        }
        return o;
    }

    private static CharBuffer encodeSurrogate(CharBuffer cb, char c) {
        cb.position(0).limit(6);
        cb.put('%');
        cb.put('U');
        cb.put(HEX_CHARS[c >> 12 & 0xF]);
        cb.put(HEX_CHARS[c >> 8 & 0xF]);
        cb.put(HEX_CHARS[c >> 4 & 0xF]);
        cb.put(HEX_CHARS[c & 0xF]);
        cb.flip();
        return cb;
    }

    private static int estimateIncrementalEncodingSize(CharsetEncoder enc, int charCount) {
        return (int)Math.ceil((float)charCount * enc.averageBytesPerChar());
    }

    private static int estimateInitialBufferSize(CharsetEncoder enc, int charChount) {
        float first = enc.maxBytesPerChar();
        float rest = (float)(charChount - 1) * enc.averageBytesPerChar();
        return (int)Math.ceil(first + rest);
    }

    ZipStringEncoding(Charset charset, boolean useReplacement) {
        this.charset = charset;
        this.useReplacement = useReplacement;
        this.mEncoder = this.newEncoder();
        this.mDecoder = this.newDecoder();
    }

    public boolean canEncode(String name) {
        CharsetEncoder enc = this.newEncoder();
        return enc.canEncode(name);
    }

    public String decode(byte[] data, int offset, int length) throws IOException {
        return this.mDecoder.decode(ByteBuffer.wrap(data, offset, length)).toString();
    }

    public byte[] encode(String text) {
        CharsetEncoder enc = this.mEncoder;
        CharBuffer cb = CharBuffer.wrap(text);
        CharBuffer tmp = null;
        ByteBuffer out = ByteBuffer.allocate(ZipStringEncoding.estimateInitialBufferSize(enc, cb.remaining()));
        while (cb.hasRemaining()) {
            CoderResult res = enc.encode(cb, out, false);
            if (res.isUnmappable() || res.isMalformed()) {
                int spaceForSurrogate = ZipStringEncoding.estimateIncrementalEncodingSize(enc, 6 * res.length());
                if (spaceForSurrogate > out.remaining()) {
                    int charCount = 0;
                    for (int i = cb.position(); i < cb.limit(); ++i) {
                        charCount += !enc.canEncode(cb.get(i)) ? 6 : 1;
                    }
                    int totalExtraSpace = ZipStringEncoding.estimateIncrementalEncodingSize(enc, charCount);
                    out = ZipStringEncoding.growBufferBy(out, totalExtraSpace - out.remaining());
                }
                if (tmp == null) {
                    tmp = CharBuffer.allocate(6);
                }
                for (int i = 0; i < res.length(); ++i) {
                    out = ZipStringEncoding.encodeFully(enc, ZipStringEncoding.encodeSurrogate(tmp, cb.get()), out);
                }
                continue;
            }
            if (res.isOverflow()) {
                int increment = ZipStringEncoding.estimateIncrementalEncodingSize(enc, cb.remaining());
                out = ZipStringEncoding.growBufferBy(out, increment);
                continue;
            }
            if (!res.isUnderflow() && !res.isError()) continue;
            break;
        }
        enc.encode(cb, out, true);
        out.limit(out.position());
        out.rewind();
        return out.array();
    }

    public Charset getCharset() {
        return this.charset;
    }

    private CharsetDecoder newDecoder() {
        if (!this.useReplacement) {
            return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_STRING);
    }

    private CharsetEncoder newEncoder() {
        if (this.useReplacement) {
            return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(REPLACEMENT_BYTES);
        }
        return this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private static ZipStringEncoding getZipEncoding(String name) {
        Charset cs = Charset.defaultCharset();
        if (name != null) {
            try {
                cs = Charset.forName(name);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        boolean useReplacement = ZipStringEncoding.isUTF8(cs.name());
        return new ZipStringEncoding(cs, useReplacement);
    }

    static ByteBuffer growBufferBy(ByteBuffer buffer, int increment) {
        buffer.limit(buffer.position());
        buffer.rewind();
        ByteBuffer on = ByteBuffer.allocate(buffer.capacity() + increment);
        on.put(buffer);
        return on;
    }

    private static boolean isUTF8(String charsetName) {
        String actual;
        String string = actual = charsetName != null ? charsetName : Charset.defaultCharset().name();
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(actual)) {
            return true;
        }
        return StandardCharsets.UTF_8.aliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(actual));
    }

    public static String decode(boolean isUtf8, byte[] bytes, int offset, int length) {
        if (isUtf8) {
            return ZipStringEncoding.decodeUtf8(bytes, offset, length);
        }
        return ZipStringEncoding.decodeDefault(bytes, offset, length);
    }

    private static String decodeUtf8(byte[] bytes, int offset, int length) {
        try {
            return UTF8_ENCODING.decode(bytes, offset, length);
        }
        catch (IOException exception) {
            return new String(bytes, offset, length);
        }
    }

    private static String decodeDefault(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length);
    }

    public static byte[] encodeString(boolean isUtf8, String text) {
        if (text == null || text.length() == 0) {
            return new byte[0];
        }
        if (isUtf8) {
            return UTF8_ENCODING.encode(text);
        }
        return DEFAULT_ENCODING.encode(text);
    }
}

