/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.archive2.ZipSignature;
import com.reandroid.archive2.block.ZipBlock;
import java.io.IOException;
import java.io.InputStream;

public class ZipHeader
extends ZipBlock {
    private final ZipSignature expectedSignature;
    private final int minByteLength;
    private static final int OFFSET_signature = 0;

    public ZipHeader(int minByteLength, ZipSignature expectedSignature) {
        super(minByteLength);
        this.minByteLength = minByteLength;
        this.expectedSignature = expectedSignature;
    }

    @Override
    public int readBytes(InputStream inputStream) throws IOException {
        int read = this.readBasic(inputStream);
        ZipSignature sig = this.getSignature();
        if (sig != this.getExpectedSignature()) {
            return read;
        }
        return read += this.readNext(inputStream);
    }

    private int readBasic(InputStream inputStream) throws IOException {
        this.setBytesLength(this.getMinByteLength(), false);
        byte[] bytes = this.getBytesInternal();
        int beginLength = bytes.length;
        int read = inputStream.read(bytes, 0, beginLength);
        if (read != beginLength) {
            this.setBytesLength(read, false);
            if (this.getSignature() == this.expectedSignature) {
                this.setSignature(0);
            }
            return read;
        }
        return read;
    }

    int readNext(InputStream inputStream) throws IOException {
        return 0;
    }

    public boolean isValidSignature() {
        return this.getSignature() == this.getExpectedSignature();
    }

    ZipSignature getExpectedSignature() {
        return this.expectedSignature;
    }

    int getMinByteLength() {
        return this.minByteLength;
    }

    public ZipSignature getSignature() {
        return ZipSignature.valueOf(this.getSignatureValue());
    }

    public int getSignatureValue() {
        if (this.countBytes() < 4) {
            return 0;
        }
        return this.getInteger(0);
    }

    public void setSignature(int value) {
        if (this.countBytes() < 4) {
            return;
        }
        this.putInteger(0, value);
    }

    public void setSignature(ZipSignature signature) {
        this.setSignature(signature == null ? 0 : signature.getValue());
    }
}

